/*
 * Decompiled with CFR 0.152.
 */
package DuganCP;

import DuganCP.Channel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class UDPComm
implements Runnable {
    public static final int BLOCK_SIZE = 512;
    public static final int N_CHANNELS_8 = 8;
    public static final int N_CHANNELS_16 = 16;
    public static final int N_E1_ANALOG_CHANNELS = 8;
    public static final int N_E2_ANALOG_CHANNELS = 12;
    public static final int N_E3_AES_CHANNELS = 14;
    public static final int N_E2A_ANALOG_CHANNELS = 12;
    public static final int N_E3A_AES_CHANNELS = 16;
    public static final int N_DANTE_CHANNELS = 64;
    public static final int N_MADI_CHANNELS = 64;
    public static final int MAX_DANTE_CHANNELS = 64;
    public static final int MAX_MADI_CHANNELS = 64;
    public static final int MAX_CHANNELS = 64;
    public static final int N_96K_CHANNELS = 32;
    public static final int MAX_E2A_CHANNELS = 28;
    public static final int MAX_E3A_CHANNELS = 32;
    public static final int MAX_PY_CHANNELS = 64;
    public static final int N_GROUPS = 3;
    public static final int E1_N_MIXES = 8;
    public static final int E2_N_MIXES = 4;
    public static final int E3_N_MIXES = 6;
    public static final int E2A_N_MIXES = 6;
    public static final int E3A_N_MIXES = 6;
    public static final int N_N_MIXES = 6;
    public static final int M_N_MIXES = 6;
    public static final int PY_N_MIXES = 6;
    public static final int MAX_N_MIXES = 8;
    public static final int E3_MIXER_ROW_LEN = 48;
    public static final int E2A_MIXER_ROW_LEN = 56;
    public static final int E3A_MIXER_ROW_LEN = 64;
    public static final int N_MIXER_ROW_LEN = 144;
    public static final int M_MIXER_ROW_LEN = 144;
    public static final int PY_MIXER_ROW_LEN = 144;
    public static final int MAX_MIXER_ROW_LEN = 144;
    public static final int MAX_MIXER_AUTO_MIXES = 32;
    public static final int nPresets = 32;
    public static final int nameLen = 16;
    public static final int SOCKET_QUERY = 1;
    public static final int PING_PERIOD = 10000;
    public static final int CONFIG_QUERY = 30000;
    public static final int STATUS_QUERY = 5000;
    public static final int ONLINE_CHECK_PERIOD = 1000;
    public static final int OFFLINE_TIMEOUT = 10000;
    public static final int e3NoChSelectVersion = 110;
    public static final int e2NoChSelectVersion = 103;
    public static final int modelNHasMixerVersion = 110;
    public static final int modelMHasMixerVersion = 110;
    private static final int DUGAN_PORT = 9776;
    private static final int FIFO_CAPACITY = 512;
    private static final int SYSTEM_BLINK_ON_PERIOD = 800;
    private static final int SYSTEM_BLINK_OFF_PERIOD = 200;
    private static final int MAX_SCENES_RETRIEVED = 32;
    public static final int MAX_SCENES = 512;
    private static final int FORCE_UPDATE_COUNT = 100;
    private static final String MULTICAST_NETWORK = "237.1.4.";
    private boolean exitNow = false;
    private boolean adatAudio;
    private boolean useDHCP;
    private boolean headroom;
    private boolean cardMode;
    private int lastHold = 0;
    private boolean masterMode;
    private boolean groupSpecificMaster;
    private int systemMute;
    private int systemOverride;
    private int systemPreset;
    private int fwversion;
    private DevType devType;
    private int nChannels;
    private boolean[] signalPresence;
    private boolean[] signalClip;
    private int[] musicInCh;
    private int linkGroup;
    private String unitName;
    private double[] autoMixDepth;
    private boolean[] bypass;
    private ChMode[] channelPreset;
    private ChMode[] channelMode;
    private boolean[] channelOverride;
    private double[] channelWeight;
    private int[] groupAssign;
    private short[] gainCal;
    private boolean[] nomEnable;
    private boolean[] useMusicRef;
    private double[] musicThreshold;
    private double[] nomGainLimit;
    private double[] autoMixGain;
    private int[] iAutoMixGain;
    private double[] gainLimit;
    private int[] iGainLimit;
    private int[] musicRefPeak;
    private int[] signalRefPeak;
    private int blinkMute;
    private String[] channelName;
    private String cmdSeparator;
    private int[] inputLevel;
    private int[] outputLevel;
    private boolean isOnline;
    private boolean oldCmdSet;
    private int lastCmdIsGS;
    private long lastGPPacket;
    private long lastGSPacket;
    private long lastPacketAt;
    private long lastOnlineCheck;
    private long lastPing;
    private long nextBlinkAt;
    private DatagramSocket querySocket;
    private DatagramPacket rcvrPacket;
    private InetAddress targetIP;
    private String targetIPAddress;
    private String targetNetmask;
    private String targetGateway;
    private String targetMAC;
    private byte[] macAddress;
    private String[] cmdStrFIFO;
    private Cmd[] cmdFIFO;
    private boolean[] cmdUseMulticast;
    private InetAddress multicastIP;
    private int fifoInPtr;
    private int fifoOutPtr;
    private boolean blinkState = true;
    private boolean cp2Alive = false;
    private boolean adat16Ch = false;
    private int adatEcho = 8;
    private boolean aes14Ch = false;
    private int clockSource;
    private int autoClockSource;
    private Channel.BarMode bargraphMode;
    private boolean nomShown = false;
    private boolean linkedToModelK = true;
    private int chToUpdate = -1;
    private int nScenes = 0;
    private ArrayList<String> scenes;
    private boolean sceneChanged = false;
    private String activeScene;
    private int forceUpdateCnt = 100;
    private boolean forceUpdateRequested = false;
    private int gpPending = 0;
    private int[] optionFlags;
    private int nSlaves = 0;
    private boolean clockIs48k = true;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public UDPComm() {
        this.DEVICE_Initialize();
    }

    private void DEVICE_Initialize() {
        this.targetIP = null;
        this.targetIPAddress = "";
        this.nChannels = 8;
        this.unitName = "Unititled";
        this.adatAudio = false;
        this.useDHCP = false;
        this.headroom = false;
        this.cardMode = true;
        this.lastHold = 0;
        this.masterMode = true;
        this.oldCmdSet = false;
        this.cp2Alive = false;
        this.lastCmdIsGS = 0;
        this.cmdSeparator = ",";
        this.groupSpecificMaster = false;
        this.systemMute = 0;
        this.systemOverride = 0;
        this.systemPreset = 0;
        this.linkGroup = 0;
        this.blinkMute = -1;
        this.macAddress = new byte[6];
        this.signalPresence = new boolean[64];
        this.signalClip = new boolean[64];
        this.autoMixDepth = new double[3];
        this.bypass = new boolean[64];
        this.channelPreset = new ChMode[64];
        this.channelMode = new ChMode[64];
        this.channelOverride = new boolean[64];
        this.channelWeight = new double[64];
        this.groupAssign = new int[64];
        this.gainCal = new short[64];
        this.nomEnable = new boolean[64];
        this.useMusicRef = new boolean[64];
        this.musicThreshold = new double[3];
        this.musicInCh = new int[3];
        this.nomGainLimit = new double[3];
        this.autoMixGain = new double[64];
        this.iAutoMixGain = new int[64];
        this.gainLimit = new double[3];
        this.iGainLimit = new int[3];
        this.musicRefPeak = new int[3];
        this.signalRefPeak = new int[3];
        this.blinkMute = -1;
        this.channelName = new String[64];
        this.inputLevel = new int[64];
        this.outputLevel = new int[64];
        this.cmdStrFIFO = new String[512];
        this.cmdFIFO = new Cmd[512];
        this.cmdUseMulticast = new boolean[512];
        this.scenes = new ArrayList();
        this.fifoOutPtr = 0;
        this.fifoInPtr = 0;
        this.optionFlags = new int[3];
        this.optionFlags[2] = 0;
        this.optionFlags[1] = 0;
        this.optionFlags[0] = 0;
        this.bargraphMode = Channel.BarMode.BAR_AUTOMIX_GAIN;
        int i = 0;
        while (i < 64) {
            this.signalPresence[i] = false;
            this.signalClip[i] = false;
            this.bypass[i] = true;
            this.channelOverride[i] = false;
            this.channelMode[i] = ChMode.AUTOMIX;
            this.channelName[i] = String.format("Channel %d", i + 1);
            this.channelPreset[i] = ChMode.AUTOMIX;
            this.channelWeight[i] = 0.0;
            this.groupAssign[i] = 0;
            this.nomEnable[i] = false;
            this.useMusicRef[i] = false;
            this.inputLevel[i] = -1;
            this.outputLevel[i] = -1;
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.autoMixDepth[i] = -60.0;
            this.nomGainLimit[i] = -60.0;
            this.musicThreshold[i] = -60.0;
            this.musicRefPeak[i] = -1;
            this.signalRefPeak[i] = -1;
            ++i;
        }
        this.isOnline = true;
        this.gpPending = 0;
        this.lastGPPacket = System.currentTimeMillis();
        this.lastGSPacket = System.currentTimeMillis();
        this.lastPacketAt = System.currentTimeMillis();
        this.lastPing = System.currentTimeMillis();
        this.nextBlinkAt = System.currentTimeMillis();
        try {
            this.querySocket = new DatagramSocket();
            this.querySocket.setSoTimeout(1);
        }
        catch (SocketException ex) {
            Logger.getLogger(UDPComm.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.rcvrPacket = new DatagramPacket(new byte[1536], 1536);
    }

    public void exit() {
        this.exitNow = true;
    }

    @Override
    public void run() {
        while (!this.exitNow) {
            this.CheckSystemBlink();
            if (this.fifoInPtr != this.fifoOutPtr) {
                int timeout = this.cmdFIFO[this.fifoOutPtr] == Cmd.EA ? 1000 : 200;
                if (this.isOnline) {
                    byte[] outbuf = this.cmdStrFIFO[this.fifoOutPtr].getBytes();
                    this.SendBufferCmd(outbuf, outbuf.length, this.cmdFIFO[this.fifoOutPtr], timeout, 3, this.cmdUseMulticast[this.fifoOutPtr]);
                    if (this.cmdFIFO[this.fifoOutPtr] == Cmd.GP) {
                        --this.gpPending;
                    }
                }
                this.fifoOutPtr = (this.fifoOutPtr + 1) % 512;
                continue;
            }
            this.DoChore();
        }
        this.SendString("SU,0\r\n");
        this.exit();
    }

    void CheckSystemBlink() {
        long currentTime;
        if (this.devType == DevType.MODEL_K) {
            return;
        }
        if ((this.systemMute != 0 || this.systemOverride != 0) && (currentTime = System.currentTimeMillis()) > this.nextBlinkAt) {
            if (this.blinkState) {
                this.nextBlinkAt = currentTime + 200L;
                this.propertyChangeSupport.firePropertyChange("SystemBlink", true, false);
            } else {
                this.nextBlinkAt = currentTime + 800L;
                this.propertyChangeSupport.firePropertyChange("SystemBlink", false, true);
            }
            this.blinkState = !this.blinkState;
        }
    }

    public void DoChore() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastPing > 10000L) {
            this.lastPing = currentTime;
            this.SendString("PN");
        }
        if (this.devType != DevType.MODEL_K) {
            if (currentTime - this.lastOnlineCheck > 1000L) {
                this.lastOnlineCheck = currentTime;
                if (this.isOnline && currentTime - this.lastPacketAt > 10000L) {
                    this.isOnline = false;
                    this.propertyChangeSupport.firePropertyChange("offline", false, true);
                }
            }
            if (currentTime - this.lastGPPacket > 30000L) {
                this.lastGPPacket = System.currentTimeMillis();
                this.UpdateConfig();
            }
            if (this.forceUpdateRequested) {
                this.forceUpdateRequested = false;
                this.lastGSPacket = System.currentTimeMillis();
                this.forceUpdateCnt = 100;
                this.SendString("GS\r\n");
            } else if (currentTime - this.lastGSPacket > 5000L) {
                this.lastGSPacket = System.currentTimeMillis();
                this.SendString("GS\r\n");
            }
            if (this.chToUpdate >= 0) {
                this.UpdateChannel(this.chToUpdate);
                this.chToUpdate = -1;
            }
        }
        try {
            this.querySocket.setSoTimeout(5);
        }
        catch (SocketException ex) {
            Logger.getLogger(UDPComm.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.ReadSocket(25);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, l);
    }

    public void UpdateConfig() {
        if (this.oldCmdSet) {
            this.AddToFIFO("SU 0\r\n", Cmd.SU, false);
            this.AddToFIFO("NA", Cmd.NA, false);
        } else {
            this.AddToFIFO("SU,0\r\n", Cmd.SU, false);
            this.AddToFIFO("LG\r\n", Cmd.LG, false);
            this.AddToFIFO("NA\r\n", Cmd.NA, false);
        }
        this.AddToFIFO("GP\r\n", Cmd.GP, false);
        this.AddToFIFO("VE\r\n", Cmd.VE, false);
        this.AddToFIFO("MM\r\n", Cmd.MM, false);
        switch (this.devType) {
            case MODEL_E2: {
                this.AddToFIFO("HR\r\n", Cmd.HR, false);
                if (this.getVersion() > 103) {
                    this.AddToFIFO("MC,1;MC,2;MC,3\r\n", Cmd.MC, false);
                }
                this.AddToFIFO("GM\r\n", Cmd.GM, false);
                if ((this.optionFlags[0] & 1) != 0) {
                    this.AddToFIFO(String.format("CNS,1,%d\r\n", this.nChannels), Cmd.CNS, false);
                    break;
                }
                int i = 0;
                while (i < this.nChannels) {
                    this.AddToFIFO(String.format("CN,%d\r\n", i + 1), Cmd.CN, false);
                    ++i;
                }
                break;
            }
            case MODEL_E3: {
                if (this.getVersion() > 110) {
                    this.AddToFIFO("MC,1;MC,2;MC,3\r\n", Cmd.MC, false);
                }
                this.AddToFIFO("GM\r\n", Cmd.GM, false);
                if ((this.optionFlags[0] & 1) != 0) {
                    this.AddToFIFO(String.format("CNS,1,%d\r\n", this.nChannels), Cmd.CNS, false);
                    break;
                }
                int i = 0;
                while (i < this.nChannels) {
                    this.AddToFIFO(String.format("CN,%d\r\n", i + 1), Cmd.CN, false);
                    ++i;
                }
                break;
            }
            case MODEL_E2A: 
            case MODEL_E3A: {
                this.AddToFIFO("SNA\r\n", Cmd.SNA, false);
                this.AddToFIFO("SNC\r\n", Cmd.SNC, false);
                this.AddToFIFO("GM\r\n", Cmd.GM, false);
                int k = this.nChannels;
                int i = 1;
                while (k > 0) {
                    int j = k >= 16 ? 16 : k;
                    this.AddToFIFO(String.format("CNS,%d,%d\r\n", i, j), Cmd.CNS, false);
                    i += j;
                    k -= j;
                }
                break;
            }
            case MODEL_PY: {
                this.AddToFIFO("GM\r\n", Cmd.GM, false);
                int k = this.nChannels;
                int i = 1;
                while (k > 0) {
                    int j = k >= 16 ? 16 : k;
                    this.AddToFIFO(String.format("CNS,%d,%d\r\n", i, j), Cmd.CNS, false);
                    i += j;
                    k -= j;
                }
                break;
            }
            case MODEL_M: 
            case MODEL_N: {
                this.AddToFIFO("SNA\r\n", Cmd.SNA, false);
                this.AddToFIFO("SNC\r\n", Cmd.SNC, false);
                if (this.HasMixer()) {
                    this.AddToFIFO("GM\r\n", Cmd.GM, false);
                }
                int k = this.nChannels;
                int i = 1;
                while (k > 0) {
                    int j = k >= 16 ? 16 : k;
                    this.AddToFIFO(String.format("CNS,%d,%d\r\n", i, j), Cmd.CNS, false);
                    i += j;
                    k -= j;
                }
                break;
            }
            default: {
                this.AddToFIFO("HR\r\n", Cmd.HR, false);
                if (this.oldCmdSet) break;
                if ((this.optionFlags[0] & 1) != 0) {
                    this.AddToFIFO(String.format("CNS,1,%d\r\n", this.nChannels), Cmd.CNS, false);
                    break;
                }
                int i = 0;
                while (i < this.nChannels) {
                    this.AddToFIFO(String.format("CN,%d\r\n", i + 1), Cmd.CN, false);
                    ++i;
                }
                break block0;
            }
        }
        if (this.oldCmdSet) {
            this.AddToFIFO("SU 2\r\n", Cmd.SU, false);
        } else {
            this.AddToFIFO("SU,2\r\n", Cmd.SU, false);
        }
    }

    public void UpdateChannel(int whichCh) {
        this.AddToFIFO("SU,0\r\n", Cmd.SU, false);
        this.AddToFIFO(String.format("BP,%d\r\n", ++whichCh), Cmd.BP, false);
        this.AddToFIFO(String.format("CW,%d\r\n", whichCh), Cmd.CW, false);
        this.AddToFIFO(String.format("CM,%d\r\n", whichCh), Cmd.CM, false);
        this.AddToFIFO(String.format("CO,%d\r\n", whichCh), Cmd.CO, false);
        this.AddToFIFO(String.format("CP,%d\r\n", whichCh), Cmd.CP, false);
        this.AddToFIFO(String.format("GA,%d\r\n", whichCh), Cmd.GA, false);
        this.AddToFIFO(String.format("MR,%d\r\n", whichCh), Cmd.MR, false);
        this.AddToFIFO(String.format("NE,%d\r\n", whichCh), Cmd.NE, false);
        this.AddToFIFO("SU,2\r\n", Cmd.SU, false);
    }

    private boolean SendBuffer(byte[] buf, int length, boolean useMulticastIP) {
        if (this.targetIP == null) {
            return true;
        }
        DatagramPacket p = useMulticastIP ? new DatagramPacket(buf, length, this.multicastIP, 9776) : new DatagramPacket(buf, length, this.targetIP, 9776);
        try {
            this.querySocket.send(p);
            return true;
        }
        catch (IOException ex) {
            Logger.getLogger(UDPComm.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    private boolean SendString(String str) {
        return this.SendBuffer(str.getBytes(), str.length(), false);
    }

    private Cmd ReadSocket(int timeOut) {
        block6: {
            boolean gotPacket = false;
            try {
                try {
                    this.querySocket.receive(this.rcvrPacket);
                    gotPacket = true;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    // empty catch block
                }
                if (gotPacket) {
                    if (this.rcvrPacket.getLength() > 2) {
                        return this.ParsePackets(this.rcvrPacket);
                    }
                    break block6;
                }
                return Cmd.TIMEOUT;
            }
            catch (Exception ex) {
                Logger.getLogger(UDPComm.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return Cmd.ERROR;
    }

    private boolean SendBufferCmd(byte[] buf, int length, Cmd cmd, int timeOut, int nTries, boolean useMulticastIP) {
        if (this.targetIP == null) {
            return true;
        }
        try {
            this.querySocket.setSoTimeout(2);
        }
        catch (SocketException ex) {
            Logger.getLogger(UDPComm.class.getName()).log(Level.SEVERE, null, ex);
        }
        int i = 0;
        while (i < nTries) {
            this.SendBuffer(buf, length, useMulticastIP);
            int j = 0;
            while (j < timeOut) {
                Cmd ret = this.ReadSocket(2);
                if (ret == cmd) {
                    return true;
                }
                if (ret != Cmd.TIMEOUT) {
                    ++j;
                }
                ++j;
            }
            ++i;
        }
        System.out.printf("    Timeout waiting for response for command %s at %d\n", cmd.name(), System.currentTimeMillis() % 86400000L);
        return false;
    }

    private void ParseScene(String inStr) {
        String[] strs = inStr.split(",");
        if (strs.length < 3) {
            return;
        }
        int start = Integer.parseInt(strs[0]) - 1;
        if (start < 0) {
            return;
        }
        int ns = Integer.parseInt(strs[1]);
        if (ns != strs.length - 2) {
            ns = strs.length - 2;
        }
        if (start == 0) {
            this.scenes.clear();
        }
        if (start >= this.scenes.size()) {
            int i = 0;
            while (i < ns) {
                this.scenes.add(strs[i + 2]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < ns) {
                this.scenes.add(start, strs[i + 2]);
                ++start;
                ++i;
            }
        }
    }

    private float BytesToFloat(byte[] val, int start) {
        int iVal;
        if (this.oldCmdSet) {
            iVal = val[start++] & 0xFF;
            iVal = iVal << 8 | val[start++] & 0xFF;
            iVal = iVal << 8 | val[start++] & 0xFF;
            iVal = iVal << 8 | val[start] & 0xFF;
        } else {
            iVal = val[start++] & 0xFF;
            iVal += (val[start++] & 0xFF) << 8;
            iVal += (val[start++] & 0xFF) << 16;
            iVal += (val[start++] & 0xFF) << 24;
        }
        return Float.intBitsToFloat(iVal);
    }

    private int FindLength(byte[] inbuf, int start) {
        int len = 0;
        int i = start;
        while (i < inbuf.length) {
            if (inbuf[i] == 0) {
                return len;
            }
            if (++len >= 16) {
                return len;
            }
            ++i;
        }
        return len;
    }

    private Cmd ParsePackets(DatagramPacket pkt) {
        byte[] inbuf = (byte[])pkt.getData().clone();
        int inLen = pkt.getLength();
        String srcIP = pkt.getAddress().getHostAddress();
        if (srcIP.compareTo(this.targetIPAddress) != 0) {
            System.out.printf("Target IP mismatch!\n", new Object[0]);
            return Cmd.ERROR;
        }
        this.lastPacketAt = System.currentTimeMillis();
        if (!this.isOnline) {
            this.isOnline = true;
            this.propertyChangeSupport.firePropertyChange("offline", true, false);
            this.UpdateConfig();
        }
        if (inbuf[0] != 42) {
            return this.ProcessPacket(srcIP, inbuf, inLen);
        }
        if (inbuf[1] == 71 && (inbuf[2] == 80 || inbuf[2] == 83 || inbuf[2] == 77)) {
            Cmd ret = this.ProcessPacket(srcIP, inbuf, inLen);
            if (ret == Cmd.GP) {
                this.lastGSPacket = System.currentTimeMillis() - 4900L;
            }
            return ret;
        }
        String fullStr = new String(inbuf, 0, inLen);
        String[] strs = fullStr.split(";");
        if (strs.length == 0) {
            return Cmd.ERROR;
        }
        inbuf = strs[0].getBytes();
        Cmd ret = this.ProcessPacket(srcIP, inbuf, inbuf.length);
        int i = 1;
        while (i < strs.length) {
            inbuf = strs[i].getBytes();
            this.ProcessPacket(srcIP, inbuf, inbuf.length);
            ++i;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private Cmd ProcessPacket(String srcIP, byte[] inbuf, int inLen) {
        tmpValues = new int[64];
        fullStr = new String(inbuf, 0, inLen).trim();
        bForceGS = false;
        if (inbuf[0] == 42) {
            inbuf[0] = inbuf[1];
            inbuf[1] = inbuf[2];
            if (inbuf[3] != 44 && inbuf[3] != 13) {
                inbuf[2] = inbuf[3];
                inStr = new String(inbuf, 4, inLen - 4).trim();
            } else {
                inStr = new String(inbuf, 3, inLen - 3).trim();
            }
            offset = 1;
        } else {
            inStr = new String(inbuf, 2, inLen - 2).trim();
            offset = 0;
        }
        if (inStr.indexOf(",") == 0) {
            inStr = inStr.substring(1);
        }
        if (inStr.contains("Error")) {
            if (inbuf[0] == 80 && inbuf[1] == 83) {
                this.propertyChangeSupport.firePropertyChange("error", "", inStr);
            }
            System.out.printf("ProcessPacket Error: %s", new Object[]{fullStr});
            return Cmd.ERROR;
        }
        strs = inStr.split(",");
        if (inbuf[0] >= 97 && inbuf[0] <= 122) {
            inbuf[0] = (byte)(inbuf[0] - 97 + 65);
        }
        if (inbuf[1] >= 97 && inbuf[1] <= 122) {
            inbuf[1] = (byte)(inbuf[1] - 97 + 65);
        }
        if (inbuf[2] >= 97 && inbuf[2] <= 122) {
            inbuf[2] = (byte)(inbuf[2] - 97 + 65);
        }
        if (inbuf[0] == 71 && inbuf[1] == 83) {
            ++this.lastCmdIsGS;
            if (this.lastCmdIsGS >= 32) {
                this.lastCmdIsGS = 0;
            }
        } else {
            this.lastCmdIsGS = 0;
        }
        switch (inbuf[0]) {
            case 65: {
                switch (inbuf[1]) {
                    case 65: {
                        if (strs.length < 1) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]);
                        bOld = this.adatAudio;
                        this.adatAudio = bVal = i != 0;
                        this.propertyChangeSupport.firePropertyChange("adatAudio", bVal == false, bVal);
                        return Cmd.AA;
                    }
                    case 68: {
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]) - 1;
                        this.autoMixDepth[i] = dVal = Double.parseDouble(strs[1]);
                        this.propertyChangeSupport.fireIndexedPropertyChange("autoMixDepth", i, dVal - 1.0, dVal);
                        return Cmd.AD;
                    }
                    case 77: {
                        if (strs.length < 1) {
                            return Cmd.ERROR;
                        }
                        if (this.devType == DevType.MODEL_M || this.devType == DevType.MODEL_N) {
                            if (this.adatAudio) {
                                this.adat16Ch = Integer.parseInt(strs[0]) == 2;
                                this.propertyChangeSupport.firePropertyChange("Adat16Channels", this.adat16Ch == false, this.adat16Ch);
                            } else {
                                this.adatEcho = Integer.parseInt(strs[0]) * 8;
                                this.propertyChangeSupport.firePropertyChange("Adat16Channels", this.adatEcho == 8, this.adatEcho == 16);
                            }
                            this.lastGPPacket = 0L;
                        } else {
                            this.adat16Ch = Integer.parseInt(strs[0]) == 2;
                            this.propertyChangeSupport.firePropertyChange("Adat16Channels", this.adat16Ch == false, this.adat16Ch);
                        }
                        return Cmd.AM;
                    }
                }
                System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                return Cmd.ERROR;
            }
            case 66: {
                switch (inbuf[1]) {
                    case 80: {
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]) - 1;
                        j = Integer.parseInt(strs[1]);
                        bVal = j != 0;
                        this.propertyChangeSupport.firePropertyChange(String.format("bypass%d", new Object[]{i}), bVal == false, bVal);
                        this.propertyChangeSupport.fireIndexedPropertyChange("bypass", i, bVal == false, bVal);
                        if ((this.devType == DevType.MODEL_M || this.devType == DevType.MODEL_N) && this.bypass[i] != bVal) {
                            this.chToUpdate = i;
                        }
                        this.bypass[i] = bVal;
                        return Cmd.BP;
                    }
                }
                break;
            }
            case 67: {
                switch (inbuf[1]) {
                    case 70: {
                        if (inbuf[2] == 78) {
                            if (strs.length != 1) {
                                return Cmd.ERROR;
                            }
                            i = Integer.parseInt(strs[0]);
                            this.propertyChangeSupport.firePropertyChange("nChannels", 0, i);
                            this.lastGPPacket = 0L;
                            return Cmd.CFN;
                        }
                        return Cmd.ERROR;
                    }
                    case 77: {
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]) - 1;
                        j = Integer.parseInt(strs[1]);
                        cmVal = j == ChMode.MANUAL.ordinal() ? ChMode.MANUAL : (j == ChMode.AUTOMIX.ordinal() ? ChMode.AUTOMIX : ChMode.MUTE);
                        this.channelMode[i] = cmVal;
                        if (!this.bypass[i]) {
                            this.propertyChangeSupport.firePropertyChange(String.format("channelMode%d", new Object[]{i}), (Object)ChMode.NONE, (Object)cmVal);
                            this.propertyChangeSupport.fireIndexedPropertyChange("channelMode", i, (Object)ChMode.NONE, (Object)cmVal);
                        }
                        return Cmd.CM;
                    }
                    case 78: {
                        if (inbuf[2] == 83) {
                            j = Integer.parseInt(strs[0]) - 1;
                            i = 0;
                            while (i < strs.length - 2) {
                                this.channelName[j] = strs[i + 2];
                                this.propertyChangeSupport.firePropertyChange(String.format("channelName%d", new Object[]{j}), "", strs[i + 2]);
                                ++i;
                                ++j;
                            }
                            return Cmd.CNS;
                        }
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]) - 1;
                        this.channelName[i] = strs[1];
                        this.propertyChangeSupport.firePropertyChange(String.format("channelName%d", new Object[]{i}), "", strs[1]);
                        return Cmd.CN;
                    }
                    case 79: {
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]) - 1;
                        j = Integer.parseInt(strs[1]);
                        this.channelOverride[i] = bVal = j != 0;
                        if (!this.bypass[i]) {
                            this.propertyChangeSupport.firePropertyChange(String.format("channelOverride%d", new Object[]{i}), bVal == false, bVal);
                        }
                        return Cmd.CO;
                    }
                    case 80: {
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]) - 1;
                        j = Integer.parseInt(strs[1]);
                        cmVal = j == ChMode.MANUAL.ordinal() ? ChMode.MANUAL : (j == ChMode.AUTOMIX.ordinal() ? ChMode.AUTOMIX : ChMode.MUTE);
                        this.channelPreset[i] = cmVal;
                        if (!this.bypass[i]) {
                            this.propertyChangeSupport.firePropertyChange(String.format("channelPreset%d", new Object[]{i}), (Object)ChMode.NONE, (Object)cmVal);
                        }
                        return Cmd.CP;
                    }
                    case 83: {
                        if (strs.length < 1) {
                            return Cmd.ERROR;
                        }
                        this.clockSource = Integer.parseInt(strs[0]);
                        this.propertyChangeSupport.firePropertyChange("ClockSource", this.clockSource - 1, this.clockSource);
                        return Cmd.CS;
                    }
                    case 87: {
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]) - 1;
                        this.channelWeight[i] = dVal = Double.parseDouble(strs[1]);
                        this.propertyChangeSupport.firePropertyChange(String.format("channelWeight%d", new Object[]{i}), dVal - 1.0, dVal);
                        return Cmd.CW;
                    }
                }
                System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                return Cmd.ERROR;
            }
            case 68: {
                switch (inbuf[1]) {
                    case 72: {
                        i = Integer.parseInt(inStr);
                        bOld = this.useDHCP;
                        v0 = bVal = i != 0;
                        if (bOld && !bVal || !bOld && bVal) {
                            this.useDHCP = bVal;
                            this.propertyChangeSupport.firePropertyChange("dhcp", bOld, bVal);
                        }
                        return Cmd.DH;
                    }
                    case 76: {
                        i = Integer.parseInt(strs[0]);
                        j = Integer.parseInt(strs[1]);
                        switch (i) {
                            case 0: {
                                return Cmd.DLS;
                            }
                            case 1: {
                                return Cmd.DLA;
                            }
                            case 2: {
                                return Cmd.DLD;
                            }
                            case 3: {
                                return Cmd.DLP_DSP;
                            }
                            case 4: {
                                return Cmd.DLP_LCA;
                            }
                            case 5: {
                                return Cmd.DLUS;
                            }
                            case 6: {
                                return Cmd.DLUD;
                            }
                            case 7: {
                                return Cmd.DLP_UCC;
                            }
                            case 8: {
                                return Cmd.DLP;
                            }
                        }
                        System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                        return Cmd.ERROR;
                    }
                    case 78: {
                        return Cmd.DN;
                    }
                    case 80: {
                        if (strs[0].contains("OK")) {
                            return Cmd.DP;
                        }
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        this.propertyChangeSupport.firePropertyChange("displayChange", "", String.valueOf(strs[0]) + "," + strs[1]);
                        return Cmd.DP;
                    }
                }
                System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                return Cmd.ERROR;
            }
            case 69: {
                switch (inbuf[1]) {
                    case 65: {
                        if (strs.length < 1) {
                            return Cmd.ERROR;
                        }
                        this.aes14Ch = Integer.parseInt(strs[0]) != 0;
                        this.propertyChangeSupport.firePropertyChange("AES14Channels", this.aes14Ch == false, this.aes14Ch);
                        return Cmd.EA;
                    }
                }
                System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                return Cmd.ERROR;
            }
            case 70: {
                switch (inbuf[1]) {
                    case 80: {
                        return Cmd.FP;
                    }
                }
                System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                return Cmd.ERROR;
            }
            case 71: {
                switch (inbuf[1]) {
                    case 65: {
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]) - 1;
                        j = Integer.parseInt(strs[1]);
                        if (j != (iOld = this.groupAssign[i] + 1)) {
                            this.groupAssign[i] = j - 1;
                            this.propertyChangeSupport.firePropertyChange(String.format("groupAssign%d", new Object[]{i}), iOld, j);
                            if (this.devType == DevType.MODEL_M || this.devType == DevType.MODEL_N) {
                                this.chToUpdate = i;
                            }
                        }
                        this.CheckGroups();
                        return Cmd.GA;
                    }
                    case 67: {
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]);
                        j = Integer.parseInt(strs[1]);
                        this.gainCal[i - 1] = (short)j;
                        this.propertyChangeSupport.fireIndexedPropertyChange("gainCal", i, j - 1, j);
                        return Cmd.GC;
                    }
                    case 77: {
                        this.propertyChangeSupport.firePropertyChange("mixerParams", null, inbuf);
                        return Cmd.GM;
                    }
                    case 80: {
                        this.lastGPPacket = System.currentTimeMillis();
                        if (!this.oldCmdSet) ** GOTO lbl409
                        if (inbuf.length < 248) {
                            return Cmd.ERROR;
                        }
                        this.nChannels = 8;
                        this.propertyChangeSupport.firePropertyChange("nChannels", 0, this.nChannels);
                        i = 255 & inbuf[offset + 3];
                        this.masterMode = bVal = (i & 1) != 0;
                        this.propertyChangeSupport.firePropertyChange("master", bVal == false, bVal);
                        this.headroom = bVal = (i & 2) != 0;
                        this.propertyChangeSupport.firePropertyChange("headroom", bVal == false, bVal);
                        bVal = (i & 4) != 0;
                        this.systemMute = bVal != false ? 1 : 0;
                        this.propertyChangeSupport.firePropertyChange("systemMute", -1, this.systemMute);
                        bVal = (i & 8) != 0;
                        this.systemOverride = bVal != false ? 1 : 0;
                        this.propertyChangeSupport.firePropertyChange("systemOverride", -1, this.systemOverride);
                        bVal = (i & 16) != 0;
                        this.systemPreset = bVal != false ? 1 : 0;
                        this.propertyChangeSupport.firePropertyChange("systemPreset", -1, this.systemPreset);
                        i = 0;
                        while (i < this.nChannels) {
                            iVal = inbuf[offset + 4 + i];
                            if (iVal != ChMode.MANUAL.ordinal()) ** GOTO lbl279
                            cmVal = ChMode.MANUAL;
                            ** GOTO lbl284
lbl279:
                            // 1 sources

                            if (iVal != ChMode.AUTOMIX.ordinal()) ** GOTO lbl282
                            cmVal = ChMode.AUTOMIX;
                            ** GOTO lbl284
lbl282:
                            // 1 sources

                            if (iVal != ChMode.MUTE.ordinal()) ** GOTO lbl288
                            cmVal = ChMode.MUTE;
lbl284:
                            // 3 sources

                            this.channelMode[i] = cmVal;
                            if (!this.bypass[i]) {
                                this.propertyChangeSupport.firePropertyChange(String.format("channelMode%d", new Object[]{i}), (Object)ChMode.NONE, (Object)cmVal);
                                this.propertyChangeSupport.fireIndexedPropertyChange("channelMode", i, (Object)ChMode.NONE, (Object)cmVal);
                            }
lbl288:
                            // 4 sources

                            ++i;
                        }
                        j = offset + 4 + this.nChannels;
                        j += 16;
                        i = 0;
                        while (i < this.nChannels) {
                            str = new String(inbuf, j, this.FindLength(inbuf, j));
                            inStr = this.channelName[i];
                            this.channelName[i] = str;
                            this.propertyChangeSupport.firePropertyChange(String.format("channelName%d", new Object[]{i}), "", str);
                            j += 16;
                            ++i;
                        }
                        this.adatAudio = bVal = inbuf[j++] != 0;
                        this.propertyChangeSupport.firePropertyChange("adatAudio", bVal == false, bVal);
                        this.lastHold = iVal = inbuf[j++];
                        this.propertyChangeSupport.firePropertyChange("lastHold", iVal - 1, iVal);
                        iVal = inbuf[j++];
                        i = 0;
                        while (i < this.nChannels) {
                            this.bypass[i] = bVal = (iVal & 1) != 0;
                            this.propertyChangeSupport.firePropertyChange(String.format("bypass%d", new Object[]{i}), bVal == false, bVal);
                            this.propertyChangeSupport.fireIndexedPropertyChange("bypass", i, bVal == false, bVal);
                            iVal >>= 1;
                            ++i;
                        }
                        iVal = inbuf[j++];
                        i = 0;
                        while (i < this.nChannels) {
                            this.nomEnable[i] = bVal = (iVal & 1) != 0;
                            this.propertyChangeSupport.firePropertyChange(String.format("nomEnable%d", new Object[]{i}), bVal == false, bVal);
                            iVal >>= 1;
                            ++i;
                        }
                        iVal = inbuf[j++];
                        i = 0;
                        while (i < this.nChannels) {
                            this.useMusicRef[i] = bVal = (iVal & 1) != 0;
                            this.propertyChangeSupport.firePropertyChange(String.format("useMusicRef%d", new Object[]{i}), bVal == false, bVal);
                            iVal >>= 1;
                            ++i;
                        }
                        bVal = inbuf[j++] != 0;
                        iVal = inbuf[j++];
                        i = 0;
                        while (i < this.nChannels) {
                            this.channelOverride[i] = bVal = (iVal & 1) != 0;
                            if (!this.bypass[i]) {
                                this.propertyChangeSupport.firePropertyChange(String.format("channelOverride%d", new Object[]{i}), bVal == false, bVal);
                            }
                            iVal >>= 1;
                            ++i;
                        }
                        k = 255 & inbuf[j];
                        k = k * 256 + (255 & inbuf[j + 1]);
                        j += 2;
                        i = 0;
                        while (i < this.nChannels) {
                            this.groupAssign[i] = iVal = k & 3;
                            this.propertyChangeSupport.firePropertyChange(String.format("groupAssign%d", new Object[]{i}), iVal, iVal + 1);
                            k >>= 2;
                            ++i;
                        }
                        this.CheckGroups();
                        k = 255 & inbuf[j];
                        k = k * 256 + (255 & inbuf[j + 1]);
                        j += 2;
                        i = 0;
                        while (i < this.nChannels) {
                            iVal = k & 3;
                            if (iVal != ChMode.MANUAL.ordinal()) ** GOTO lbl360
                            cmVal = ChMode.MANUAL;
                            ** GOTO lbl365
lbl360:
                            // 1 sources

                            if (iVal != ChMode.AUTOMIX.ordinal()) ** GOTO lbl363
                            cmVal = ChMode.AUTOMIX;
                            ** GOTO lbl365
lbl363:
                            // 1 sources

                            if (iVal != ChMode.MUTE.ordinal()) ** GOTO lbl369
                            cmVal = ChMode.MUTE;
lbl365:
                            // 3 sources

                            this.channelPreset[i] = cmVal;
                            if (!this.bypass[i]) {
                                this.propertyChangeSupport.firePropertyChange(String.format("channelPreset%d", new Object[]{i}), (Object)ChMode.NONE, (Object)cmVal);
                            }
                            k >>= 2;
lbl369:
                            // 2 sources

                            ++i;
                        }
                        dVal = this.BytesToFloat(inbuf, j += 4);
                        this.propertyChangeSupport.firePropertyChange("safetyThreshold", dVal + 1.0, dVal);
                        dVal = this.BytesToFloat(inbuf, j += 4);
                        j += 4;
                        this.propertyChangeSupport.firePropertyChange("holdThreshold", dVal + 1.0, dVal);
                        i = 0;
                        while (i < this.nChannels) {
                            dVal = this.BytesToFloat(inbuf, j);
                            j += 4;
                            this.channelWeight[i] = dVal;
                            this.propertyChangeSupport.firePropertyChange(String.format("channelWeight%d", new Object[]{i}), dVal + 1.0, dVal);
                            ++i;
                        }
                        i = 0;
                        while (i < 3) {
                            dVal = this.BytesToFloat(inbuf, j);
                            j += 4;
                            this.musicThreshold[i] = dVal;
                            this.propertyChangeSupport.fireIndexedPropertyChange("musicThreshold", i, dVal + 1.0, dVal);
                            ++i;
                        }
                        i = 0;
                        while (i < 3) {
                            dVal = this.BytesToFloat(inbuf, j);
                            j += 4;
                            this.autoMixDepth[i] = dVal;
                            this.propertyChangeSupport.fireIndexedPropertyChange("autoMixDepth", i, dVal + 1.0, dVal);
                            ++i;
                        }
                        i = 0;
                        while (i < 3) {
                            dVal = this.BytesToFloat(inbuf, j);
                            j += 4;
                            this.nomGainLimit[i] = dVal;
                            this.propertyChangeSupport.fireIndexedPropertyChange("nomGainLimit", i, dVal + 1.0, dVal);
                            ++i;
                        }
                        ** GOTO lbl811
lbl409:
                        // 1 sources

                        if (this.devType != DevType.MODEL_M && this.devType != DevType.MODEL_N && this.devType != DevType.MODEL_E2A && this.devType != DevType.MODEL_E3A && this.devType != DevType.MODEL_PY) ** GOTO lbl612
                        switch (UDPComm.$SWITCH_TABLE$DuganCP$UDPComm$DevType()[this.devType.ordinal()]) {
                            case 12: 
                            case 13: {
                                maxChannels = 64;
                                break;
                            }
                            case 14: {
                                maxChannels = 28;
                                break;
                            }
                            case 15: {
                                maxChannels = 32;
                                break;
                            }
                            case 16: {
                                maxChannels = 64;
                                break;
                            }
                            default: {
                                maxChannels = 64;
                            }
                        }
                        offset = 4;
                        i = inbuf[offset + maxChannels] & 255;
                        if (i == 0) {
                            i = maxChannels;
                        }
                        this.propertyChangeSupport.firePropertyChange("nChannels", 0, i);
                        if (i != this.nChannels) {
                            this.nChannels = i;
                            this.propertyChangeSupport.firePropertyChange("nChannelsChange", false, true);
                        }
                        i = 0;
                        while (i < this.nChannels) {
                            if ((j = inbuf[offset++] & 255) != ChMode.MANUAL.ordinal()) ** GOTO lbl438
                            cmVal = ChMode.MANUAL;
                            ** GOTO lbl443
lbl438:
                            // 1 sources

                            if (j != ChMode.AUTOMIX.ordinal()) ** GOTO lbl441
                            cmVal = ChMode.AUTOMIX;
                            ** GOTO lbl443
lbl441:
                            // 1 sources

                            if (j != ChMode.MUTE.ordinal()) ** GOTO lbl446
                            cmVal = ChMode.MUTE;
lbl443:
                            // 3 sources

                            this.channelMode[i] = cmVal;
                            this.propertyChangeSupport.firePropertyChange(String.format("channelMode%d", new Object[]{i}), (Object)ChMode.NONE, (Object)cmVal);
                            this.propertyChangeSupport.fireIndexedPropertyChange("channelMode", i, (Object)ChMode.NONE, (Object)cmVal);
lbl446:
                            // 2 sources

                            ++i;
                        }
                        offset += maxChannels - this.nChannels;
                        ++offset;
                        i = 0;
                        while (i < (maxChannels + 7) / 8) {
                            tmpValues[i] = 255 & inbuf[offset++];
                            ++i;
                        }
                        i = 0;
                        while (i < this.nChannels) {
                            this.bypass[i] = (tmpValues[i / 8] & 1 << i % 8) != 0;
                            bVal = this.bypass[i];
                            this.propertyChangeSupport.firePropertyChange(String.format("bypass%d", new Object[]{i}), bVal == false, bVal);
                            this.propertyChangeSupport.fireIndexedPropertyChange("bypass", i, bVal == false, bVal);
                            ++i;
                        }
                        i = 0;
                        while (i < (maxChannels + 7) / 8) {
                            tmpValues[i] = 255 & inbuf[offset++];
                            ++i;
                        }
                        i = 0;
                        while (i < this.nChannels) {
                            this.nomEnable[i] = (tmpValues[i / 8] & 1 << i % 8) != 0;
                            bVal = this.nomEnable[i];
                            this.propertyChangeSupport.firePropertyChange(String.format("nomEnable%d", new Object[]{i}), bVal == false, bVal);
                            ++i;
                        }
                        i = 0;
                        while (i < (maxChannels + 7) / 8) {
                            tmpValues[i] = 255 & inbuf[offset++];
                            ++i;
                        }
                        i = 0;
                        while (i < this.nChannels) {
                            this.useMusicRef[i] = (tmpValues[i / 8] & 1 << i % 8) != 0;
                            bVal = this.useMusicRef[i];
                            this.propertyChangeSupport.firePropertyChange(String.format("useMusicRef%d", new Object[]{i}), bVal == false, bVal);
                            ++i;
                        }
                        this.propertyChangeSupport.firePropertyChange("CheckUseMusicRef", false, true);
                        i = 0;
                        while (i < (maxChannels + 7) / 8) {
                            tmpValues[i] = 255 & inbuf[offset++];
                            ++i;
                        }
                        i = 0;
                        while (i < this.nChannels) {
                            this.channelOverride[i] = (tmpValues[i / 8] & 1 << i % 8) != 0;
                            bVal = this.channelOverride[i];
                            this.propertyChangeSupport.firePropertyChange(String.format("channelOverride%d", new Object[]{i}), bVal == false, bVal);
                            ++i;
                        }
                        i = 0;
                        while (i < 2 * ((maxChannels + 7) / 8)) {
                            tmpValues[i] = 255 & inbuf[offset++];
                            ++i;
                        }
                        System.out.printf("\n", new Object[0]);
                        i = 0;
                        while (i < this.nChannels) {
                            iVal = this.groupAssign[i] = tmpValues[i / 4] >> 2 * (i % 4) & 3;
                            this.propertyChangeSupport.firePropertyChange(String.format("groupAssign%d", new Object[]{i}), iVal, iVal + 1);
                            ++i;
                        }
                        i = 0;
                        while (i < 2 * ((maxChannels + 7) / 8)) {
                            tmpValues[i] = 255 & inbuf[offset++];
                            ++i;
                        }
                        this.CheckGroups();
                        i = 0;
                        while (i < this.nChannels) {
                            iVal = tmpValues[i / 4] >> 2 * (i % 4) & 3;
                            if (iVal != ChMode.MANUAL.ordinal()) ** GOTO lbl525
                            cmVal = ChMode.MANUAL;
                            ** GOTO lbl530
lbl525:
                            // 1 sources

                            if (iVal != ChMode.AUTOMIX.ordinal()) ** GOTO lbl528
                            cmVal = ChMode.AUTOMIX;
                            ** GOTO lbl530
lbl528:
                            // 1 sources

                            if (iVal != ChMode.MUTE.ordinal()) ** GOTO lbl533
                            cmVal = ChMode.MUTE;
lbl530:
                            // 3 sources

                            this.channelPreset[i] = cmVal;
                            if (!this.bypass[i]) {
                                this.propertyChangeSupport.firePropertyChange(String.format("channelPreset%d", new Object[]{i}), (Object)ChMode.NONE, (Object)cmVal);
                            }
lbl533:
                            // 4 sources

                            ++i;
                        }
                        dVal = this.BytesToFloat(inbuf, offset);
                        this.propertyChangeSupport.firePropertyChange("safetyThreshold", dVal + 1.0, dVal);
                        dVal = this.BytesToFloat(inbuf, offset += 4);
                        offset += 4;
                        this.propertyChangeSupport.firePropertyChange("holdThreshold", dVal + 1.0, dVal);
                        i = 0;
                        while (i < this.nChannels) {
                            dVal = this.BytesToFloat(inbuf, offset);
                            offset += 4;
                            this.channelWeight[i] = dVal;
                            this.propertyChangeSupport.firePropertyChange(String.format("channelWeight%d", new Object[]{i}), dVal + 1.0, dVal);
                            ++i;
                        }
                        offset += 4 * (maxChannels - this.nChannels);
                        i = 0;
                        while (i < 3) {
                            dVal = this.BytesToFloat(inbuf, offset);
                            offset += 4;
                            this.musicThreshold[i] = dVal;
                            this.propertyChangeSupport.fireIndexedPropertyChange("musicThreshold", i, dVal + 1.0, dVal);
                            ++i;
                        }
                        i = 0;
                        while (i < 3) {
                            dVal = this.BytesToFloat(inbuf, offset);
                            offset += 4;
                            this.autoMixDepth[i] = dVal;
                            this.propertyChangeSupport.fireIndexedPropertyChange("autoMixDepth", i, dVal + 1.0, dVal);
                            ++i;
                        }
                        i = 0;
                        while (i < 3) {
                            dVal = this.BytesToFloat(inbuf, offset);
                            offset += 4;
                            this.nomGainLimit[i] = dVal;
                            this.propertyChangeSupport.fireIndexedPropertyChange("nomGainLimit", i, dVal + 1.0, dVal);
                            ++i;
                        }
                        this.sceneChanged = inbuf[offset++] != 0;
                        this.propertyChangeSupport.firePropertyChange("SceneChanged", this.sceneChanged == false, this.sceneChanged);
                        this.lastHold = iVal = inbuf[offset++] & 255;
                        this.propertyChangeSupport.firePropertyChange("lastHold", iVal - 1, iVal);
                        this.clockSource = inbuf[offset++] & 255;
                        if (this.devType == DevType.MODEL_N || this.devType == DevType.MODEL_M || this.devType == DevType.MODEL_E3A) {
                            this.propertyChangeSupport.firePropertyChange("ClockSource", this.clockSource - 1, this.clockSource);
                        }
                        tmp16 = inbuf[offset++] & 255;
                        iVal = inbuf[offset++] & 255;
                        i = 0;
                        while (i < 3) {
                            if ((iVal = inbuf[offset++] & 255) < 0 || iVal > 64) {
                                System.out.println("Illegal musicInCh\n");
                            }
                            this.musicInCh[i] = iVal;
                            this.propertyChangeSupport.fireIndexedPropertyChange("MusicInCh", i, iVal - 1, iVal);
                            ++i;
                        }
                        this.masterMode = ((iVal = inbuf[offset++] & 255) & 1) == 0;
                        this.propertyChangeSupport.firePropertyChange("master", this.masterMode == false, this.masterMode);
                        this.adatAudio = (iVal & 2) != 0;
                        this.propertyChangeSupport.firePropertyChange("adatAudio", this.adatAudio == false, this.adatAudio);
                        v1 = this.headroom = (iVal & 4) == 0;
                        if (this.devType != DevType.MODEL_E2A) {
                            this.clockIs48k = this.headroom;
                        }
                        this.propertyChangeSupport.firePropertyChange("headroom", this.headroom == false, this.headroom);
                        this.cardMode = (iVal & 8) == 0;
                        this.cp2Alive = (iVal & 16) != 0;
                        this.groupSpecificMaster = true;
                        this.propertyChangeSupport.firePropertyChange("GroupSpecific", this.groupSpecificMaster == false, this.groupSpecificMaster);
                        if (this.adatAudio) {
                            this.adat16Ch = tmp16 != 0;
                            this.propertyChangeSupport.firePropertyChange("Adat16Channels", this.adat16Ch == false, this.adat16Ch);
                        } else {
                            this.adatEcho = tmp16;
                            this.propertyChangeSupport.firePropertyChange("Adat16Channels", this.adatEcho == 8, this.adatEcho == 16);
                        }
                        if (inbuf.length > ++offset) {
                            this.nSlaves = inbuf[offset] & 255;
                        }
                        ** GOTO lbl811
lbl612:
                        // 1 sources

                        if (inbuf.length < 156) {
                            return Cmd.ERROR;
                        }
                        iVal = inbuf[154] & 255;
                        this.masterMode = (iVal & 1) == 0;
                        this.propertyChangeSupport.firePropertyChange("master", this.masterMode == false, this.masterMode);
                        this.adatAudio = (iVal & 2) != 0;
                        this.propertyChangeSupport.firePropertyChange("adatAudio", this.adatAudio == false, this.adatAudio);
                        this.headroom = (iVal & 4) == 0;
                        this.propertyChangeSupport.firePropertyChange("headroom", this.headroom == false, this.headroom);
                        this.cardMode = (iVal & 8) == 0;
                        this.propertyChangeSupport.firePropertyChange("cardMode", this.cardMode == false, this.cardMode);
                        this.cp2Alive = (iVal & 16) != 0;
                        this.propertyChangeSupport.firePropertyChange("CP2Alive", this.cp2Alive == false, this.cp2Alive);
                        this.groupSpecificMaster = (iVal & 128) != 0;
                        this.propertyChangeSupport.firePropertyChange("GroupSpecific", this.groupSpecificMaster == false, this.groupSpecificMaster);
                        switch (UDPComm.$SWITCH_TABLE$DuganCP$UDPComm$DevType()[this.devType.ordinal()]) {
                            case 10: {
                                i = inbuf[155] & 255;
                                if (i >= 8) break;
                                i = 16;
                                break;
                            }
                            case 6: {
                                i = this.adatAudio != false ? 8 : (this.headroom == false ? 8 : 16);
                                if (inbuf.length <= 162) break;
                                this.nSlaves = inbuf[162] & 255;
                                break;
                            }
                            case 7: {
                                i = inbuf[155] & 255;
                                if (i < 8) {
                                    i = 8;
                                }
                                if (inbuf.length == 156) {
                                    this.propertyChangeSupport.firePropertyChange("Adat16Channels", true, false);
                                    this.adat16Ch = false;
                                    break;
                                }
                                this.adat16Ch = (inbuf[156] & 255) != 0;
                                this.propertyChangeSupport.firePropertyChange("Adat16Channels", this.adat16Ch == false, this.adat16Ch);
                                break;
                            }
                            case 8: {
                                i = inbuf[155] & 255;
                                if (i == 0) {
                                    i = 12;
                                }
                                this.adat16Ch = (inbuf[157] & 255) != 0;
                                this.propertyChangeSupport.firePropertyChange("Adat16Channels", this.adat16Ch == false, this.adat16Ch);
                                this.aes14Ch = (inbuf[158] & 255) != 0;
                                this.propertyChangeSupport.firePropertyChange("AES14Channels", this.aes14Ch == false, this.aes14Ch);
                                if (inbuf.length <= 162) break;
                                this.nSlaves = inbuf[162] & 255;
                                break;
                            }
                            case 9: {
                                i = inbuf[155] & 255;
                                if (i == 0) {
                                    i = 14;
                                }
                                this.clockSource = inbuf[156] & 255;
                                this.propertyChangeSupport.firePropertyChange("ClockSource", this.clockSource - 1, this.clockSource);
                                this.adat16Ch = (inbuf[157] & 255) != 0;
                                this.propertyChangeSupport.firePropertyChange("Adat16Channels", this.adat16Ch == false, this.adat16Ch);
                                this.aes14Ch = (inbuf[158] & 255) != 0;
                                this.propertyChangeSupport.firePropertyChange("AES14Channels", this.aes14Ch == false, this.aes14Ch);
                                if (inbuf.length <= 162) break;
                                this.nSlaves = inbuf[162] & 255;
                                break;
                            }
                            default: {
                                i = 8;
                            }
                        }
                        this.propertyChangeSupport.firePropertyChange("nChannels", 0, i);
                        if (i != this.nChannels) {
                            this.nChannels = i;
                            this.propertyChangeSupport.firePropertyChange("nChannelsChange", false, true);
                        }
                        offset = 4;
                        i = 0;
                        while (i < 16) {
                            if ((j = inbuf[offset++] & 255) != ChMode.MANUAL.ordinal()) ** GOTO lbl685
                            cmVal = ChMode.MANUAL;
                            ** GOTO lbl690
lbl685:
                            // 1 sources

                            if (j != ChMode.AUTOMIX.ordinal()) ** GOTO lbl688
                            cmVal = ChMode.AUTOMIX;
                            ** GOTO lbl690
lbl688:
                            // 1 sources

                            if (j != ChMode.MUTE.ordinal()) ** GOTO lbl693
                            cmVal = ChMode.MUTE;
lbl690:
                            // 3 sources

                            this.channelMode[i] = cmVal;
                            this.propertyChangeSupport.firePropertyChange(String.format("channelMode%d", new Object[]{i}), (Object)ChMode.NONE, (Object)cmVal);
                            this.propertyChangeSupport.fireIndexedPropertyChange("channelMode", i, (Object)ChMode.NONE, (Object)cmVal);
lbl693:
                            // 2 sources

                            ++i;
                        }
                        i = 0;
                        while (i < 3) {
                            iVal = inbuf[offset++] & 255;
                            this.optionFlags[i] = iVal += (inbuf[offset++] & 255) * 256;
                            ++i;
                        }
                        iVal = inbuf[offset++] & 255;
                        iVal += (inbuf[offset++] & 255) * 256;
                        i = 0;
                        while (i < this.nChannels) {
                            this.bypass[i] = bVal = (iVal & 1) != 0;
                            this.propertyChangeSupport.firePropertyChange(String.format("bypass%d", new Object[]{i}), bVal == false, bVal);
                            this.propertyChangeSupport.fireIndexedPropertyChange("bypass", i, bVal == false, bVal);
                            iVal >>= 1;
                            ++i;
                        }
                        iVal = inbuf[offset++] & 255;
                        iVal += (inbuf[offset++] & 255) * 256;
                        i = 0;
                        while (i < this.nChannels) {
                            this.nomEnable[i] = bVal = (iVal & 1) != 0;
                            this.propertyChangeSupport.firePropertyChange(String.format("nomEnable%d", new Object[]{i}), bVal == false, bVal);
                            iVal >>= 1;
                            ++i;
                        }
                        iVal = inbuf[offset++] & 255;
                        iVal += (inbuf[offset++] & 255) * 256;
                        i = 0;
                        while (i < this.nChannels) {
                            this.useMusicRef[i] = bVal = (iVal & 1) != 0;
                            this.propertyChangeSupport.firePropertyChange(String.format("useMusicRef%d", new Object[]{i}), bVal == false, bVal);
                            iVal >>= 1;
                            ++i;
                        }
                        this.propertyChangeSupport.firePropertyChange("CheckUseMusicRef", false, true);
                        offset += 2;
                        iVal = inbuf[offset++] & 255;
                        iVal += (inbuf[offset++] & 255) * 256;
                        i = 0;
                        while (i < this.nChannels) {
                            this.channelOverride[i] = bVal = (iVal & 1) != 0;
                            this.propertyChangeSupport.firePropertyChange(String.format("channelOverride%d", new Object[]{i}), bVal == false, bVal);
                            iVal >>= 1;
                            ++i;
                        }
                        iVal = inbuf[offset++] & 255;
                        iVal += (inbuf[offset++] & 255) * 256;
                        iVal += (inbuf[offset++] & 255) * 65536;
                        iVal += (inbuf[offset++] & 255) * 0x1000000;
                        i = 0;
                        while (i < this.nChannels) {
                            this.groupAssign[i] = j = iVal & 3;
                            this.propertyChangeSupport.firePropertyChange(String.format("groupAssign%d", new Object[]{i}), j, j + 1);
                            iVal >>= 2;
                            ++i;
                        }
                        this.CheckGroups();
                        iVal = inbuf[offset++] & 255;
                        iVal += (inbuf[offset++] & 255) * 256;
                        iVal += (inbuf[offset++] & 255) * 65536;
                        iVal += (inbuf[offset++] & 255) * 0x1000000;
                        i = 0;
                        while (i < this.nChannels) {
                            j = iVal & 3;
                            if (j != ChMode.MANUAL.ordinal()) ** GOTO lbl762
                            cmVal = ChMode.MANUAL;
                            ** GOTO lbl767
lbl762:
                            // 1 sources

                            if (j != ChMode.AUTOMIX.ordinal()) ** GOTO lbl765
                            cmVal = ChMode.AUTOMIX;
                            ** GOTO lbl767
lbl765:
                            // 1 sources

                            if (j != ChMode.MUTE.ordinal()) ** GOTO lbl771
                            cmVal = ChMode.MUTE;
lbl767:
                            // 3 sources

                            this.channelPreset[i] = cmVal;
                            if (!this.bypass[i]) {
                                this.propertyChangeSupport.firePropertyChange(String.format("channelPreset%d", new Object[]{i}), (Object)ChMode.NONE, (Object)cmVal);
                            }
                            iVal >>= 2;
lbl771:
                            // 2 sources

                            ++i;
                        }
                        dVal = this.BytesToFloat(inbuf, offset);
                        this.propertyChangeSupport.firePropertyChange("safetyThreshold", dVal + 1.0, dVal);
                        dVal = this.BytesToFloat(inbuf, offset += 4);
                        offset += 4;
                        this.propertyChangeSupport.firePropertyChange("holdThreshold", dVal + 1.0, dVal);
                        i = 0;
                        while (i < this.nChannels) {
                            dVal = this.BytesToFloat(inbuf, offset);
                            offset += 4;
                            this.channelWeight[i] = dVal;
                            this.propertyChangeSupport.firePropertyChange(String.format("channelWeight%d", new Object[]{i}), dVal + 1.0, dVal);
                            ++i;
                        }
                        offset += 4 * (16 - this.nChannels);
                        i = 0;
                        while (i < 3) {
                            dVal = this.BytesToFloat(inbuf, offset);
                            offset += 4;
                            this.musicThreshold[i] = dVal;
                            this.propertyChangeSupport.fireIndexedPropertyChange("musicThreshold", i, dVal + 1.0, dVal);
                            ++i;
                        }
                        i = 0;
                        while (i < 3) {
                            dVal = this.BytesToFloat(inbuf, offset);
                            offset += 4;
                            this.autoMixDepth[i] = dVal;
                            this.propertyChangeSupport.fireIndexedPropertyChange("autoMixDepth", i, dVal + 1.0, dVal);
                            ++i;
                        }
                        i = 0;
                        while (i < 3) {
                            dVal = this.BytesToFloat(inbuf, offset);
                            offset += 4;
                            this.nomGainLimit[i] = dVal;
                            this.propertyChangeSupport.fireIndexedPropertyChange("nomGainLimit", i, dVal + 1.0, dVal);
                            ++i;
                        }
lbl811:
                        // 3 sources

                        return Cmd.GP;
                    }
                    case 83: {
                        bForceGS = this.forceUpdateCnt >= 100;
                        this.lastGSPacket = System.currentTimeMillis();
                        if (this.oldCmdSet) {
                            iVal = inbuf[offset + 3] & 255;
                            i = 0;
                            while (i < this.nChannels) {
                                v2 = bVal = (iVal & 1 << i) != 0;
                                if (!this.bypass[i]) {
                                    this.propertyChangeSupport.firePropertyChange(String.format("signalPresence%d", new Object[]{i}), bForceGS ? !bVal : this.signalPresence[i], bVal);
                                    this.signalPresence[i] = bVal;
                                }
                                ++i;
                            }
                            iVal = inbuf[offset + 4] & 255;
                            i = 0;
                            while (i < this.nChannels) {
                                v3 = bVal = (iVal & 1 << i) != 0;
                                if (!this.bypass[i]) {
                                    this.propertyChangeSupport.firePropertyChange(String.format("signalClip%d", new Object[]{i}), bForceGS ? !bVal : this.signalClip[i], bVal);
                                    this.signalClip[i] = bVal;
                                }
                                ++i;
                            }
                            this.propertyChangeSupport.firePropertyChange("autoMixGain", null, Arrays.copyOfRange(inbuf, offset + 5, offset + 5 + this.nChannels));
                            i = 0;
                            while (i < this.nChannels) {
                                iVal = 255 & inbuf[offset + 5 + i];
                                dVal = iVal == 255 ? -128.0 : -0.5 * (double)iVal;
                                this.autoMixGain[i] = dVal;
                                if (!this.bypass[i]) {
                                    this.propertyChangeSupport.firePropertyChange(String.format("autoMixGain%d", new Object[]{i}), bForceGS != false ? iVal - 1 : this.iAutoMixGain[i], iVal);
                                    this.iAutoMixGain[i] = iVal;
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < 3) {
                                iVal = 255 & inbuf[offset + 5 + 8 + i];
                                this.gainLimit[i] = iVal == 255 ? -128.0 : -0.5 * (double)iVal;
                                this.propertyChangeSupport.fireIndexedPropertyChange("gainLimit", i, bForceGS != false ? iVal - 1 : this.iGainLimit[i], iVal);
                                this.iGainLimit[i] = iVal;
                                ++i;
                            }
                        } else if (this.devType == DevType.MODEL_M || this.devType == DevType.MODEL_N || this.devType == DevType.MODEL_E2A || this.devType == DevType.MODEL_E3A || this.devType == DevType.MODEL_PY) {
                            switch (UDPComm.$SWITCH_TABLE$DuganCP$UDPComm$DevType()[this.devType.ordinal()]) {
                                case 12: 
                                case 13: {
                                    maxChannels = 64;
                                    break;
                                }
                                case 14: {
                                    maxChannels = 28;
                                    break;
                                }
                                case 15: {
                                    maxChannels = 32;
                                    break;
                                }
                                case 16: {
                                    maxChannels = 64;
                                    break;
                                }
                                default: {
                                    maxChannels = 64;
                                }
                            }
                            offset = 4;
                            i = 0;
                            while (i < (maxChannels + 7) / 8) {
                                tmpValues[i] = 255 & inbuf[offset++];
                                ++i;
                            }
                            i = 0;
                            while (i < this.nChannels) {
                                v4 = bVal = (tmpValues[i / 8] & 1 << i % 8) != 0;
                                if (!this.bypass[i]) {
                                    this.propertyChangeSupport.firePropertyChange(String.format("signalPresence%d", new Object[]{i}), bForceGS ? !bVal : this.signalPresence[i], bVal);
                                    this.signalPresence[i] = bVal;
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < (maxChannels + 7) / 8) {
                                tmpValues[i] = 255 & inbuf[offset++];
                                ++i;
                            }
                            i = 0;
                            while (i < this.nChannels) {
                                v5 = bVal = (tmpValues[i / 8] & 1 << i % 8) != 0;
                                if (!this.bypass[i]) {
                                    this.propertyChangeSupport.firePropertyChange(String.format("signalClip%d", new Object[]{i}), bForceGS ? !bVal : this.signalClip[i], bVal);
                                    this.signalClip[i] = bVal;
                                }
                                ++i;
                            }
                            this.propertyChangeSupport.firePropertyChange("autoMixGain", null, Arrays.copyOfRange(inbuf, ++offset, offset + this.nChannels));
                            i = 0;
                            while (i < this.nChannels) {
                                iVal = 255 & inbuf[offset];
                                dVal = iVal == 255 ? -128.0 : -0.5 * (double)(255 & inbuf[offset]);
                                this.autoMixGain[i] = dVal;
                                if (!this.bypass[i]) {
                                    if (this.bargraphMode == Channel.BarMode.BAR_AUTOMIX_GAIN) {
                                        this.propertyChangeSupport.firePropertyChange(String.format("autoMixGain%d", new Object[]{i}), bForceGS != false ? iVal - 1 : this.iAutoMixGain[i], iVal);
                                    }
                                    this.iAutoMixGain[i] = iVal;
                                }
                                ++offset;
                                ++i;
                            }
                            offset += maxChannels - this.nChannels;
                            i = 0;
                            while (i < 3) {
                                iVal = 255 & inbuf[offset++];
                                this.propertyChangeSupport.fireIndexedPropertyChange("gainLimit", i, bForceGS != false ? iVal - 1 : this.iGainLimit[i], iVal);
                                this.iGainLimit[i] = iVal;
                                ++i;
                            }
                            iVal = inbuf[offset++] & 255;
                            if (!this.groupSpecificMaster) {
                                iVal &= 1;
                            }
                            this.propertyChangeSupport.firePropertyChange("systemMute", bForceGS != false ? iVal - 1 : this.systemMute, iVal);
                            this.systemMute = iVal;
                            iVal = inbuf[offset++] & 255;
                            if (!this.groupSpecificMaster) {
                                iVal &= 1;
                            }
                            this.propertyChangeSupport.firePropertyChange("systemOverride", bForceGS != false ? iVal - 1 : this.systemOverride, iVal);
                            this.systemOverride = iVal;
                            iVal = inbuf[offset++] & 255;
                            if (!this.groupSpecificMaster) {
                                iVal &= 1;
                            }
                            this.propertyChangeSupport.firePropertyChange("systemPreset", bForceGS != false ? iVal - 1 : this.systemPreset, iVal);
                            this.systemPreset = iVal;
                            if (this.bargraphMode == Channel.BarMode.BAR_INPUT_LEVEL) {
                                i = 0;
                                while (i < this.nChannels) {
                                    iVal = 255 & inbuf[offset++];
                                    this.propertyChangeSupport.firePropertyChange(String.format("inputPeak%d", new Object[]{i}), bForceGS != false ? iVal - 1 : this.inputLevel[i], iVal);
                                    this.inputLevel[i] = iVal;
                                    ++i;
                                }
                                offset += maxChannels - this.nChannels;
                            } else {
                                offset += maxChannels;
                            }
                            if (this.bargraphMode == Channel.BarMode.BAR_OUTPUT_LEVEL) {
                                i = 0;
                                while (i < this.nChannels) {
                                    iVal = 255 & inbuf[offset++];
                                    this.propertyChangeSupport.firePropertyChange(String.format("outputPeak%d", new Object[]{i}), bForceGS != false ? iVal - 1 : this.outputLevel[i], iVal);
                                    this.outputLevel[i] = iVal;
                                    ++i;
                                }
                                offset += maxChannels - this.nChannels;
                            } else {
                                offset += maxChannels;
                            }
                            iVal = 255 & inbuf[offset++];
                            this.propertyChangeSupport.firePropertyChange("blinkMute", bForceGS != false ? iVal - 1 : this.blinkMute, iVal);
                            this.blinkMute = iVal;
                            v6 = ++offset;
                            ++offset;
                            iVal = 255 & inbuf[v6];
                            this.propertyChangeSupport.fireIndexedPropertyChange("musicRefPeak", 0, bForceGS != false ? iVal - 1 : this.musicRefPeak[0], iVal);
                            this.musicRefPeak[0] = iVal;
                            iVal = 255 & inbuf[offset++];
                            this.propertyChangeSupport.fireIndexedPropertyChange("musicRefPeak", 1, bForceGS != false ? iVal - 1 : this.musicRefPeak[1], iVal);
                            this.musicRefPeak[1] = iVal;
                            iVal = 255 & inbuf[offset++];
                            this.propertyChangeSupport.fireIndexedPropertyChange("musicRefPeak", 2, bForceGS != false ? iVal - 1 : this.musicRefPeak[2], iVal);
                            this.musicRefPeak[2] = iVal;
                            iVal = 255 & inbuf[offset++];
                            this.propertyChangeSupport.fireIndexedPropertyChange("signalRefPeak", 0, bForceGS != false ? iVal - 1 : this.signalRefPeak[0], iVal);
                            this.signalRefPeak[0] = iVal;
                            iVal = 255 & inbuf[offset++];
                            this.propertyChangeSupport.fireIndexedPropertyChange("signalRefPeak", 1, bForceGS != false ? iVal - 1 : this.signalRefPeak[1], iVal);
                            this.signalRefPeak[1] = iVal;
                            iVal = 255 & inbuf[offset++];
                            this.propertyChangeSupport.fireIndexedPropertyChange("signalRefPeak", 2, bForceGS != false ? iVal - 1 : this.signalRefPeak[2], iVal);
                            this.signalRefPeak[2] = iVal;
                            this.propertyChangeSupport.fireIndexedPropertyChange("mixPeaks", offset, null, inbuf);
                            if (this.devType == DevType.MODEL_E3A) {
                                bVal = (inbuf[offset += 6] & 128) != 0;
                                this.autoClockSource = inbuf[offset] & 127;
                            } else {
                                offset = this.devType == DevType.MODEL_E2A ? (offset += 6) : (offset += 6);
                                bVal = (inbuf[offset] & 1) != 0;
                                this.autoClockSource = 0;
                            }
                            this.propertyChangeSupport.fireIndexedPropertyChange("ClockLocked", this.autoClockSource, bVal == false, bVal);
                            bVal = (inbuf[offset] & 2) != 0;
                            this.propertyChangeSupport.firePropertyChange("netAudioPresence", bVal == false, bVal);
                        } else {
                            offset = 4;
                            iVal = 255 & inbuf[offset++];
                            iVal += (255 & inbuf[offset++]) * 256;
                            iOld = 255 & inbuf[offset++];
                            iOld += (255 & inbuf[offset++]) * 256;
                            i = 0;
                            while (i < this.nChannels) {
                                bVal = (iVal & 1 << i) != 0;
                                v7 = bOld = (iOld & 1 << i) != 0;
                                if (!this.bypass[i]) {
                                    this.propertyChangeSupport.firePropertyChange(String.format("signalPresence%d", new Object[]{i}), bForceGS ? !bVal : this.signalPresence[i], bVal);
                                    this.signalPresence[i] = bVal;
                                    this.propertyChangeSupport.firePropertyChange(String.format("signalClip%d", new Object[]{i}), bForceGS ? !bVal : this.signalClip[i], bOld);
                                    this.signalClip[i] = bOld;
                                }
                                ++i;
                            }
                            this.propertyChangeSupport.firePropertyChange("autoMixGain", null, Arrays.copyOfRange(inbuf, ++offset, offset + this.nChannels));
                            i = 0;
                            while (i < this.nChannels) {
                                iVal = 255 & inbuf[offset];
                                dVal = iVal == 255 ? -128.0 : -0.5 * (double)(255 & inbuf[offset]);
                                this.autoMixGain[i] = dVal;
                                if (!this.bypass[i]) {
                                    if (this.bargraphMode == Channel.BarMode.BAR_AUTOMIX_GAIN) {
                                        this.propertyChangeSupport.firePropertyChange(String.format("autoMixGain%d", new Object[]{i}), bForceGS != false ? iVal - 1 : this.iAutoMixGain[i], iVal);
                                    }
                                    this.iAutoMixGain[i] = iVal;
                                }
                                ++offset;
                                ++i;
                            }
                            offset += 16 - this.nChannels;
                            i = 0;
                            while (i < 3) {
                                iVal = 255 & inbuf[offset++];
                                this.propertyChangeSupport.fireIndexedPropertyChange("gainLimit", i, bForceGS != false ? iVal - 1 : this.iGainLimit[i], iVal);
                                this.iGainLimit[i] = iVal;
                                ++i;
                            }
                            iVal = inbuf[offset++] & 255;
                            if (!this.groupSpecificMaster) {
                                iVal &= 1;
                            }
                            this.propertyChangeSupport.firePropertyChange("systemMute", bForceGS != false ? iVal - 1 : this.systemMute, iVal);
                            this.systemMute = iVal;
                            iVal = inbuf[offset++] & 255;
                            if (!this.groupSpecificMaster) {
                                iVal &= 1;
                            }
                            this.propertyChangeSupport.firePropertyChange("systemOverride", bForceGS != false ? iVal - 1 : this.systemOverride, iVal);
                            this.systemOverride = iVal;
                            iVal = inbuf[offset++] & 255;
                            if (!this.groupSpecificMaster) {
                                iVal &= 1;
                            }
                            this.propertyChangeSupport.firePropertyChange("systemPreset", bForceGS != false ? iVal - 1 : this.systemPreset, iVal);
                            this.systemPreset = iVal;
                            if (this.bargraphMode == Channel.BarMode.BAR_INPUT_LEVEL) {
                                i = 0;
                                while (i < this.nChannels) {
                                    iVal = 255 & inbuf[offset++];
                                    this.propertyChangeSupport.firePropertyChange(String.format("inputPeak%d", new Object[]{i}), bForceGS != false ? iVal - 1 : this.inputLevel[i], iVal);
                                    this.inputLevel[i] = iVal;
                                    ++i;
                                }
                                offset += 16 - this.nChannels;
                            } else {
                                offset += 16;
                            }
                            if (this.bargraphMode == Channel.BarMode.BAR_OUTPUT_LEVEL) {
                                i = 0;
                                while (i < this.nChannels) {
                                    iVal = 255 & inbuf[offset++];
                                    this.propertyChangeSupport.firePropertyChange(String.format("outputPeak%d", new Object[]{i}), bForceGS != false ? iVal - 1 : this.outputLevel[i], iVal);
                                    this.outputLevel[i] = iVal;
                                    ++i;
                                }
                                offset += 16 - this.nChannels;
                            } else {
                                offset += 16;
                            }
                            if (this.devType == DevType.MODEL_E3 || this.devType == DevType.MODEL_E2) {
                                iVal = 255 & inbuf[offset++];
                                this.propertyChangeSupport.firePropertyChange("blinkMute", bForceGS != false ? iVal - 1 : this.blinkMute, iVal);
                                this.blinkMute = iVal;
                                v8 = ++offset;
                                ++offset;
                                iVal = 255 & inbuf[v8];
                                this.propertyChangeSupport.fireIndexedPropertyChange("musicRefPeak", 0, bForceGS != false ? iVal - 1 : this.musicRefPeak[0], iVal);
                                this.musicRefPeak[0] = iVal;
                                iVal = 255 & inbuf[offset++];
                                this.propertyChangeSupport.fireIndexedPropertyChange("musicRefPeak", 1, bForceGS != false ? iVal - 1 : this.musicRefPeak[1], iVal);
                                this.musicRefPeak[1] = iVal;
                                iVal = 255 & inbuf[offset++];
                                this.propertyChangeSupport.fireIndexedPropertyChange("musicRefPeak", 2, bForceGS != false ? iVal - 1 : this.musicRefPeak[2], iVal);
                                this.musicRefPeak[2] = iVal;
                                iVal = 255 & inbuf[offset++];
                                this.propertyChangeSupport.fireIndexedPropertyChange("signalRefPeak", 0, bForceGS != false ? iVal - 1 : this.signalRefPeak[0], iVal);
                                this.signalRefPeak[0] = iVal;
                                iVal = 255 & inbuf[offset++];
                                this.propertyChangeSupport.fireIndexedPropertyChange("signalRefPeak", 1, bForceGS != false ? iVal - 1 : this.signalRefPeak[1], iVal);
                                this.signalRefPeak[1] = iVal;
                                iVal = 255 & inbuf[offset++];
                                this.propertyChangeSupport.fireIndexedPropertyChange("signalRefPeak", 2, bForceGS != false ? iVal - 1 : this.signalRefPeak[2], iVal);
                                this.signalRefPeak[2] = iVal;
                                this.propertyChangeSupport.fireIndexedPropertyChange("mixPeaks", offset, null, inbuf);
                                if (this.devType == DevType.MODEL_E3) {
                                    bVal = (inbuf[offset += 6] & 128) != 0;
                                    this.autoClockSource = inbuf[offset] & 127;
                                    this.propertyChangeSupport.fireIndexedPropertyChange("ClockLocked", this.autoClockSource, bVal == false, bVal);
                                }
                            } else if (inbuf.length > offset) {
                                iVal = 255 & inbuf[offset];
                                this.propertyChangeSupport.firePropertyChange("blinkMute", iVal - 1, iVal);
                            }
                        }
                        this.forceUpdateCnt = this.forceUpdateCnt >= 100 ? 0 : ++this.forceUpdateCnt;
                        return Cmd.GS;
                    }
                    case 87: {
                        return Cmd.GW;
                    }
                }
                System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                return Cmd.ERROR;
            }
            case 72: {
                switch (inbuf[1]) {
                    case 82: {
                        if (inStr.indexOf("Not Applicable") != -1) {
                            return Cmd.HR;
                        }
                        if (strs.length < 1) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]);
                        this.headroom = bVal = i != 0;
                        this.propertyChangeSupport.firePropertyChange("headroom", bVal == false, bVal);
                        return Cmd.HR;
                    }
                    case 84: {
                        if (strs.length < 1) {
                            return Cmd.ERROR;
                        }
                        dVal = Double.parseDouble(strs[0]);
                        this.propertyChangeSupport.firePropertyChange("holdThreshold", dVal - 1.0, dVal);
                        return Cmd.HT;
                    }
                }
                System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                return Cmd.ERROR;
            }
            case 73: {
                switch (inbuf[1]) {
                    case 80: {
                        return Cmd.IP;
                    }
                }
                return Cmd.ERROR;
            }
            case 76: {
                switch (inbuf[1]) {
                    case 71: {
                        if (strs.length < 1) {
                            return Cmd.ERROR;
                        }
                        this.linkGroup = Integer.parseInt(strs[0]);
                        try {
                            this.multicastIP = InetAddress.getByName(String.format("%s%d", new Object[]{"237.1.4.", this.linkGroup}));
                        }
                        catch (UnknownHostException ex) {
                            Logger.getLogger(UDPComm.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        this.propertyChangeSupport.firePropertyChange("linkGroup", -1, this.linkGroup);
                        return Cmd.LG;
                    }
                    case 80: {
                        return Cmd.LP;
                    }
                    case 72: {
                        if (strs.length < 1) {
                            return Cmd.ERROR;
                        }
                        this.lastHold = i = Integer.parseInt(strs[0]);
                        this.propertyChangeSupport.firePropertyChange("lastHold", i - 1, i);
                        return Cmd.LH;
                    }
                    case 82: {
                        this.linkedToModelK = JOptionPane.showConfirmDialog(null, "Link to Model K?", "Model K link request", 0, 3) == 0;
                        return Cmd.LR;
                    }
                }
                System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                return Cmd.ERROR;
            }
            case 77: {
                switch (inbuf[1]) {
                    case 65: {
                        strs = inStr.split("-");
                        if (strs.length < 6) {
                            return Cmd.ERROR;
                        }
                        i = 0;
                        while (i < 6) {
                            this.macAddress[i] = (byte)Integer.parseInt(strs[i]);
                            ++i;
                        }
                        this.propertyChangeSupport.firePropertyChange("macAddress", this.macAddress, this.macAddress);
                        return Cmd.MA;
                    }
                    case 67: {
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]) - 1;
                        this.musicInCh[i] = j = Integer.parseInt(strs[1]) - 1;
                        this.propertyChangeSupport.fireIndexedPropertyChange("MusicInCh", i, j - 1, j);
                        return Cmd.MC;
                    }
                    case 77: {
                        if (strs.length < 1) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]);
                        this.masterMode = bVal = i != 0;
                        this.propertyChangeSupport.firePropertyChange("master", bVal == false, bVal);
                        return Cmd.MM;
                    }
                    case 82: {
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]) - 1;
                        j = Integer.parseInt(strs[1]);
                        this.useMusicRef[i] = bVal = j != 0;
                        this.propertyChangeSupport.firePropertyChange(String.format("useMusicRef%d", new Object[]{i}), bVal == false, bVal);
                        this.propertyChangeSupport.firePropertyChange("CheckUseMusicRef", false, true);
                        this.CheckGroups();
                        return Cmd.MR;
                    }
                    case 84: {
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]) - 1;
                        this.musicThreshold[i] = dVal = Double.parseDouble(strs[1]);
                        this.propertyChangeSupport.fireIndexedPropertyChange("musicThreshold", i, dVal - 1.0, dVal);
                        return Cmd.MT;
                    }
                    case 88: {
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]) - 1;
                        switch (inbuf[2]) {
                            case 77: {
                                bVal = Integer.parseInt(strs[1]) != 0;
                                this.propertyChangeSupport.fireIndexedPropertyChange("mixerMute", i, bVal == false, bVal);
                                return Cmd.MXM;
                            }
                            case 79: {
                                if (strs.length < 2) {
                                    return Cmd.ERROR;
                                }
                                j = Integer.parseInt(strs[1]);
                                this.propertyChangeSupport.fireIndexedPropertyChange("mixerOutputSelect", i, -1, j);
                                return Cmd.MXO;
                            }
                            case 80: {
                                bVal = Integer.parseInt(strs[1]) != 0;
                                this.propertyChangeSupport.fireIndexedPropertyChange("mixerPolarity", i, bVal == false, bVal);
                                return Cmd.MXP;
                            }
                            case 86: {
                                dVal = Double.parseDouble(strs[1]);
                                this.propertyChangeSupport.fireIndexedPropertyChange("mixerVolume", i, dVal - 1.0, dVal);
                                return Cmd.MXV;
                            }
                        }
                        return Cmd.ERROR;
                    }
                }
                System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                return Cmd.ERROR;
            }
            case 78: {
                switch (inbuf[1]) {
                    case 65: {
                        this.propertyChangeSupport.firePropertyChange("unitName", "", inStr);
                        if (this.unitName.compareTo(inStr) != 0) {
                            this.unitName = inStr;
                            this.propertyChangeSupport.firePropertyChange("nChannelsChange", false, true);
                        }
                        return Cmd.NA;
                    }
                    case 69: {
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]) - 1;
                        j = Integer.parseInt(strs[1]);
                        this.nomEnable[i] = bVal = j != 0;
                        this.propertyChangeSupport.firePropertyChange(String.format("nomEnable%d", new Object[]{i}), bVal == false, bVal);
                        this.propertyChangeSupport.firePropertyChange("CheckUseMusicRef", false, true);
                        this.CheckGroups();
                        return Cmd.NE;
                    }
                    case 76: {
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]) - 1;
                        this.nomGainLimit[i] = dVal = Double.parseDouble(strs[1]);
                        this.propertyChangeSupport.fireIndexedPropertyChange("nomGainLimit", i, dVal - 1.0, dVal);
                        return Cmd.NL;
                    }
                    case 77: {
                        return Cmd.NM;
                    }
                    case 83: {
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        this.nSlaves = Integer.parseInt(strs[0]);
                        return Cmd.NS;
                    }
                }
                System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                return Cmd.ERROR;
            }
            case 79: {
                switch (inbuf[1]) {
                    case 77: {
                        if (strs.length < 3) {
                            return Cmd.ERROR;
                        }
                        i = Integer.parseInt(strs[0]) - 1;
                        j = Integer.parseInt(strs[1]) - 1;
                        dVal = Double.parseDouble(strs[2]);
                        this.propertyChangeSupport.fireIndexedPropertyChange("mixerCrossPoint", i * 256 + j, dVal - 1.0, dVal);
                        return Cmd.OM;
                    }
                }
                System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                return Cmd.ERROR;
            }
            case 80: {
                switch (inbuf[1]) {
                    case 68: {
                        this.lastGPPacket = 0L;
                        return Cmd.PD;
                    }
                    case 70: {
                        return Cmd.PF;
                    }
                    case 78: {
                        return Cmd.PN;
                    }
                }
                System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                return Cmd.ERROR;
            }
            case 82: {
                switch (inbuf[1]) {
                    case 77: {
                        this.lastGPPacket = 0L;
                        return Cmd.RM;
                    }
                }
                System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                return Cmd.ERROR;
            }
            case 83: {
                switch (inbuf[1]) {
                    case 67: {
                        this.propertyChangeSupport.firePropertyChange("newDevice", "", inStr);
                        this.lastGPPacket = 0L;
                        return Cmd.SC;
                    }
                    case 77: {
                        if (strs.length < 1) {
                            return Cmd.ERROR;
                        }
                        this.systemMute = Integer.parseInt(strs[0]);
                        if (!this.groupSpecificMaster) {
                            this.systemMute &= 1;
                        }
                        this.propertyChangeSupport.firePropertyChange("systemMute", -1, this.systemMute);
                        return Cmd.SM;
                    }
                    case 78: {
                        switch (inbuf[2]) {
                            case 65: {
                                this.activeScene = strs[0];
                                i = Integer.parseInt(strs[1]);
                                this.propertyChangeSupport.fireIndexedPropertyChange("ActiveScene", i, "", strs[0]);
                                if (strs.length >= 3) {
                                    this.sceneChanged = Integer.parseInt(strs[2]) != 0;
                                    this.propertyChangeSupport.firePropertyChange("SceneChanged", this.sceneChanged == false, this.sceneChanged);
                                }
                                return Cmd.SNA;
                            }
                            case 67: {
                                k = this.nScenes = Integer.parseInt(strs[0]);
                                i = 1;
                                while (k > 0) {
                                    j = k >= 32 ? 32 : k;
                                    this.AddToFIFO(String.format("SNL,%d,%d\r\n", new Object[]{i, j}), Cmd.SNL, false);
                                    i += j;
                                    k -= j;
                                }
                                return Cmd.SNC;
                            }
                            case 68: {
                                this.AddToFIFO("SNC\r\n", Cmd.SNC, false);
                                return Cmd.SND;
                            }
                            case 69: {
                                this.AddToFIFO("SNC\r\n", Cmd.SNC, false);
                                return Cmd.SNE;
                            }
                            case 76: {
                                this.ParseScene(inStr);
                                i = Integer.parseInt(strs[0]);
                                j = Integer.parseInt(strs[1]);
                                if (i + j > this.nScenes) {
                                    this.propertyChangeSupport.firePropertyChange("scenes", 0, this.nScenes);
                                    this.AddToFIFO("SNA\r\n", Cmd.SNA, false);
                                }
                                return Cmd.SNL;
                            }
                            case 78: {
                                this.AddToFIFO("SNC\r\n", Cmd.SNC, false);
                                return Cmd.SNN;
                            }
                            case 82: {
                                this.lastGPPacket = 0L;
                                this.AddToFIFO("SNA\r\n", Cmd.SNA, false);
                                return Cmd.SNR;
                            }
                            case 83: {
                                this.AddToFIFO("SNC\r\n", Cmd.SNC, false);
                                return Cmd.SNS;
                            }
                        }
                        System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                        return Cmd.ERROR;
                    }
                    case 79: {
                        if (strs.length < 1) {
                            return Cmd.ERROR;
                        }
                        this.systemOverride = Integer.parseInt(strs[0]);
                        if (!this.groupSpecificMaster) {
                            this.systemOverride &= 1;
                        }
                        this.propertyChangeSupport.firePropertyChange("systemOverride", -1, this.systemOverride);
                        return Cmd.SO;
                    }
                    case 80: {
                        if (strs.length < 1) {
                            return Cmd.ERROR;
                        }
                        this.systemPreset = Integer.parseInt(strs[0]);
                        if (!this.groupSpecificMaster) {
                            this.systemPreset &= 1;
                        }
                        this.propertyChangeSupport.firePropertyChange("systemPreset", -1, this.systemPreset);
                        return Cmd.SP;
                    }
                    case 83: {
                        return Cmd.SS;
                    }
                    case 84: {
                        if (strs.length < 1) {
                            return Cmd.ERROR;
                        }
                        dVal = Double.parseDouble(strs[0]);
                        this.propertyChangeSupport.firePropertyChange("safetyThreshold", dVal - 1.0, dVal);
                        return Cmd.ST;
                    }
                    case 85: {
                        return Cmd.SU;
                    }
                }
                System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                return Cmd.ERROR;
            }
            case 85: {
                switch (inbuf[1]) {
                    case 80: {
                        return Cmd.UP;
                    }
                }
                return Cmd.ERROR;
            }
            case 86: {
                switch (inbuf[1]) {
                    case 69: {
                        if (strs.length < 2) {
                            return Cmd.ERROR;
                        }
                        this.propertyChangeSupport.fireIndexedPropertyChange("version", 1, "", strs[0]);
                        this.propertyChangeSupport.fireIndexedPropertyChange("version", 2, "", strs[1]);
                        return Cmd.VE;
                    }
                }
                System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                return Cmd.ERROR;
            }
            default: {
                System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
                return Cmd.ERROR;
            }
        }
        System.out.printf("ProcessPacket Error: %s\n", new Object[]{fullStr});
        return Cmd.ERROR;
    }

    public void setBypass(int index, boolean bypass) throws IOException {
        if (index < 0 || index >= this.nChannels) {
            throw new IndexOutOfBoundsException();
        }
        this.bypass[index] = bypass;
        String outStr = String.format("BP%s%d,%c\r\n", this.cmdSeparator, index + 1, Character.valueOf(bypass ? (char)'1' : '0'));
        if (!this.AddToFIFO(outStr, Cmd.BP, false)) {
            throw new IOException("Failed to send bypass command to device. Command FIFO is full!");
        }
    }

    public void setChannelOverride(int index, boolean channelOverride) throws IOException {
        if (index < 0 || index >= this.nChannels) {
            throw new IndexOutOfBoundsException();
        }
        this.channelOverride[index] = channelOverride;
        String outStr = String.format("CO%s%d,%c\r\n", this.cmdSeparator, index + 1, Character.valueOf(channelOverride ? (char)'1' : '0'));
        if (!this.AddToFIFO(outStr, Cmd.CO, false)) {
            throw new IOException("Failed to send channel override command to device. Command FIFO is full!");
        }
    }

    public void setChannelNOMEnable(int index, boolean nomEnable) throws IOException {
        if (index < 0 || index >= this.nChannels) {
            throw new IndexOutOfBoundsException();
        }
        this.nomEnable[index] = nomEnable;
        String outStr = String.format("NE%s%d,%c\r\n", this.cmdSeparator, index + 1, Character.valueOf(nomEnable ? (char)'1' : '0'));
        if (!this.AddToFIFO(outStr, Cmd.NE, false)) {
            throw new IOException("Failed to send NOM Enable command to device. Command FIFO is full!");
        }
    }

    public void setChannelUseMusicRef(int index, boolean useMusicRef) throws IOException {
        if (index < 0 || index >= this.nChannels) {
            throw new IndexOutOfBoundsException();
        }
        this.useMusicRef[index] = useMusicRef;
        String outStr = String.format("MR%s%d,%c\r\nCW%s%d\r\n", this.cmdSeparator, index + 1, Character.valueOf(useMusicRef ? (char)'1' : '0'), this.cmdSeparator, index + 1);
        if (!this.AddToFIFO(outStr, Cmd.MR, false)) {
            throw new IOException("Failed to send Use Music Reference command to device. Command FIFO is full!");
        }
    }

    public ChMode getChannelMode(int index) {
        return this.channelMode[index];
    }

    public void setChannelMode(int index, ChMode channelMode) throws IOException {
        String outStr;
        if (index < 0 || index >= this.nChannels) {
            throw new IndexOutOfBoundsException();
        }
        int mask = 1 << this.groupAssign[index];
        if ((mask & this.systemOverride) != 0 || (mask & this.systemMute) != 0) {
            return;
        }
        if (this.bypass[index]) {
            this.bypass[index] = false;
            outStr = String.format("BP%s%d,0\r\n", this.cmdSeparator, index + 1);
            if (!this.AddToFIFO(outStr, Cmd.BP, false)) {
                throw new IOException("Failed to send channel bypass commmand to device. Command FIFO is full!");
            }
        }
        this.channelMode[index] = channelMode;
        outStr = String.format("CM%s%d,%d\r\n", this.cmdSeparator, index + 1, channelMode.ordinal());
        if (!this.AddToFIFO(outStr, Cmd.CM, false)) {
            throw new IOException("Failed to send channel mode command to device. Command FIFO is full!");
        }
    }

    public void setGroupAssign(int index, int groupAssign) throws IOException {
        if (index < 0 || index >= this.nChannels) {
            throw new IndexOutOfBoundsException();
        }
        if (groupAssign < 1 || groupAssign > 3) {
            throw new IndexOutOfBoundsException();
        }
        this.groupAssign[index] = groupAssign;
        String outStr = String.format("GA%s%d,%d\r\n", this.cmdSeparator, index + 1, groupAssign);
        if (!this.AddToFIFO(outStr, Cmd.GA, false)) {
            throw new IOException("Failed to send group assignment command to device. Command FIFO is full!");
        }
    }

    public void setChannelPreset(int index, ChMode channelPreset) throws IOException {
        if (index < 0 || index >= this.nChannels) {
            throw new IndexOutOfBoundsException();
        }
        this.channelPreset[index] = channelPreset;
        String outStr = String.format("CP%s%d,%d\r\n", this.cmdSeparator, index + 1, channelPreset.ordinal());
        if (!this.AddToFIFO(outStr, Cmd.CP, false)) {
            throw new IOException("Failed to send channel preset command to device. Command FIFO is full!");
        }
    }

    public void setChannelName(int index, String channelName) throws IOException {
        if (index < 0 || index >= this.nChannels) {
            throw new IndexOutOfBoundsException();
        }
        this.channelName[index] = channelName = channelName.replace(System.getProperty("line.separator"), "");
        String outStr = this.oldCmdSet ? String.format("CN %d,%s", index + 1, channelName) : String.format("CN,%d,%s\r\n", index + 1, channelName);
        if (!this.AddToFIFO(outStr, Cmd.CN, false)) {
            throw new IOException("Failed to send channel name command to device. Command FIFO is full!");
        }
    }

    public void setChannelWeight(int index, double channelWeight) throws IOException {
        if (index < 0 || index >= this.nChannels) {
            throw new IndexOutOfBoundsException();
        }
        this.channelWeight[index] = channelWeight;
        String outStr = String.format(Locale.US, "CW%s%d,%.2f\r\n", this.cmdSeparator, index + 1, channelWeight);
        if (!this.AddToFIFO(outStr, Cmd.CW, false)) {
            throw new IOException("Failed to send channel weight command to device. Command FIFO is full!");
        }
    }

    public void setNomGainLimit(int index, double ngl) throws IOException {
        if (index < 0 || index >= 3) {
            throw new IndexOutOfBoundsException();
        }
        this.nomGainLimit[index] = ngl;
        String outStr = String.format(Locale.US, "NL%s%d,%.2f\r\n", this.cmdSeparator, index + 1, ngl);
        if (!this.AddToFIFO(outStr, Cmd.NL, false)) {
            throw new IOException("Failed to send NOM gain limit command to device. Command FIFO is full!");
        }
    }

    public void setMusicThreshold(int index, double threshold) throws IOException {
        if (index < 0 || index >= 3) {
            throw new IndexOutOfBoundsException();
        }
        this.musicThreshold[index] = threshold;
        String outStr = String.format(Locale.US, "MT%s%d,%.2f\r\n", this.cmdSeparator, index + 1, threshold);
        if (!this.AddToFIFO(outStr, Cmd.MT, false)) {
            throw new IOException("Failed to send music threshold command to device. Command FIFO is full!");
        }
    }

    public void setAutoMixDepth(int index, double amd) throws IOException {
        if (index < 0 || index >= 3) {
            throw new IndexOutOfBoundsException();
        }
        this.autoMixDepth[index] = amd;
        String outStr = String.format(Locale.US, "AD%s%d,%.2f\r\n", this.cmdSeparator, index + 1, amd);
        if (!this.AddToFIFO(outStr, Cmd.AD, false)) {
            throw new IOException("Failed to send auto mix depth command to device. Command FIFO is full!");
        }
    }

    public void GetModel() throws IOException {
        if (!this.AddToFIFO("SC\r\n", Cmd.SC, false)) {
            throw new IOException("Unit scan failed. Command FIFO is full!");
        }
    }

    public void setSystemOverride(int override) throws IOException {
        this.systemOverride = override;
        String outStr = String.format("SO%s%d\r\n", this.cmdSeparator, override);
        if (!(this.masterMode && this.nSlaves <= 0 || this.AddToFIFO(outStr, Cmd.SO, true))) {
            throw new IOException("Failed to send System Override command to device. Command FIFO is full!");
        }
        if (!this.AddToFIFO(outStr, Cmd.SO, false)) {
            throw new IOException("Failed to send System Override command to device. Command FIFO is full!");
        }
    }

    public void setLastHold(int group, boolean lastHold) throws IOException {
        this.lastHold = lastHold ? (this.lastHold |= 1 << group) : (this.lastHold &= ~(1 << group));
        String outStr = String.format("LH%s%d\r\n", this.cmdSeparator, this.lastHold);
        if (!this.AddToFIFO(outStr, Cmd.LH, false)) {
            throw new IOException("Failed to send System Last Hold command to device. Command FIFO is full!");
        }
    }

    public void deleteScene(String scene) throws IOException {
        String outStr = String.format("SND%s%s\r\n", this.cmdSeparator, scene);
        if (!this.AddToFIFO(outStr, Cmd.SND, false)) {
            throw new IOException("Failed to send Delete Scene command to device. Command FIFO is full!");
        }
    }

    public void loadScene(String scene) throws IOException {
        String outStr = String.format("SNR%s%s\r\n", this.cmdSeparator, scene);
        if (!this.AddToFIFO(outStr, Cmd.SNR, false)) {
            throw new IOException("Failed to send Load Scene command to device. Command FIFO is full!");
        }
    }

    public void saveScene(String scene) throws IOException {
        String outStr = String.format("SNS%s%s\r\n", this.cmdSeparator, scene);
        if (!this.AddToFIFO(outStr, Cmd.SNS, false)) {
            throw new IOException("Failed to send Save Scene command to device. Command FIFO is full!");
        }
    }

    public void newScene() throws IOException {
        if (!this.AddToFIFO("SNN\r\n", Cmd.SNN, false)) {
            throw new IOException("Failed to send New Scene command to device. Command FIFO is full!");
        }
    }

    public void setSystemPreset(int preset) throws IOException {
        this.systemPreset = preset;
        String outStr = String.format("SP%s%d\r\n", this.cmdSeparator, preset);
        if (!(this.masterMode && this.nSlaves <= 0 || this.AddToFIFO(outStr, Cmd.SP, true))) {
            throw new IOException("Failed to send System Preset command to device. Command FIFO is full!");
        }
        if (!this.AddToFIFO(outStr, Cmd.SP, false)) {
            throw new IOException("Failed to send System Preset command to device. Command FIFO is full!");
        }
        this.AddToFIFO("GP\r\n", Cmd.GP, true);
    }

    public void setSystemMute(int mute) throws IOException {
        this.systemMute = mute;
        String outStr = String.format("SM%s%d\r\n", this.cmdSeparator, mute);
        if (!(this.masterMode && this.nSlaves <= 0 || this.AddToFIFO(outStr, Cmd.SM, true))) {
            throw new IOException("Failed to send System Mute command to device. Command FIFO is full!");
        }
        if (!this.AddToFIFO(outStr, Cmd.SM, false)) {
            throw new IOException("Failed to send System Mute command to device. Command FIFO is full!");
        }
    }

    public int getLinkGroup() {
        return this.linkGroup;
    }

    public void setLinkGroup(int lg) throws IOException {
        String outStr = String.format("LG%s%d\r\n", this.cmdSeparator, lg);
        if (!this.AddToFIFO(outStr, Cmd.LG, false)) {
            throw new IOException("Failed to send link group command to device.Command FIFO is full!");
        }
        this.linkGroup = lg;
    }

    public void setClockSource(int which) throws IOException {
        String outStr = String.format("CS%s%d\r\n", this.cmdSeparator, which);
        if (!this.AddToFIFO(outStr, Cmd.CS, false)) {
            throw new IOException("Failed to send clock source change command to device. Command FIFO is full!");
        }
    }

    public int getAdatEcho() {
        return this.adatEcho;
    }

    public boolean getAdatAudio() {
        return this.adatAudio;
    }

    public void setAdatAudio(boolean adatAudio) throws IOException {
        this.adatAudio = adatAudio;
        String outStr = String.format("AA%s%c\r\n", this.cmdSeparator, Character.valueOf(adatAudio ? (char)'1' : '0'));
        if (!this.AddToFIFO(outStr, Cmd.AA, false)) {
            throw new IOException("Failed to send ADAT audio command to device. Command FIFO is full!");
        }
    }

    public void setAdat16Ch(boolean is16Ch) throws IOException {
        this.adat16Ch = is16Ch;
        String outStr = String.format("AM%s%c\r\n", this.cmdSeparator, Character.valueOf(is16Ch ? (char)'2' : '1'));
        if (!this.AddToFIFO(outStr, Cmd.AM, false)) {
            throw new IOException("Failed to send ADAT 16 channel mode command to device. Command FIFO is full!");
        }
    }

    public void setAes14Ch(boolean is14Ch) throws IOException {
        this.aes14Ch = is14Ch;
        String outStr = String.format("EA%s%c\r\n", this.cmdSeparator, Character.valueOf(is14Ch ? (char)'1' : '0'));
        if (!this.AddToFIFO(outStr, Cmd.EA, false)) {
            throw new IOException("Failed to send AES 14 channel mode command to device. Command FIFO is full!");
        }
    }

    public void FactoryPreset() throws IOException {
        if (!this.AddToFIFO("FP\r\n", Cmd.FP, false)) {
            throw new IOException("Failed to send factory preset command to device. Command FIFO is full!");
        }
    }

    public void setMixerMute(int which, boolean mute) throws IOException {
        String outStr = String.format("MXM%s%d,%d\r\n", this.cmdSeparator, which + 1, mute ? 1 : 0);
        if (!this.AddToFIFO(outStr, Cmd.MXM, false)) {
            throw new IOException("Failed to send auxiliary mixer output mute command to device. Command FIFO is full!");
        }
    }

    public void setMixerPolarity(int which, boolean flipped) throws IOException {
        String outStr = String.format("MXP%s%d,%d\r\n", this.cmdSeparator, which + 1, flipped ? 1 : 0);
        if (!this.AddToFIFO(outStr, Cmd.MXP, false)) {
            throw new IOException("Failed to send auxiliary mixer output polarity command to device. Command FIFO is full!");
        }
    }

    public void setMixerVolume(int which, double volume) throws IOException {
        String outStr = String.format(Locale.US, "MXV%s%d,%.2f\r\n", this.cmdSeparator, which + 1, volume);
        if (!this.AddToFIFO(outStr, Cmd.MXV, false)) {
            throw new IOException("Failed to send auxiliary mixer output volume command to device. Command FIFO is full!");
        }
    }

    public void setMixerValue(int whichOutput, int whichInput, double val) throws IOException {
        String outStr = String.format(Locale.US, "OM%s%d,%d,%.2f\r\n", this.cmdSeparator, whichOutput + 1, whichInput + 1, val);
        if (!this.AddToFIFO(outStr, Cmd.OM, false)) {
            throw new IOException("Failed to send auxiliary mixer matrix cross point value to device. Command FIFO is full!");
        }
    }

    public void ResetMixer() throws IOException {
        if (!this.AddToFIFO("RM\r\n", Cmd.RM, false)) {
            throw new IOException("Failed to send mixer reset command to device. Command FIFO is full!");
        }
    }

    public void GetMixer() throws IOException {
        if (!this.AddToFIFO("GM\r\n", Cmd.GM, false)) {
            throw new IOException("Failed to send get mixer command to device. Command FIFO is full!");
        }
    }

    public boolean IsFIFOEmpty() {
        return this.fifoInPtr == this.fifoOutPtr;
    }

    private boolean AddToFIFO(String cmdStr, Cmd cmd, boolean checkMulticast) {
        int newInPtr = (this.fifoInPtr + 1) % 512;
        if (newInPtr == this.fifoOutPtr) {
            return false;
        }
        if (cmd == Cmd.GP) {
            if (this.gpPending > 0) {
                return true;
            }
            ++this.gpPending;
            this.lastGPPacket = System.currentTimeMillis();
        }
        this.cmdStrFIFO[this.fifoInPtr] = cmdStr;
        this.cmdFIFO[this.fifoInPtr] = cmd;
        this.cmdUseMulticast[this.fifoInPtr] = checkMulticast && this.linkGroup != 0;
        this.fifoInPtr = newInPtr;
        return true;
    }

    public void GetCurrent() {
        this.forceUpdateRequested = true;
        this.lastGSPacket = 0L;
    }

    public void GetConfig() {
        this.lastGPPacket = 0L;
    }

    public String getIpAddress() {
        return this.targetIPAddress;
    }

    public void setIpAddress(String ipAddress, InetAddress localAddress) {
        this.targetIPAddress = ipAddress;
        if (ipAddress.isEmpty()) {
            this.targetIP = null;
        } else {
            try {
                this.targetIP = InetAddress.getByName(ipAddress);
                this.lastGPPacket = 0L;
            }
            catch (UnknownHostException ex) {
                Logger.getLogger(UDPComm.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (localAddress != null) {
                try {
                    this.querySocket = new DatagramSocket(0, localAddress);
                    this.querySocket.setSoTimeout(1);
                    System.out.printf("Unit IP: %s, bound to local address %s.\r\n", ipAddress, localAddress.getHostAddress());
                }
                catch (SocketException ex) {
                    Logger.getLogger(UDPComm.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public String getNetmask() {
        return this.targetNetmask;
    }

    public void setNetmask(String netmask) {
        this.targetNetmask = netmask;
    }

    public String getGateway() {
        return this.targetGateway;
    }

    public void setGateway(String gateway) {
        this.targetGateway = gateway;
    }

    public boolean getDHCP() {
        return this.useDHCP;
    }

    public String getMAC() {
        return this.targetMAC;
    }

    public void setMAC(String mac) {
        this.targetMAC = mac;
    }

    public DevType getDeviceType() {
        return this.devType;
    }

    public ArrayList<String> getScenes() {
        return this.scenes;
    }

    public void setDeviceType(DevType type) {
        this.devType = type;
        switch (this.devType) {
            case MODEL_E: 
            case MODEL_E1: {
                this.oldCmdSet = true;
                this.cmdSeparator = " ";
                break;
            }
            case MODEL_MY: 
            case MODEL_E1A: 
            case MODEL_E2: 
            case MODEL_E3: 
            case MODEL_VN: 
            case MODEL_M: 
            case MODEL_N: 
            case MODEL_E2A: 
            case MODEL_E3A: 
            case MODEL_PY: {
                this.oldCmdSet = false;
                this.cmdSeparator = ",";
                break;
            }
            default: {
                this.oldCmdSet = false;
                this.cmdSeparator = ",";
            }
        }
    }

    public int getNChannels() {
        return this.nChannels;
    }

    public void assignUnitName(String name) {
        this.unitName = name;
    }

    public void setUnitName(String unitName) throws IOException {
        unitName = unitName.replace(System.getProperty("line.separator"), "");
        String outStr = this.oldCmdSet ? "NA " + unitName + "\r\n" : "NA," + unitName + "\r\n";
        if (!this.AddToFIFO(outStr, Cmd.NA, false)) {
            throw new IOException("Failed to send unit name change command to device. Command FIFO is full!");
        }
        outStr = "SS\r\n";
        if (!this.AddToFIFO(outStr, Cmd.SS, false)) {
            throw new IOException("Failed to send save system parameters command to device. Command FIFO is full!");
        }
    }

    public void setMixBusOutputSelect(int whichMix, int outputSelect) throws IOException {
        if (!this.AddToFIFO(String.format("MXO,%d,%d\r\n", whichMix + 1, outputSelect), Cmd.MXO, false)) {
            throw new IOException("Failed to send mix bus output select. Command FIFO is full!");
        }
    }

    public void sendGP() throws IOException {
        if (!this.AddToFIFO("GP\r\n", Cmd.GP, false)) {
            throw new IOException("Failed to send a GP command to device. Command FIFO is full!");
        }
    }

    public void sceneRename(String oldName, String newName) throws IOException {
        String outStr = String.format("SNE,%s,%s\r\nSNC\r\n", oldName, newName);
        if (!this.AddToFIFO(outStr, Cmd.SNE, false)) {
            throw new IOException("Failed to send SNE command to device. Command FIFO is full!");
        }
    }

    public void setNChannels(int nChannels) throws IOException {
        String outStr = String.format("CFN,%d\r\nSNC\r\n", nChannels);
        if (!this.AddToFIFO(outStr, Cmd.CFN, false)) {
            throw new IOException("Failed to send CFN command to device. Command FIFO is full!");
        }
    }

    public String getUnitName() {
        return this.unitName;
    }

    public boolean getLinkedToModelK() {
        return this.linkedToModelK;
    }

    public void setLinkedToModelK(boolean linked) {
        this.linkedToModelK = linked;
    }

    public boolean IsOldCmdSet() {
        return this.oldCmdSet;
    }

    public boolean IsNOMShown() {
        return this.nomShown;
    }

    public void SetNOMShown(boolean shown) {
        this.nomShown = shown;
    }

    public boolean IsOnline() {
        return this.isOnline;
    }

    public void bankChanged(String devIP, int bank) {
        if (!this.linkedToModelK) {
            return;
        }
        String outStr = String.format("DP,%s,%d", devIP, (bank - 1) * 8);
        this.AddToFIFO(outStr, Cmd.DP, false);
        System.out.println("Bank changed!\n");
    }

    public void SetBarMode(Channel.BarMode barMode) {
        this.bargraphMode = barMode;
        this.forceUpdateCnt = 100;
        this.lastGSPacket = 0L;
    }

    public boolean getGroupSpecificMaster() {
        return this.groupSpecificMaster;
    }

    public boolean getSceneChanged() {
        return this.sceneChanged;
    }

    public String getActiveScene() {
        return this.activeScene;
    }

    public int getNScenes() {
        return this.nScenes;
    }

    public void getMixerParams() {
        this.AddToFIFO("GM\r\n", Cmd.GM, false);
    }

    public boolean isADATCard() {
        return this.devType == DevType.MODEL_VN && this.nChannels == 0;
    }

    public void CheckGroups() {
        if (!this.groupSpecificMaster) {
            this.propertyChangeSupport.firePropertyChange("GroupCount", -1, this.nChannels);
            return;
        }
        int grpCount2 = 0;
        int grpCount1 = 0;
        int grpCount0 = 0;
        int i = 0;
        while (i < this.nChannels) {
            switch (this.groupAssign[i]) {
                case 0: {
                    ++grpCount0;
                    break;
                }
                case 1: {
                    ++grpCount1;
                    break;
                }
                case 2: {
                    ++grpCount2;
                }
            }
            ++i;
        }
        this.propertyChangeSupport.firePropertyChange("GroupCount", -1, grpCount0 + (grpCount1 << 8) + (grpCount2 << 16));
    }

    public int GetVersion(String sversion) {
        int i = 0;
        int j = sversion.length() - 1;
        while (!Character.isDigit(sversion.charAt(i))) {
            ++i;
        }
        while (!Character.isDigit(sversion.charAt(j))) {
            --j;
        }
        int version = i >= sversion.length() ? 0 : (i > j ? 0 : Math.round(Float.parseFloat(sversion.substring(i, j + 1)) * 100.0f));
        if (version == 2550) {
            version = 0;
        }
        return version;
    }

    public void setVersion(String version) {
        this.fwversion = this.GetVersion(version);
    }

    public int getVersion() {
        return this.fwversion;
    }

    public int getMusicInCh(int group) {
        return this.musicInCh[group];
    }

    public void setMusicInCh(int group, int inCh) throws IOException {
        if (this.musicInCh[group] == inCh) {
            return;
        }
        String outStr = String.format("MC%s%d,%d\r\n", this.cmdSeparator, group + 1, inCh + 1);
        if (!this.AddToFIFO(outStr, Cmd.MC, false)) {
            throw new IOException("Failed to send music input channel selection command to device. Command FIFO is full!");
        }
    }

    public boolean isSlave() {
        return !this.masterMode;
    }

    public void ForceGS() {
        this.forceUpdateCnt = 100;
        this.lastGSPacket = 0L;
    }

    public boolean SupportScene() {
        return this.devType == DevType.MODEL_M || this.devType == DevType.MODEL_N || this.devType == DevType.MODEL_E3A || this.devType == DevType.MODEL_E2A;
    }

    public boolean CheckUseMusicRef(int group) {
        if (group == 3) {
            int i = 0;
            while (i < this.nChannels) {
                if (this.useMusicRef[i] || this.nomEnable[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        int i = 0;
        while (i < this.nChannels) {
            if (this.groupAssign[i] == group && (this.useMusicRef[i] || this.nomEnable[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean HasScene(String name) {
        return this.scenes.contains(name);
    }

    public int getOptionFlags(int which) {
        return this.optionFlags[which];
    }

    public boolean HasMixer() {
        switch (this.devType) {
            case MODEL_E2: 
            case MODEL_E3: 
            case MODEL_E2A: 
            case MODEL_E3A: 
            case MODEL_PY: {
                return true;
            }
            case MODEL_N: {
                return this.fwversion >= 110;
            }
            case MODEL_M: {
                return this.fwversion >= 110;
            }
        }
        return false;
    }

    public boolean Is48K() {
        return this.clockIs48k;
    }

    public boolean Is96K() {
        return !this.clockIs48k;
    }

    public boolean HasADATLink() {
        int nativeChannels;
        if (!this.masterMode) {
            return true;
        }
        switch (this.devType) {
            case MODEL_E3A: {
                nativeChannels = 16;
                break;
            }
            case MODEL_E2A: {
                nativeChannels = 12;
                break;
            }
            case MODEL_E: {
                nativeChannels = 12;
                break;
            }
            case MODEL_E3: {
                nativeChannels = 14;
                break;
            }
            case MODEL_M: 
            case MODEL_N: {
                nativeChannels = 64;
                break;
            }
            case MODEL_PY: {
                return false;
            }
            default: {
                return true;
            }
        }
        if (this.adatAudio) {
            return this.nChannels != 16;
        }
        if (this.nChannels == nativeChannels + 16) {
            return false;
        }
        if (this.nChannels <= nativeChannels) {
            return this.adatEcho != 16;
        }
        return this.adatEcho == 0;
    }

    public static enum ChMode {
        MANUAL,
        AUTOMIX,
        MUTE,
        NONE;

    }

    public static enum Cmd {
        AA,
        AD,
        AM,
        BP,
        CFN,
        CM,
        CN,
        CNS,
        CO,
        CP,
        CS,
        CW,
        DH,
        DLS,
        DLUS,
        DLA,
        DLD,
        DLP,
        DLUD,
        DLP_DSP,
        DLP_LCA,
        DLP_UCC,
        DN,
        DP,
        EA,
        FP,
        GA,
        GC,
        GM,
        GP,
        GS,
        GU,
        GW,
        HR,
        HT,
        IP,
        LG,
        LH,
        LP,
        LR,
        MA,
        MC,
        MM,
        MR,
        MT,
        MXM,
        MXO,
        MXP,
        MXV,
        NA,
        NE,
        NL,
        NM,
        NS,
        OM,
        OS,
        PC,
        PD,
        PF,
        PL,
        PN,
        PR,
        PS,
        PT,
        RB,
        RM,
        SC,
        SM,
        SNA,
        SNC,
        SND,
        SNE,
        SNL,
        SNN,
        SNR,
        SNS,
        SO,
        SP,
        SS,
        ST,
        SU,
        UP,
        VE,
        OK,
        ERROR,
        TIMEOUT;

    }

    public static enum DevType {
        MODEL_NONE,
        MODEL_E,
        MODEL_D2,
        MODEL_D3,
        MODEL_E1,
        MODEL_MY,
        MODEL_E1A,
        MODEL_E2,
        MODEL_E3,
        MODEL_VN,
        MODEL_K,
        MODEL_M,
        MODEL_N,
        MODEL_E2A,
        MODEL_E3A,
        MODEL_PY;

    }
}

