/*
 * Decompiled with CFR 0.152.
 */
package DuganCP;

import DuganCP.CellRenderer;
import DuganCP.Channel;
import DuganCP.DuganUI;
import DuganCP.ImagePanel;
import DuganCP.RowHeaderListModel;
import DuganCP.RowHeaderRenderer;
import DuganCP.SmallMaster;
import DuganCP.UDPComm;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class MixMatrix
extends JPanel {
    private static final long serialVersionUID = -1559253114566762748L;
    public static final double MAX_MIXER_XPOINT_VAL = 15.0;
    public static final double MIN_MIXER_XPOINT_VAL = -96.0;
    public static final int PANEL_WIDTH = 1024;
    public static final int PANEL_HEIGHT = 691;
    private UDPComm m_udpComm = null;
    private int nActiveChannels;
    private int nPrimaryInputs;
    private RowHeaderListModel m_matrixRowHeaderModel;
    private TableColumn[] columns;
    private boolean hasADATLink = false;
    private ImageIcon clipLEDOffIcon;
    private ImageIcon clipLEDRedIcon;
    private ImageIcon muteOnIcon;
    private ImageIcon muteOffIcon;
    private ImageIcon muteOnDownIcon;
    private ImageIcon muteOffDownIcon;
    private ImageIcon phaseOnIcon;
    private ImageIcon phaseOffIcon;
    private ImageIcon phaseOnDownIcon;
    private ImageIcon phaseOffDownIcon;
    private ImageIcon led1OffIcon;
    private ImageIcon led1OffDownIcon;
    private JButton[] muteButtons;
    private JButton[] phaseButtons;
    private JSlider[] volumeSliders;
    private JLabel[] clipLEDs;
    private JLabel[] mixMasterLabel;
    private int[] ioLevelTable;
    private boolean[] mute;
    private boolean[] phase;
    private int[] outputSelect;
    private boolean resetMatrixRequested = false;
    private Border lineBorder;
    private Border emptyBorder;
    private boolean sliderChanging = false;
    private double[] volume;
    private JTextField[] volumeTF;
    private JProgressBar[] peakBars;
    private JPanel[] controlPanels;
    private JComboBox<String>[] outputSelectCB;
    private double[][] xpoint;
    private DuganUI m_duganUI = null;
    private int nRows;
    private NumberFormat decimalFormat;
    private Point mousePressedLocation;
    private Date lastDragUpdate;
    private int selectChanged = -1;
    private boolean ignoreChangeEvent = true;
    TableModelListener MatrixTableCellChanged = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            double dVal;
            int selectedColumn = e.getColumn();
            int selectedRow = e.getFirstRow();
            if (selectedRow == -1 || selectedColumn == -1) {
                return;
            }
            if (selectedRow >= MixMatrix.this.m_matrix.getModel().getRowCount()) {
                return;
            }
            String str = (String)MixMatrix.this.m_matrix.getModel().getValueAt(selectedRow, selectedColumn);
            if (str == null) {
                dVal = -96.0;
            } else if (str.length() == 0) {
                dVal = -96.0;
            } else {
                try {
                    dVal = MixMatrix.this.decimalFormat.parse(str).doubleValue();
                }
                catch (ParseException ex) {
                    Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
                    dVal = -96.0;
                }
            }
            if (dVal != MixMatrix.this.xpoint[selectedRow][selectedColumn] && MixMatrix.this.m_udpComm != null) {
                try {
                    MixMatrix.this.m_udpComm.setMixerValue(selectedRow, selectedColumn, dVal);
                }
                catch (IOException ex) {
                    Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    };
    private JLabel jLabel11;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel3;
    private JLabel jLabel31;
    private JLabel jLabel33;
    private JLabel jLabel36;
    private JLabel jLabel38;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JLabel m_bar1Label_0;
    private JLabel m_bar1Label_1;
    private JLabel m_bar1Label_2;
    private JLabel m_bar1Label_3;
    private JLabel m_bar1Label_4;
    private JLabel m_bar1Label_5;
    private JLabel m_barALabel_10;
    private JLabel m_barALabel_11;
    private JLabel m_barALabel_12;
    private JLabel m_barALabel_13;
    private JLabel m_barALabel_14;
    private JLabel m_barALabel_15;
    private JLabel m_barALabel_16;
    private JLabel m_barALabel_17;
    private JLabel m_barALabel_18;
    private JLabel m_barALabel_19;
    private JLabel m_barALabel_20;
    private JLabel m_barALabel_21;
    private JLabel m_barALabel_22;
    private JLabel m_barALabel_23;
    private JLabel m_barALabel_24;
    private JLabel m_barALabel_25;
    private JLabel m_barALabel_26;
    private JLabel m_barALabel_27;
    private JLabel m_barALabel_28;
    private JLabel m_barALabel_29;
    private JLabel m_barALabel_30;
    private JLabel m_barALabel_31;
    private JLabel m_barALabel_32;
    private JLabel m_barALabel_33;
    private JLabel m_barALabel_34;
    private JLabel m_barALabel_35;
    private JLabel m_barALabel_36;
    private JLabel m_barALabel_37;
    private JLabel m_barALabel_38;
    private JLabel m_barALabel_39;
    private JLabel m_barALabel_40;
    private JLabel m_barALabel_41;
    private JLabel m_barALabel_42;
    private JLabel m_barALabel_43;
    private JLabel m_barALabel_44;
    private JLabel m_barALabel_45;
    private JLabel m_barALabel_46;
    private JLabel m_barALabel_47;
    private JLabel m_barALabel_6;
    private JLabel m_barALabel_7;
    private JLabel m_barALabel_8;
    private JLabel m_barALabel_9;
    private JLabel m_clip1LED;
    private JLabel m_clip2LED;
    private JLabel m_clip3LED;
    private JLabel m_clip4LED;
    private JLabel m_clip5LED;
    private JLabel m_clip6LED;
    private JLabel m_clip7LED;
    private JLabel m_clip8LED;
    private JButton m_close;
    private JTable m_matrix;
    private JScrollPane m_matrixPane;
    private JLabel m_mixMaster1Label;
    private JLabel m_mixMaster2Label;
    private JLabel m_mixMaster3Label;
    private JLabel m_mixMaster4Label;
    private JLabel m_mixMaster5Label;
    private JLabel m_mixMaster6Label;
    private JLabel m_mixMaster7Label;
    private JLabel m_mixMaster8Label;
    private JButton m_mute1BT;
    private JButton m_mute2BT;
    private JButton m_mute3BT;
    private JButton m_mute4BT;
    private JButton m_mute5BT;
    private JButton m_mute6BT;
    private JButton m_mute7BT;
    private JButton m_mute8BT;
    private ImagePanel m_out1Panel;
    private ImagePanel m_out2Panel;
    private ImagePanel m_out3Panel;
    private ImagePanel m_out4Panel;
    private ImagePanel m_out5Panel;
    private ImagePanel m_out6Panel;
    private ImagePanel m_out7Panel;
    private ImagePanel m_out8Panel;
    private JComboBox<String> m_outputSelect_1;
    private JComboBox<String> m_outputSelect_2;
    private JComboBox<String> m_outputSelect_3;
    private JComboBox<String> m_outputSelect_4;
    private JComboBox<String> m_outputSelect_5;
    private JComboBox<String> m_outputSelect_6;
    private JComboBox<String> m_outputSelect_7;
    private JComboBox<String> m_outputSelect_8;
    private JProgressBar m_peak1Bar;
    private JProgressBar m_peak2Bar;
    private JProgressBar m_peak3Bar;
    private JProgressBar m_peak4Bar;
    private JProgressBar m_peak5Bar;
    private JProgressBar m_peak6Bar;
    private JProgressBar m_peak7Bar;
    private JProgressBar m_peak8Bar;
    private JButton m_phase1BT;
    private JButton m_phase2BT;
    private JButton m_phase3BT;
    private JButton m_phase4BT;
    private JButton m_phase5BT;
    private JButton m_phase6BT;
    private JButton m_phase7BT;
    private JButton m_phase8BT;
    private JButton m_setToDefaults;
    private JLabel m_title;
    private JLabel m_title1;
    private JSlider m_volume1Slider;
    private JTextField m_volume1TF;
    private JSlider m_volume2Slider;
    private JTextField m_volume2TF;
    private JSlider m_volume3Slider;
    private JTextField m_volume3TF;
    private JSlider m_volume4Slider;
    private JTextField m_volume4TF;
    private JSlider m_volume5Slider;
    private JTextField m_volume5TF;
    private JSlider m_volume6Slider;
    private JTextField m_volume6TF;
    private JSlider m_volume7Slider;
    private JTextField m_volume7TF;
    private JSlider m_volume8Slider;
    private JTextField m_volume8TF;
    PropertyChangeListener UDPMixerMuteListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            IndexedPropertyChangeEvent iEvt = (IndexedPropertyChangeEvent)evt;
            int which = iEvt.getIndex();
            ((MixMatrix)MixMatrix.this).mute[which] = (Boolean)iEvt.getNewValue();
            MixMatrix.this.muteButtons[which].setSelected(MixMatrix.this.mute[which]);
            if (MixMatrix.this.mute[which]) {
                MixMatrix.this.muteButtons[which].setPressedIcon(MixMatrix.this.muteOnDownIcon);
            } else {
                MixMatrix.this.muteButtons[which].setPressedIcon(MixMatrix.this.muteOffDownIcon);
            }
        }
    };
    PropertyChangeListener UDPMixerPolarityListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            IndexedPropertyChangeEvent iEvt = (IndexedPropertyChangeEvent)evt;
            int which = iEvt.getIndex();
            ((MixMatrix)MixMatrix.this).phase[which] = (Boolean)iEvt.getNewValue();
            MixMatrix.this.phaseButtons[which].setSelected(MixMatrix.this.phase[which]);
            if (MixMatrix.this.phase[which]) {
                MixMatrix.this.phaseButtons[which].setPressedIcon(MixMatrix.this.phaseOnDownIcon);
            } else {
                MixMatrix.this.phaseButtons[which].setPressedIcon(MixMatrix.this.phaseOffDownIcon);
            }
        }
    };
    PropertyChangeListener UDPMixerVolumeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            IndexedPropertyChangeEvent iEvt = (IndexedPropertyChangeEvent)evt;
            int which = iEvt.getIndex();
            ((MixMatrix)MixMatrix.this).volume[which] = (Double)iEvt.getNewValue();
            if (MixMatrix.this.volume[which] <= -30.0) {
                MixMatrix.this.volumeSliders[which].setValue(0);
                MixMatrix.this.volumeTF[which].setText("0.0");
            } else {
                MixMatrix.this.volumeSliders[which].setValue((int)((MixMatrix.this.volume[which] + 30.0) * 2.0 + 0.5));
                MixMatrix.this.volumeTF[which].setText(String.format("%.1f", MixMatrix.this.volume[which]));
            }
        }
    };
    PropertyChangeListener UDPMixPeaksListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            IndexedPropertyChangeEvent iEvt = (IndexedPropertyChangeEvent)evt;
            int offset = iEvt.getIndex();
            byte[] buf = (byte[])evt.getNewValue();
            int i = 0;
            while (i < MixMatrix.this.nRows) {
                int val = 0xFF & buf[offset];
                if (val == 0) {
                    MixMatrix.this.clipLEDs[i].setIcon(MixMatrix.this.clipLEDRedIcon);
                } else {
                    MixMatrix.this.clipLEDs[i].setIcon(MixMatrix.this.clipLEDOffIcon);
                }
                if (val > 120) {
                    MixMatrix.this.peakBars[i].setValue(0);
                } else {
                    MixMatrix.this.peakBars[i].setValue(MixMatrix.this.ioLevelTable[val]);
                }
                ++i;
                ++offset;
            }
        }
    };
    PropertyChangeListener UDPMixerCrossPointListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            double dVal;
            IndexedPropertyChangeEvent iEvt = (IndexedPropertyChangeEvent)evt;
            int whichInput = iEvt.getIndex() & 0xFF;
            int whichOutput = iEvt.getIndex() >> 8 & 0xFF;
            ((MixMatrix)MixMatrix.this).xpoint[whichOutput][whichInput] = dVal = ((Double)iEvt.getNewValue()).doubleValue();
            if (dVal <= -96.0) {
                MixMatrix.this.m_matrix.getModel().setValueAt("", whichOutput, whichInput);
            } else {
                MixMatrix.this.m_matrix.getModel().setValueAt(String.format("%.1f", dVal), whichOutput, whichInput);
            }
        }
    };
    PropertyChangeListener UDPMixerOutputSelectListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            IndexedPropertyChangeEvent iEvt = (IndexedPropertyChangeEvent)evt;
            int whichMix = iEvt.getIndex() & 0xFF;
            int whichOutput = (Integer)iEvt.getNewValue();
            if (MixMatrix.this.outputSelectCB[whichMix].getSelectedIndex() == whichOutput) {
                return;
            }
            MixMatrix.this.selectChanged = whichMix;
            MixMatrix.this.outputSelectCB[whichMix].setSelectedIndex(whichOutput);
            ((MixMatrix)MixMatrix.this).outputSelect[whichMix] = whichOutput;
            MixMatrix.this.m_matrixRowHeaderModel.setElementAt(whichMix, (String)MixMatrix.this.outputSelectCB[whichMix].getSelectedItem());
            MixMatrix.this.m_matrixPane.getRowHeader().repaint();
        }
    };
    PropertyChangeListener UDPMixerParamsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            MixMatrix.this.ProcessMixerParams((byte[])evt.getNewValue());
        }
    };
    PropertyChangeListener UDPNChannelListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            UDPComm.DevType devType = MixMatrix.this.m_udpComm.getDeviceType();
            if (devType != UDPComm.DevType.MODEL_E3 && devType != UDPComm.DevType.MODEL_E2 && devType != UDPComm.DevType.MODEL_E2A && devType != UDPComm.DevType.MODEL_E3A && devType != UDPComm.DevType.MODEL_N && devType != UDPComm.DevType.MODEL_M) {
                return;
            }
            int nc = (Integer)evt.getNewValue();
            if (nc != MixMatrix.this.nActiveChannels) {
                MixMatrix.this.setNActiveChannels(nc);
                MixMatrix.this.setHasADATLink();
            }
        }
    };
    PropertyChangeListener UDPAdatAudioListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            UDPComm.DevType devType = MixMatrix.this.m_udpComm.getDeviceType();
            if (devType != UDPComm.DevType.MODEL_E3 && devType != UDPComm.DevType.MODEL_E2 && devType != UDPComm.DevType.MODEL_E2A && devType != UDPComm.DevType.MODEL_E3A && devType != UDPComm.DevType.MODEL_N && devType != UDPComm.DevType.MODEL_M) {
                return;
            }
            MixMatrix.this.setHasADATLink();
        }
    };
    PropertyChangeListener UDPAdat16ChannelsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            UDPComm.DevType devType = MixMatrix.this.m_udpComm.getDeviceType();
            if (devType != UDPComm.DevType.MODEL_E3 && devType != UDPComm.DevType.MODEL_E2 && devType != UDPComm.DevType.MODEL_E2A && devType != UDPComm.DevType.MODEL_E3A && devType != UDPComm.DevType.MODEL_N && devType != UDPComm.DevType.MODEL_M) {
                return;
            }
            MixMatrix.this.setHasADATLink();
        }
    };

    public MixMatrix() {
        this.initComponents();
        this.decimalFormat = String.format("%.1f", 1.5).contains(",") ? NumberFormat.getInstance(Locale.FRANCE) : NumberFormat.getInstance(Locale.US);
        this.lineBorder = BorderFactory.createLineBorder(new Color(204, 204, 204));
        this.emptyBorder = BorderFactory.createEmptyBorder();
        this.nRows = 8;
        this.nActiveChannels = 16;
        this.nPrimaryInputs = 14;
        this.clipLEDOffIcon = Channel.CreateImageIcon("/DuganCP/Images/led_off.png", this.m_clip1LED.getWidth(), this.m_clip1LED.getHeight(), "Off LED");
        this.clipLEDRedIcon = Channel.CreateImageIcon("/DuganCP/Images/led_red_on.png", this.m_clip1LED.getWidth(), this.m_clip1LED.getHeight(), "Red LED");
        this.muteOnIcon = Channel.CreateImageIcon("/DuganCP/Images/mute_on.png", this.m_mute1BT.getWidth(), this.m_mute1BT.getHeight(), "Mute On");
        this.muteOffIcon = Channel.CreateImageIcon("/DuganCP/Images/mute_off.png", this.m_mute1BT.getWidth(), this.m_mute1BT.getHeight(), "Mute Off");
        this.muteOnDownIcon = Channel.CreateImageIcon("/DuganCP/Images/mute_on_down.png", this.m_mute1BT.getWidth(), this.m_mute1BT.getHeight(), "Mute On Down");
        this.muteOffDownIcon = Channel.CreateImageIcon("/DuganCP/Images/mute_off_down.png", this.m_mute1BT.getWidth(), this.m_mute1BT.getHeight(), "Mute Off Down");
        this.phaseOnIcon = Channel.CreateImageIcon("/DuganCP/Images/phase_on.png", this.m_phase1BT.getWidth(), this.m_phase1BT.getHeight(), "phase On");
        this.phaseOffIcon = Channel.CreateImageIcon("/DuganCP/Images/phase_off.png", this.m_phase1BT.getWidth(), this.m_phase1BT.getHeight(), "phase Off");
        this.phaseOnDownIcon = Channel.CreateImageIcon("/DuganCP/Images/phase_on_down.png", this.m_phase1BT.getWidth(), this.m_phase1BT.getHeight(), "phase On Down");
        this.phaseOffDownIcon = Channel.CreateImageIcon("/DuganCP/Images/phase_off_down.png", this.m_phase1BT.getWidth(), this.m_phase1BT.getHeight(), "phase Off Down");
        this.led1OffIcon = Channel.CreateImageIcon("/DuganCP/Images/led1_off.png", this.m_setToDefaults.getWidth(), this.m_setToDefaults.getHeight(), "Off LED");
        this.led1OffDownIcon = Channel.CreateImageIcon("/DuganCP/Images/led1_off_down.png", this.m_setToDefaults.getWidth(), this.m_setToDefaults.getHeight(), "Off LED");
        this.controlPanels = new JPanel[8];
        this.controlPanels[0] = this.m_out1Panel;
        this.controlPanels[1] = this.m_out2Panel;
        this.controlPanels[2] = this.m_out3Panel;
        this.controlPanels[3] = this.m_out4Panel;
        this.controlPanels[4] = this.m_out5Panel;
        this.controlPanels[5] = this.m_out6Panel;
        this.controlPanels[6] = this.m_out7Panel;
        this.controlPanels[7] = this.m_out8Panel;
        this.muteButtons = new JButton[8];
        this.muteButtons[0] = this.m_mute1BT;
        this.muteButtons[1] = this.m_mute2BT;
        this.muteButtons[2] = this.m_mute3BT;
        this.muteButtons[3] = this.m_mute4BT;
        this.muteButtons[4] = this.m_mute5BT;
        this.muteButtons[5] = this.m_mute6BT;
        this.muteButtons[6] = this.m_mute7BT;
        this.muteButtons[7] = this.m_mute8BT;
        this.phaseButtons = new JButton[8];
        this.phaseButtons[0] = this.m_phase1BT;
        this.phaseButtons[1] = this.m_phase2BT;
        this.phaseButtons[2] = this.m_phase3BT;
        this.phaseButtons[3] = this.m_phase4BT;
        this.phaseButtons[4] = this.m_phase5BT;
        this.phaseButtons[5] = this.m_phase6BT;
        this.phaseButtons[6] = this.m_phase7BT;
        this.phaseButtons[7] = this.m_phase8BT;
        this.volumeSliders = new JSlider[8];
        this.volumeSliders[0] = this.m_volume1Slider;
        this.volumeSliders[1] = this.m_volume2Slider;
        this.volumeSliders[2] = this.m_volume3Slider;
        this.volumeSliders[3] = this.m_volume4Slider;
        this.volumeSliders[4] = this.m_volume5Slider;
        this.volumeSliders[5] = this.m_volume6Slider;
        this.volumeSliders[6] = this.m_volume7Slider;
        this.volumeSliders[7] = this.m_volume8Slider;
        this.volumeTF = new JTextField[8];
        this.volumeTF[0] = this.m_volume1TF;
        this.volumeTF[1] = this.m_volume2TF;
        this.volumeTF[2] = this.m_volume3TF;
        this.volumeTF[3] = this.m_volume4TF;
        this.volumeTF[4] = this.m_volume5TF;
        this.volumeTF[5] = this.m_volume6TF;
        this.volumeTF[6] = this.m_volume7TF;
        this.volumeTF[7] = this.m_volume8TF;
        this.peakBars = new JProgressBar[8];
        this.peakBars[0] = this.m_peak1Bar;
        this.peakBars[1] = this.m_peak2Bar;
        this.peakBars[2] = this.m_peak3Bar;
        this.peakBars[3] = this.m_peak4Bar;
        this.peakBars[4] = this.m_peak5Bar;
        this.peakBars[5] = this.m_peak6Bar;
        this.peakBars[6] = this.m_peak7Bar;
        this.peakBars[7] = this.m_peak8Bar;
        this.clipLEDs = new JLabel[8];
        this.clipLEDs[0] = this.m_clip1LED;
        this.clipLEDs[1] = this.m_clip2LED;
        this.clipLEDs[2] = this.m_clip3LED;
        this.clipLEDs[3] = this.m_clip4LED;
        this.clipLEDs[4] = this.m_clip5LED;
        this.clipLEDs[5] = this.m_clip6LED;
        this.clipLEDs[6] = this.m_clip7LED;
        this.clipLEDs[7] = this.m_clip8LED;
        this.mixMasterLabel = new JLabel[8];
        this.mixMasterLabel[0] = this.m_mixMaster1Label;
        this.mixMasterLabel[1] = this.m_mixMaster2Label;
        this.mixMasterLabel[2] = this.m_mixMaster3Label;
        this.mixMasterLabel[3] = this.m_mixMaster4Label;
        this.mixMasterLabel[4] = this.m_mixMaster5Label;
        this.mixMasterLabel[5] = this.m_mixMaster6Label;
        this.mixMasterLabel[6] = this.m_mixMaster7Label;
        this.mixMasterLabel[7] = this.m_mixMaster8Label;
        this.outputSelectCB = new JComboBox[8];
        this.outputSelectCB[0] = this.m_outputSelect_1;
        this.outputSelectCB[1] = this.m_outputSelect_2;
        this.outputSelectCB[2] = this.m_outputSelect_3;
        this.outputSelectCB[3] = this.m_outputSelect_4;
        this.outputSelectCB[4] = this.m_outputSelect_5;
        this.outputSelectCB[5] = this.m_outputSelect_6;
        this.outputSelectCB[6] = this.m_outputSelect_7;
        this.outputSelectCB[7] = this.m_outputSelect_8;
        this.volume = new double[8];
        this.mute = new boolean[8];
        this.phase = new boolean[8];
        this.outputSelect = new int[8];
        int i = 0;
        while (i < 8) {
            this.muteButtons[i].setIcon(this.muteOffIcon);
            this.muteButtons[i].setSelectedIcon(this.muteOnIcon);
            this.muteButtons[i].setPressedIcon(this.muteOffDownIcon);
            this.phaseButtons[i].setIcon(this.phaseOffIcon);
            this.phaseButtons[i].setSelectedIcon(this.phaseOnIcon);
            this.phaseButtons[i].setPressedIcon(this.phaseOffDownIcon);
            this.volume[i] = 0.0;
            this.mute[i] = false;
            this.phase[i] = false;
            this.outputSelect[i] = 0;
            this.outputSelectCB[i].setEditable(true);
            ((JTextField)this.outputSelectCB[i].getEditor().getEditorComponent()).setBackground(Color.GRAY);
            ((JTextField)this.outputSelectCB[i].getEditor().getEditorComponent()).setForeground(new Color(248, 248, 248));
            ((JTextField)this.outputSelectCB[i].getEditor().getEditorComponent()).setHorizontalAlignment(0);
            ((JTextField)this.outputSelectCB[i].getEditor().getEditorComponent()).setBorder(new LineBorder(new Color(150, 150, 150), 2));
            ++i;
        }
        this.m_setToDefaults.setIcon(this.led1OffIcon);
        this.m_setToDefaults.setPressedIcon(this.led1OffDownIcon);
        this.m_close.setIcon(this.led1OffIcon);
        this.m_close.setPressedIcon(this.led1OffDownIcon);
        this.m_matrixRowHeaderModel = new RowHeaderListModel();
        JList<String> rowHeader = new JList<String>(this.m_matrixRowHeaderModel);
        rowHeader.setFixedCellWidth(85);
        rowHeader.setFixedCellHeight(this.m_matrix.getRowHeight());
        rowHeader.setCellRenderer(new RowHeaderRenderer(this.m_matrix));
        this.m_matrixPane.setRowHeaderView(rowHeader);
        CellRenderer renderer = new CellRenderer();
        this.m_matrix.setDefaultRenderer(this.m_matrix.getColumnClass(1), renderer);
        this.m_matrix.getModel().addTableModelListener(this.MatrixTableCellChanged);
        this.m_matrix.getTableHeader().setReorderingAllowed(false);
        this.m_matrix.setAutoCreateRowSorter(false);
        this.columns = new TableColumn[this.m_matrix.getColumnCount()];
        i = 0;
        while (i < this.m_matrix.getColumnCount()) {
            this.columns[i] = this.m_matrix.getColumnModel().getColumn(i);
            ++i;
        }
        this.ioLevelTable = new int[121];
        i = 0;
        while (i < 121) {
            this.ioLevelTable[i] = i < 24 ? 120 - 2 * i : (i < 72 ? 96 - i : (i <= 120 ? (int)(60.0 - 0.5 * (double)i) : 0));
            ++i;
        }
        this.xpoint = new double[8][144];
        int j = 0;
        while (j < 8) {
            i = 0;
            while (i < 144) {
                this.xpoint[j][i] = -96.0;
                this.m_matrix.getModel().setValueAt("", j, i);
                ++i;
            }
            ++j;
        }
    }

    private void initComponents() {
        this.m_out1Panel = new ImagePanel();
        this.m_volume1TF = new JTextField();
        this.m_volume1Slider = new JSlider();
        this.m_peak1Bar = new JProgressBar();
        this.m_clip1LED = new JLabel();
        this.jLabel3 = new JLabel();
        this.m_mixMaster1Label = new JLabel();
        this.m_bar1Label_0 = new JLabel();
        this.m_bar1Label_1 = new JLabel();
        this.m_bar1Label_2 = new JLabel();
        this.m_bar1Label_3 = new JLabel();
        this.m_bar1Label_4 = new JLabel();
        this.m_bar1Label_5 = new JLabel();
        this.jLabel19 = new JLabel();
        this.m_mute1BT = new JButton();
        this.m_phase1BT = new JButton();
        this.m_outputSelect_1 = new JComboBox();
        this.m_out2Panel = new ImagePanel();
        this.m_volume2TF = new JTextField();
        this.m_volume2Slider = new JSlider();
        this.m_peak2Bar = new JProgressBar();
        this.m_clip2LED = new JLabel();
        this.jLabel11 = new JLabel();
        this.m_mixMaster2Label = new JLabel();
        this.m_barALabel_30 = new JLabel();
        this.m_barALabel_31 = new JLabel();
        this.m_barALabel_32 = new JLabel();
        this.m_barALabel_33 = new JLabel();
        this.m_barALabel_34 = new JLabel();
        this.m_barALabel_35 = new JLabel();
        this.jLabel18 = new JLabel();
        this.m_mute2BT = new JButton();
        this.m_phase2BT = new JButton();
        this.m_outputSelect_2 = new JComboBox();
        this.m_out3Panel = new ImagePanel();
        this.m_volume3TF = new JTextField();
        this.m_volume3Slider = new JSlider();
        this.m_peak3Bar = new JProgressBar();
        this.m_clip3LED = new JLabel();
        this.jLabel9 = new JLabel();
        this.m_mixMaster3Label = new JLabel();
        this.m_barALabel_24 = new JLabel();
        this.m_barALabel_25 = new JLabel();
        this.m_barALabel_26 = new JLabel();
        this.m_barALabel_27 = new JLabel();
        this.m_barALabel_28 = new JLabel();
        this.m_barALabel_29 = new JLabel();
        this.jLabel17 = new JLabel();
        this.m_mute3BT = new JButton();
        this.m_phase3BT = new JButton();
        this.m_outputSelect_3 = new JComboBox();
        this.m_out4Panel = new ImagePanel();
        this.m_volume4TF = new JTextField();
        this.m_volume4Slider = new JSlider();
        this.m_peak4Bar = new JProgressBar();
        this.m_clip4LED = new JLabel();
        this.jLabel7 = new JLabel();
        this.m_mixMaster4Label = new JLabel();
        this.m_barALabel_18 = new JLabel();
        this.m_barALabel_19 = new JLabel();
        this.m_barALabel_20 = new JLabel();
        this.m_barALabel_21 = new JLabel();
        this.m_barALabel_22 = new JLabel();
        this.m_barALabel_23 = new JLabel();
        this.jLabel16 = new JLabel();
        this.m_mute4BT = new JButton();
        this.m_phase4BT = new JButton();
        this.m_outputSelect_4 = new JComboBox();
        this.m_out5Panel = new ImagePanel();
        this.m_volume5TF = new JTextField();
        this.m_volume5Slider = new JSlider();
        this.m_peak5Bar = new JProgressBar();
        this.m_clip5LED = new JLabel();
        this.jLabel5 = new JLabel();
        this.m_mixMaster5Label = new JLabel();
        this.m_barALabel_12 = new JLabel();
        this.m_barALabel_13 = new JLabel();
        this.m_barALabel_14 = new JLabel();
        this.m_barALabel_15 = new JLabel();
        this.m_barALabel_16 = new JLabel();
        this.m_barALabel_17 = new JLabel();
        this.jLabel15 = new JLabel();
        this.m_mute5BT = new JButton();
        this.m_phase5BT = new JButton();
        this.m_outputSelect_5 = new JComboBox();
        this.m_out6Panel = new ImagePanel();
        this.m_volume6TF = new JTextField();
        this.m_volume6Slider = new JSlider();
        this.m_peak6Bar = new JProgressBar();
        this.m_clip6LED = new JLabel();
        this.jLabel4 = new JLabel();
        this.m_mixMaster6Label = new JLabel();
        this.m_barALabel_6 = new JLabel();
        this.m_barALabel_7 = new JLabel();
        this.m_barALabel_8 = new JLabel();
        this.m_barALabel_9 = new JLabel();
        this.m_barALabel_10 = new JLabel();
        this.m_barALabel_11 = new JLabel();
        this.jLabel14 = new JLabel();
        this.m_mute6BT = new JButton();
        this.m_phase6BT = new JButton();
        this.m_outputSelect_6 = new JComboBox();
        this.m_matrixPane = new JScrollPane();
        this.m_matrix = new JTable();
        this.m_close = new JButton();
        this.m_title = new JLabel();
        this.m_title1 = new JLabel();
        this.m_out7Panel = new ImagePanel();
        this.m_volume7TF = new JTextField();
        this.m_volume7Slider = new JSlider();
        this.m_peak7Bar = new JProgressBar();
        this.m_clip7LED = new JLabel();
        this.jLabel31 = new JLabel();
        this.m_mixMaster7Label = new JLabel();
        this.m_barALabel_36 = new JLabel();
        this.m_barALabel_37 = new JLabel();
        this.m_barALabel_38 = new JLabel();
        this.m_barALabel_39 = new JLabel();
        this.m_barALabel_40 = new JLabel();
        this.m_barALabel_41 = new JLabel();
        this.jLabel33 = new JLabel();
        this.m_mute7BT = new JButton();
        this.m_phase7BT = new JButton();
        this.m_outputSelect_7 = new JComboBox();
        this.m_out8Panel = new ImagePanel();
        this.m_volume8TF = new JTextField();
        this.m_volume8Slider = new JSlider();
        this.m_peak8Bar = new JProgressBar();
        this.m_clip8LED = new JLabel();
        this.jLabel36 = new JLabel();
        this.m_mixMaster8Label = new JLabel();
        this.m_barALabel_42 = new JLabel();
        this.m_barALabel_43 = new JLabel();
        this.m_barALabel_44 = new JLabel();
        this.m_barALabel_45 = new JLabel();
        this.m_barALabel_46 = new JLabel();
        this.m_barALabel_47 = new JLabel();
        this.jLabel38 = new JLabel();
        this.m_mute8BT = new JButton();
        this.m_phase8BT = new JButton();
        this.m_outputSelect_8 = new JComboBox();
        this.m_setToDefaults = new JButton();
        this.setBackground(new Color(50, 50, 50));
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.setPreferredSize(new Dimension(1024, 768));
        this.setLayout(null);
        this.m_out1Panel.setImagePath("/DuganCP/Images/greyBG.jpg");
        this.m_out1Panel.setMinimumSize(new Dimension(120, 280));
        this.m_out1Panel.setPreferredSize(new Dimension(120, 280));
        this.m_out1Panel.setLayout(null);
        this.m_volume1TF.setBackground(new Color(190, 190, 190));
        this.m_volume1TF.setFont(new Font("Tahoma", 1, 10));
        this.m_volume1TF.setHorizontalAlignment(0);
        this.m_volume1TF.setText("-100.0");
        this.m_volume1TF.setBorder(new SoftBevelBorder(1));
        this.m_volume1TF.setName("0");
        this.m_volume1TF.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MixMatrix.this.MousePressedHandler(evt);
            }
        });
        this.m_volume1TF.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                MixMatrix.this.MouseDraggedHandler(evt);
            }
        });
        this.m_volume1TF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MixMatrix.this.VolumeTFFocusLost(evt);
            }
        });
        this.m_volume1TF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MixMatrix.this.VolumeTFKeyReleased(evt);
            }
        });
        this.m_out1Panel.add(this.m_volume1TF);
        this.m_volume1TF.setBounds(59, 185, 45, 25);
        this.m_volume1Slider.setBackground(new Color(38, 38, 38));
        this.m_volume1Slider.setForeground(new Color(160, 160, 160));
        this.m_volume1Slider.setMaximum(90);
        this.m_volume1Slider.setOrientation(1);
        this.m_volume1Slider.setToolTipText("Control Click to reset to 0dB.");
        this.m_volume1Slider.setValue(60);
        this.m_volume1Slider.setPreferredSize(new Dimension(22, 118));
        this.m_volume1Slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MixMatrix.this.SliderMouseReleased(evt);
            }
        });
        this.m_volume1Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MixMatrix.this.SliderStateChanged(evt);
            }
        });
        this.m_volume1Slider.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MixMatrix.this.SliderFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MixMatrix.this.SliderFocusLost(evt);
            }
        });
        this.m_out1Panel.add(this.m_volume1Slider);
        this.m_volume1Slider.setBounds(65, 52, 30, 130);
        this.m_peak1Bar.setBackground(new Color(0, 0, 0));
        this.m_peak1Bar.setForeground(new Color(0, 255, 204));
        this.m_peak1Bar.setMaximum(120);
        this.m_peak1Bar.setOrientation(1);
        this.m_peak1Bar.setBorderPainted(false);
        this.m_peak1Bar.setFocusable(false);
        this.m_out1Panel.add(this.m_peak1Bar);
        this.m_peak1Bar.setBounds(32, 72, 14, 140);
        this.m_clip1LED.setBackground(new Color(150, 150, 150));
        this.m_clip1LED.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/off_led.jpg")));
        this.m_clip1LED.setFocusable(false);
        this.m_clip1LED.setIconTextGap(0);
        this.m_out1Panel.add(this.m_clip1LED);
        this.m_clip1LED.setBounds(25, 53, 24, 12);
        this.jLabel3.setFont(new Font("Lucida Grande", 1, 12));
        this.jLabel3.setForeground(new Color(204, 204, 204));
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("clip");
        this.jLabel3.setHorizontalTextPosition(0);
        this.m_out1Panel.add(this.jLabel3);
        this.jLabel3.setBounds(19, 34, 36, 21);
        this.m_mixMaster1Label.setForeground(new Color(204, 204, 204));
        this.m_mixMaster1Label.setHorizontalAlignment(0);
        this.m_mixMaster1Label.setText("aux out 1");
        this.m_out1Panel.add(this.m_mixMaster1Label);
        this.m_mixMaster1Label.setBounds(20, 14, 80, 16);
        this.m_bar1Label_0.setFont(new Font("Tahoma", 1, 10));
        this.m_bar1Label_0.setForeground(new Color(204, 204, 204));
        this.m_bar1Label_0.setHorizontalAlignment(4);
        this.m_bar1Label_0.setText("0");
        this.m_out1Panel.add(this.m_bar1Label_0);
        this.m_bar1Label_0.setBounds(5, 68, 20, 15);
        this.m_bar1Label_1.setFont(new Font("Tahoma", 1, 10));
        this.m_bar1Label_1.setForeground(new Color(204, 204, 204));
        this.m_bar1Label_1.setHorizontalAlignment(4);
        this.m_bar1Label_1.setText("-6");
        this.m_out1Panel.add(this.m_bar1Label_1);
        this.m_bar1Label_1.setBounds(5, 95, 20, 15);
        this.m_bar1Label_2.setFont(new Font("Tahoma", 1, 10));
        this.m_bar1Label_2.setForeground(new Color(204, 204, 204));
        this.m_bar1Label_2.setHorizontalAlignment(4);
        this.m_bar1Label_2.setText("-12");
        this.m_out1Panel.add(this.m_bar1Label_2);
        this.m_bar1Label_2.setBounds(5, 122, 20, 15);
        this.m_bar1Label_3.setFont(new Font("Tahoma", 1, 10));
        this.m_bar1Label_3.setForeground(new Color(204, 204, 204));
        this.m_bar1Label_3.setHorizontalAlignment(4);
        this.m_bar1Label_3.setText("-24");
        this.m_out1Panel.add(this.m_bar1Label_3);
        this.m_bar1Label_3.setBounds(5, 149, 20, 15);
        this.m_bar1Label_4.setFont(new Font("Tahoma", 1, 10));
        this.m_bar1Label_4.setForeground(new Color(204, 204, 204));
        this.m_bar1Label_4.setHorizontalAlignment(4);
        this.m_bar1Label_4.setText("-36");
        this.m_out1Panel.add(this.m_bar1Label_4);
        this.m_bar1Label_4.setBounds(5, 176, 20, 15);
        this.m_bar1Label_5.setFont(new Font("Tahoma", 1, 10));
        this.m_bar1Label_5.setForeground(new Color(204, 204, 204));
        this.m_bar1Label_5.setHorizontalAlignment(4);
        this.m_bar1Label_5.setText("-60");
        this.m_out1Panel.add(this.m_bar1Label_5);
        this.m_bar1Label_5.setBounds(5, 203, 20, 15);
        this.jLabel19.setFont(new Font("Lucida Grande", 1, 12));
        this.jLabel19.setForeground(new Color(204, 204, 204));
        this.jLabel19.setHorizontalAlignment(0);
        this.jLabel19.setText("gain");
        this.jLabel19.setHorizontalTextPosition(0);
        this.m_out1Panel.add(this.jLabel19);
        this.jLabel19.setBounds(60, 34, 36, 21);
        this.m_mute1BT.setBackground(new Color(100, 100, 100));
        this.m_mute1BT.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/mute_off.png")));
        this.m_mute1BT.setToolTipText("Click to use or not use music reference.");
        this.m_mute1BT.setAlignmentY(0.0f);
        this.m_mute1BT.setBorder(null);
        this.m_mute1BT.setBorderPainted(false);
        this.m_mute1BT.setContentAreaFilled(false);
        this.m_mute1BT.setFocusable(false);
        this.m_mute1BT.setHorizontalTextPosition(0);
        this.m_mute1BT.setIconTextGap(0);
        this.m_mute1BT.setInheritsPopupMenu(true);
        this.m_mute1BT.setMargin(new Insets(0, 0, 0, 0));
        this.m_mute1BT.setMaximumSize(new Dimension(36, 36));
        this.m_mute1BT.setMinimumSize(new Dimension(36, 36));
        this.m_mute1BT.setPreferredSize(new Dimension(37, 37));
        this.m_mute1BT.setSelectedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led_yellow_on.png")));
        this.m_mute1BT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_mute1BTActionPerformed(evt);
            }
        });
        this.m_out1Panel.add(this.m_mute1BT);
        this.m_mute1BT.setBounds(7, 230, 50, 50);
        this.m_phase1BT.setBackground(new Color(100, 100, 100));
        this.m_phase1BT.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/phase_off.png")));
        this.m_phase1BT.setToolTipText("Click to enable/disable  channel NOM.");
        this.m_phase1BT.setAlignmentY(0.0f);
        this.m_phase1BT.setBorder(new SoftBevelBorder(0));
        this.m_phase1BT.setBorderPainted(false);
        this.m_phase1BT.setContentAreaFilled(false);
        this.m_phase1BT.setFocusable(false);
        this.m_phase1BT.setHorizontalTextPosition(0);
        this.m_phase1BT.setIconTextGap(0);
        this.m_phase1BT.setInheritsPopupMenu(true);
        this.m_phase1BT.setMargin(new Insets(0, 0, 0, 0));
        this.m_phase1BT.setMaximumSize(new Dimension(36, 36));
        this.m_phase1BT.setMinimumSize(new Dimension(36, 36));
        this.m_phase1BT.setPreferredSize(new Dimension(37, 37));
        this.m_phase1BT.setSelectedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led_yellow_on.png")));
        this.m_phase1BT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_phase1BTActionPerformed(evt);
            }
        });
        this.m_out1Panel.add(this.m_phase1BT);
        this.m_phase1BT.setBounds(61, 230, 50, 50);
        this.m_outputSelect_1.setFont(new Font("Lucida Grande", 0, 12));
        this.m_outputSelect_1.setModel(new DefaultComboBoxModel<String>(new String[]{"analog out 16", "Item 3", "Item 4"}));
        this.m_outputSelect_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.MixOutputSelectActionPerformed(evt);
            }
        });
        this.m_out1Panel.add(this.m_outputSelect_1);
        this.m_outputSelect_1.setBounds(5, 12, 108, 22);
        this.add(this.m_out1Panel);
        this.m_out1Panel.setBounds(40, 58, 118, 288);
        this.m_out2Panel.setImagePath("/DuganCP/Images/greyBG.jpg");
        this.m_out2Panel.setMinimumSize(new Dimension(110, 280));
        this.m_out2Panel.setPreferredSize(new Dimension(110, 280));
        this.m_out2Panel.setLayout(null);
        this.m_volume2TF.setBackground(new Color(190, 190, 190));
        this.m_volume2TF.setFont(new Font("Tahoma", 1, 10));
        this.m_volume2TF.setHorizontalAlignment(0);
        this.m_volume2TF.setText("-100.0");
        this.m_volume2TF.setBorder(new SoftBevelBorder(1));
        this.m_volume2TF.setName("1");
        this.m_volume2TF.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MixMatrix.this.MousePressedHandler(evt);
            }
        });
        this.m_volume2TF.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                MixMatrix.this.MouseDraggedHandler(evt);
            }
        });
        this.m_volume2TF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MixMatrix.this.VolumeTFFocusLost(evt);
            }
        });
        this.m_volume2TF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MixMatrix.this.VolumeTFKeyReleased(evt);
            }
        });
        this.m_out2Panel.add(this.m_volume2TF);
        this.m_volume2TF.setBounds(59, 185, 45, 25);
        this.m_volume2Slider.setBackground(new Color(38, 38, 38));
        this.m_volume2Slider.setForeground(new Color(160, 160, 160));
        this.m_volume2Slider.setMaximum(90);
        this.m_volume2Slider.setOrientation(1);
        this.m_volume2Slider.setToolTipText("Control Click to reset to 0dB.");
        this.m_volume2Slider.setValue(60);
        this.m_volume2Slider.setPreferredSize(new Dimension(22, 118));
        this.m_volume2Slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MixMatrix.this.SliderMouseReleased(evt);
            }
        });
        this.m_volume2Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MixMatrix.this.SliderStateChanged(evt);
            }
        });
        this.m_volume2Slider.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MixMatrix.this.SliderFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MixMatrix.this.SliderFocusLost(evt);
            }
        });
        this.m_out2Panel.add(this.m_volume2Slider);
        this.m_volume2Slider.setBounds(65, 52, 30, 130);
        this.m_peak2Bar.setBackground(new Color(0, 0, 0));
        this.m_peak2Bar.setForeground(new Color(0, 255, 204));
        this.m_peak2Bar.setMaximum(120);
        this.m_peak2Bar.setOrientation(1);
        this.m_peak2Bar.setBorderPainted(false);
        this.m_peak2Bar.setFocusable(false);
        this.m_out2Panel.add(this.m_peak2Bar);
        this.m_peak2Bar.setBounds(32, 72, 14, 140);
        this.m_clip2LED.setBackground(new Color(150, 150, 150));
        this.m_clip2LED.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/off_led.jpg")));
        this.m_clip2LED.setFocusable(false);
        this.m_clip2LED.setIconTextGap(0);
        this.m_out2Panel.add(this.m_clip2LED);
        this.m_clip2LED.setBounds(25, 53, 24, 12);
        this.jLabel11.setFont(new Font("Lucida Grande", 1, 12));
        this.jLabel11.setForeground(new Color(204, 204, 204));
        this.jLabel11.setHorizontalAlignment(0);
        this.jLabel11.setText("clip");
        this.jLabel11.setHorizontalTextPosition(0);
        this.m_out2Panel.add(this.jLabel11);
        this.jLabel11.setBounds(19, 34, 36, 21);
        this.m_mixMaster2Label.setForeground(new Color(204, 204, 204));
        this.m_mixMaster2Label.setHorizontalAlignment(0);
        this.m_mixMaster2Label.setText("aux out 2");
        this.m_out2Panel.add(this.m_mixMaster2Label);
        this.m_mixMaster2Label.setBounds(20, 14, 80, 16);
        this.m_barALabel_30.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_30.setForeground(new Color(204, 204, 204));
        this.m_barALabel_30.setHorizontalAlignment(4);
        this.m_barALabel_30.setText("0");
        this.m_out2Panel.add(this.m_barALabel_30);
        this.m_barALabel_30.setBounds(5, 68, 20, 15);
        this.m_barALabel_31.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_31.setForeground(new Color(204, 204, 204));
        this.m_barALabel_31.setHorizontalAlignment(4);
        this.m_barALabel_31.setText("-6");
        this.m_out2Panel.add(this.m_barALabel_31);
        this.m_barALabel_31.setBounds(5, 95, 20, 15);
        this.m_barALabel_32.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_32.setForeground(new Color(204, 204, 204));
        this.m_barALabel_32.setHorizontalAlignment(4);
        this.m_barALabel_32.setText("-12");
        this.m_out2Panel.add(this.m_barALabel_32);
        this.m_barALabel_32.setBounds(5, 122, 20, 15);
        this.m_barALabel_33.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_33.setForeground(new Color(204, 204, 204));
        this.m_barALabel_33.setHorizontalAlignment(4);
        this.m_barALabel_33.setText("-24");
        this.m_out2Panel.add(this.m_barALabel_33);
        this.m_barALabel_33.setBounds(5, 149, 20, 15);
        this.m_barALabel_34.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_34.setForeground(new Color(204, 204, 204));
        this.m_barALabel_34.setHorizontalAlignment(4);
        this.m_barALabel_34.setText("-36");
        this.m_out2Panel.add(this.m_barALabel_34);
        this.m_barALabel_34.setBounds(5, 176, 20, 15);
        this.m_barALabel_35.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_35.setForeground(new Color(204, 204, 204));
        this.m_barALabel_35.setHorizontalAlignment(4);
        this.m_barALabel_35.setText("-60");
        this.m_out2Panel.add(this.m_barALabel_35);
        this.m_barALabel_35.setBounds(5, 203, 20, 15);
        this.jLabel18.setFont(new Font("Lucida Grande", 1, 12));
        this.jLabel18.setForeground(new Color(204, 204, 204));
        this.jLabel18.setHorizontalAlignment(0);
        this.jLabel18.setText("gain");
        this.jLabel18.setHorizontalTextPosition(0);
        this.m_out2Panel.add(this.jLabel18);
        this.jLabel18.setBounds(60, 34, 36, 21);
        this.m_mute2BT.setBackground(new Color(100, 100, 100));
        this.m_mute2BT.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/mute_off.png")));
        this.m_mute2BT.setToolTipText("Click to use or not use music reference.");
        this.m_mute2BT.setAlignmentY(0.0f);
        this.m_mute2BT.setBorder(new SoftBevelBorder(0));
        this.m_mute2BT.setBorderPainted(false);
        this.m_mute2BT.setContentAreaFilled(false);
        this.m_mute2BT.setFocusable(false);
        this.m_mute2BT.setHorizontalTextPosition(0);
        this.m_mute2BT.setIconTextGap(0);
        this.m_mute2BT.setInheritsPopupMenu(true);
        this.m_mute2BT.setMargin(new Insets(0, 0, 0, 0));
        this.m_mute2BT.setMaximumSize(new Dimension(36, 36));
        this.m_mute2BT.setMinimumSize(new Dimension(36, 36));
        this.m_mute2BT.setPreferredSize(new Dimension(37, 37));
        this.m_mute2BT.setSelectedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led_yellow_on.png")));
        this.m_mute2BT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_mute2BTActionPerformed(evt);
            }
        });
        this.m_out2Panel.add(this.m_mute2BT);
        this.m_mute2BT.setBounds(7, 230, 50, 50);
        this.m_phase2BT.setBackground(new Color(100, 100, 100));
        this.m_phase2BT.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/phase_off.png")));
        this.m_phase2BT.setToolTipText("Click to enable/disable  channel NOM.");
        this.m_phase2BT.setAlignmentY(0.0f);
        this.m_phase2BT.setBorder(new SoftBevelBorder(0));
        this.m_phase2BT.setBorderPainted(false);
        this.m_phase2BT.setContentAreaFilled(false);
        this.m_phase2BT.setFocusable(false);
        this.m_phase2BT.setHorizontalTextPosition(0);
        this.m_phase2BT.setIconTextGap(0);
        this.m_phase2BT.setInheritsPopupMenu(true);
        this.m_phase2BT.setMargin(new Insets(0, 0, 0, 0));
        this.m_phase2BT.setMaximumSize(new Dimension(36, 36));
        this.m_phase2BT.setMinimumSize(new Dimension(36, 36));
        this.m_phase2BT.setPreferredSize(new Dimension(37, 37));
        this.m_phase2BT.setSelectedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led_yellow_on.png")));
        this.m_phase2BT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_phase2BTActionPerformed(evt);
            }
        });
        this.m_out2Panel.add(this.m_phase2BT);
        this.m_phase2BT.setBounds(61, 230, 50, 50);
        this.m_outputSelect_2.setFont(new Font("Lucida Grande", 0, 12));
        this.m_outputSelect_2.setModel(new DefaultComboBoxModel<String>(new String[]{"analog out 16", "Item 3", "Item 4"}));
        this.m_outputSelect_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.MixOutputSelectActionPerformed(evt);
            }
        });
        this.m_out2Panel.add(this.m_outputSelect_2);
        this.m_outputSelect_2.setBounds(5, 12, 108, 22);
        this.add(this.m_out2Panel);
        this.m_out2Panel.setBounds(158, 58, 118, 288);
        this.m_out3Panel.setImagePath("/DuganCP/Images/greyBG.jpg");
        this.m_out3Panel.setMinimumSize(new Dimension(110, 280));
        this.m_out3Panel.setPreferredSize(new Dimension(110, 280));
        this.m_out3Panel.setLayout(null);
        this.m_volume3TF.setBackground(new Color(190, 190, 190));
        this.m_volume3TF.setFont(new Font("Tahoma", 1, 10));
        this.m_volume3TF.setHorizontalAlignment(0);
        this.m_volume3TF.setText("-100.0");
        this.m_volume3TF.setBorder(new SoftBevelBorder(1));
        this.m_volume3TF.setName("2");
        this.m_volume3TF.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MixMatrix.this.MousePressedHandler(evt);
            }
        });
        this.m_volume3TF.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                MixMatrix.this.MouseDraggedHandler(evt);
            }
        });
        this.m_volume3TF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MixMatrix.this.VolumeTFFocusLost(evt);
            }
        });
        this.m_volume3TF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MixMatrix.this.VolumeTFKeyReleased(evt);
            }
        });
        this.m_out3Panel.add(this.m_volume3TF);
        this.m_volume3TF.setBounds(59, 185, 45, 25);
        this.m_volume3Slider.setBackground(new Color(38, 38, 38));
        this.m_volume3Slider.setForeground(new Color(160, 160, 160));
        this.m_volume3Slider.setMaximum(90);
        this.m_volume3Slider.setOrientation(1);
        this.m_volume3Slider.setToolTipText("Control Click to reset to 0dB.");
        this.m_volume3Slider.setValue(60);
        this.m_volume3Slider.setPreferredSize(new Dimension(22, 118));
        this.m_volume3Slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MixMatrix.this.SliderMouseReleased(evt);
            }
        });
        this.m_volume3Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MixMatrix.this.SliderStateChanged(evt);
            }
        });
        this.m_volume3Slider.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MixMatrix.this.SliderFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MixMatrix.this.SliderFocusLost(evt);
            }
        });
        this.m_out3Panel.add(this.m_volume3Slider);
        this.m_volume3Slider.setBounds(65, 52, 30, 130);
        this.m_peak3Bar.setBackground(new Color(0, 0, 0));
        this.m_peak3Bar.setForeground(new Color(0, 255, 204));
        this.m_peak3Bar.setMaximum(120);
        this.m_peak3Bar.setOrientation(1);
        this.m_peak3Bar.setBorderPainted(false);
        this.m_peak3Bar.setFocusable(false);
        this.m_out3Panel.add(this.m_peak3Bar);
        this.m_peak3Bar.setBounds(32, 72, 14, 140);
        this.m_clip3LED.setBackground(new Color(150, 150, 150));
        this.m_clip3LED.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/off_led.jpg")));
        this.m_clip3LED.setFocusable(false);
        this.m_clip3LED.setIconTextGap(0);
        this.m_out3Panel.add(this.m_clip3LED);
        this.m_clip3LED.setBounds(25, 53, 24, 12);
        this.jLabel9.setFont(new Font("Lucida Grande", 1, 12));
        this.jLabel9.setForeground(new Color(204, 204, 204));
        this.jLabel9.setHorizontalAlignment(0);
        this.jLabel9.setText("clip");
        this.jLabel9.setHorizontalTextPosition(0);
        this.m_out3Panel.add(this.jLabel9);
        this.jLabel9.setBounds(19, 34, 36, 21);
        this.m_mixMaster3Label.setForeground(new Color(204, 204, 204));
        this.m_mixMaster3Label.setHorizontalAlignment(0);
        this.m_mixMaster3Label.setText("aux out 3");
        this.m_out3Panel.add(this.m_mixMaster3Label);
        this.m_mixMaster3Label.setBounds(20, 14, 80, 16);
        this.m_barALabel_24.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_24.setForeground(new Color(204, 204, 204));
        this.m_barALabel_24.setHorizontalAlignment(4);
        this.m_barALabel_24.setText("0");
        this.m_out3Panel.add(this.m_barALabel_24);
        this.m_barALabel_24.setBounds(5, 68, 20, 15);
        this.m_barALabel_25.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_25.setForeground(new Color(204, 204, 204));
        this.m_barALabel_25.setHorizontalAlignment(4);
        this.m_barALabel_25.setText("-6");
        this.m_out3Panel.add(this.m_barALabel_25);
        this.m_barALabel_25.setBounds(5, 95, 20, 15);
        this.m_barALabel_26.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_26.setForeground(new Color(204, 204, 204));
        this.m_barALabel_26.setHorizontalAlignment(4);
        this.m_barALabel_26.setText("-12");
        this.m_out3Panel.add(this.m_barALabel_26);
        this.m_barALabel_26.setBounds(5, 122, 20, 15);
        this.m_barALabel_27.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_27.setForeground(new Color(204, 204, 204));
        this.m_barALabel_27.setHorizontalAlignment(4);
        this.m_barALabel_27.setText("-24");
        this.m_out3Panel.add(this.m_barALabel_27);
        this.m_barALabel_27.setBounds(5, 149, 20, 15);
        this.m_barALabel_28.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_28.setForeground(new Color(204, 204, 204));
        this.m_barALabel_28.setHorizontalAlignment(4);
        this.m_barALabel_28.setText("-36");
        this.m_out3Panel.add(this.m_barALabel_28);
        this.m_barALabel_28.setBounds(5, 176, 20, 15);
        this.m_barALabel_29.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_29.setForeground(new Color(204, 204, 204));
        this.m_barALabel_29.setHorizontalAlignment(4);
        this.m_barALabel_29.setText("-60");
        this.m_out3Panel.add(this.m_barALabel_29);
        this.m_barALabel_29.setBounds(5, 203, 20, 15);
        this.jLabel17.setFont(new Font("Lucida Grande", 1, 12));
        this.jLabel17.setForeground(new Color(204, 204, 204));
        this.jLabel17.setHorizontalAlignment(0);
        this.jLabel17.setText("gain");
        this.jLabel17.setHorizontalTextPosition(0);
        this.m_out3Panel.add(this.jLabel17);
        this.jLabel17.setBounds(60, 34, 36, 21);
        this.m_mute3BT.setBackground(new Color(100, 100, 100));
        this.m_mute3BT.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/mute_off.png")));
        this.m_mute3BT.setToolTipText("Click to use or not use music reference.");
        this.m_mute3BT.setAlignmentY(0.0f);
        this.m_mute3BT.setBorder(new SoftBevelBorder(0));
        this.m_mute3BT.setBorderPainted(false);
        this.m_mute3BT.setContentAreaFilled(false);
        this.m_mute3BT.setFocusable(false);
        this.m_mute3BT.setHorizontalTextPosition(0);
        this.m_mute3BT.setIconTextGap(0);
        this.m_mute3BT.setInheritsPopupMenu(true);
        this.m_mute3BT.setMargin(new Insets(0, 0, 0, 0));
        this.m_mute3BT.setMaximumSize(new Dimension(36, 36));
        this.m_mute3BT.setMinimumSize(new Dimension(36, 36));
        this.m_mute3BT.setPreferredSize(new Dimension(37, 37));
        this.m_mute3BT.setSelectedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led_yellow_on.png")));
        this.m_mute3BT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_mute3BTActionPerformed(evt);
            }
        });
        this.m_out3Panel.add(this.m_mute3BT);
        this.m_mute3BT.setBounds(7, 230, 50, 50);
        this.m_phase3BT.setBackground(new Color(100, 100, 100));
        this.m_phase3BT.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/phase_off.png")));
        this.m_phase3BT.setToolTipText("Click to enable/disable  channel NOM.");
        this.m_phase3BT.setAlignmentY(0.0f);
        this.m_phase3BT.setBorder(new SoftBevelBorder(0));
        this.m_phase3BT.setBorderPainted(false);
        this.m_phase3BT.setContentAreaFilled(false);
        this.m_phase3BT.setFocusable(false);
        this.m_phase3BT.setHorizontalTextPosition(0);
        this.m_phase3BT.setIconTextGap(0);
        this.m_phase3BT.setInheritsPopupMenu(true);
        this.m_phase3BT.setMargin(new Insets(0, 0, 0, 0));
        this.m_phase3BT.setMaximumSize(new Dimension(36, 36));
        this.m_phase3BT.setMinimumSize(new Dimension(36, 36));
        this.m_phase3BT.setPreferredSize(new Dimension(37, 37));
        this.m_phase3BT.setSelectedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led_yellow_on.png")));
        this.m_phase3BT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_phase3BTActionPerformed(evt);
            }
        });
        this.m_out3Panel.add(this.m_phase3BT);
        this.m_phase3BT.setBounds(61, 230, 50, 50);
        this.m_outputSelect_3.setFont(new Font("Lucida Grande", 0, 12));
        this.m_outputSelect_3.setModel(new DefaultComboBoxModel<String>(new String[]{"analog out 16", "Item 3", "Item 4"}));
        this.m_outputSelect_3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.MixOutputSelectActionPerformed(evt);
            }
        });
        this.m_out3Panel.add(this.m_outputSelect_3);
        this.m_outputSelect_3.setBounds(5, 12, 108, 22);
        this.add(this.m_out3Panel);
        this.m_out3Panel.setBounds(276, 58, 118, 288);
        this.m_out4Panel.setImagePath("/DuganCP/Images/greyBG.jpg");
        this.m_out4Panel.setMinimumSize(new Dimension(110, 280));
        this.m_out4Panel.setPreferredSize(new Dimension(110, 280));
        this.m_out4Panel.setLayout(null);
        this.m_volume4TF.setBackground(new Color(190, 190, 190));
        this.m_volume4TF.setFont(new Font("Tahoma", 1, 10));
        this.m_volume4TF.setHorizontalAlignment(0);
        this.m_volume4TF.setText("-100.0");
        this.m_volume4TF.setBorder(new SoftBevelBorder(1));
        this.m_volume4TF.setName("3");
        this.m_volume4TF.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MixMatrix.this.MousePressedHandler(evt);
            }
        });
        this.m_volume4TF.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                MixMatrix.this.MouseDraggedHandler(evt);
            }
        });
        this.m_volume4TF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MixMatrix.this.VolumeTFFocusLost(evt);
            }
        });
        this.m_volume4TF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MixMatrix.this.VolumeTFKeyReleased(evt);
            }
        });
        this.m_out4Panel.add(this.m_volume4TF);
        this.m_volume4TF.setBounds(59, 185, 45, 25);
        this.m_volume4Slider.setBackground(new Color(38, 38, 38));
        this.m_volume4Slider.setForeground(new Color(160, 160, 160));
        this.m_volume4Slider.setMaximum(90);
        this.m_volume4Slider.setOrientation(1);
        this.m_volume4Slider.setToolTipText("Control Click to reset to 0dB.");
        this.m_volume4Slider.setValue(60);
        this.m_volume4Slider.setPreferredSize(new Dimension(22, 118));
        this.m_volume4Slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MixMatrix.this.SliderMouseReleased(evt);
            }
        });
        this.m_volume4Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MixMatrix.this.SliderStateChanged(evt);
            }
        });
        this.m_volume4Slider.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MixMatrix.this.SliderFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MixMatrix.this.SliderFocusLost(evt);
            }
        });
        this.m_out4Panel.add(this.m_volume4Slider);
        this.m_volume4Slider.setBounds(65, 52, 30, 130);
        this.m_peak4Bar.setBackground(new Color(0, 0, 0));
        this.m_peak4Bar.setForeground(new Color(0, 255, 204));
        this.m_peak4Bar.setMaximum(120);
        this.m_peak4Bar.setOrientation(1);
        this.m_peak4Bar.setBorderPainted(false);
        this.m_peak4Bar.setFocusable(false);
        this.m_out4Panel.add(this.m_peak4Bar);
        this.m_peak4Bar.setBounds(32, 72, 14, 140);
        this.m_clip4LED.setBackground(new Color(150, 150, 150));
        this.m_clip4LED.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/off_led.jpg")));
        this.m_clip4LED.setFocusable(false);
        this.m_clip4LED.setIconTextGap(0);
        this.m_out4Panel.add(this.m_clip4LED);
        this.m_clip4LED.setBounds(25, 53, 24, 12);
        this.jLabel7.setFont(new Font("Lucida Grande", 1, 12));
        this.jLabel7.setForeground(new Color(204, 204, 204));
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText("clip");
        this.jLabel7.setHorizontalTextPosition(0);
        this.m_out4Panel.add(this.jLabel7);
        this.jLabel7.setBounds(19, 34, 36, 21);
        this.m_mixMaster4Label.setForeground(new Color(204, 204, 204));
        this.m_mixMaster4Label.setHorizontalAlignment(0);
        this.m_mixMaster4Label.setText("aux out 4");
        this.m_out4Panel.add(this.m_mixMaster4Label);
        this.m_mixMaster4Label.setBounds(20, 14, 80, 16);
        this.m_barALabel_18.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_18.setForeground(new Color(204, 204, 204));
        this.m_barALabel_18.setHorizontalAlignment(4);
        this.m_barALabel_18.setText("0");
        this.m_out4Panel.add(this.m_barALabel_18);
        this.m_barALabel_18.setBounds(5, 68, 20, 15);
        this.m_barALabel_19.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_19.setForeground(new Color(204, 204, 204));
        this.m_barALabel_19.setHorizontalAlignment(4);
        this.m_barALabel_19.setText("-6");
        this.m_out4Panel.add(this.m_barALabel_19);
        this.m_barALabel_19.setBounds(5, 95, 20, 15);
        this.m_barALabel_20.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_20.setForeground(new Color(204, 204, 204));
        this.m_barALabel_20.setHorizontalAlignment(4);
        this.m_barALabel_20.setText("-12");
        this.m_out4Panel.add(this.m_barALabel_20);
        this.m_barALabel_20.setBounds(5, 122, 20, 15);
        this.m_barALabel_21.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_21.setForeground(new Color(204, 204, 204));
        this.m_barALabel_21.setHorizontalAlignment(4);
        this.m_barALabel_21.setText("-24");
        this.m_out4Panel.add(this.m_barALabel_21);
        this.m_barALabel_21.setBounds(5, 149, 20, 15);
        this.m_barALabel_22.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_22.setForeground(new Color(204, 204, 204));
        this.m_barALabel_22.setHorizontalAlignment(4);
        this.m_barALabel_22.setText("-36");
        this.m_out4Panel.add(this.m_barALabel_22);
        this.m_barALabel_22.setBounds(5, 176, 20, 15);
        this.m_barALabel_23.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_23.setForeground(new Color(204, 204, 204));
        this.m_barALabel_23.setHorizontalAlignment(4);
        this.m_barALabel_23.setText("-60");
        this.m_out4Panel.add(this.m_barALabel_23);
        this.m_barALabel_23.setBounds(5, 203, 20, 15);
        this.jLabel16.setFont(new Font("Lucida Grande", 1, 12));
        this.jLabel16.setForeground(new Color(204, 204, 204));
        this.jLabel16.setHorizontalAlignment(0);
        this.jLabel16.setText("gain");
        this.jLabel16.setHorizontalTextPosition(0);
        this.m_out4Panel.add(this.jLabel16);
        this.jLabel16.setBounds(60, 34, 36, 21);
        this.m_mute4BT.setBackground(new Color(100, 100, 100));
        this.m_mute4BT.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/mute_off.png")));
        this.m_mute4BT.setToolTipText("Click to use or not use music reference.");
        this.m_mute4BT.setAlignmentY(0.0f);
        this.m_mute4BT.setBorder(new SoftBevelBorder(0));
        this.m_mute4BT.setBorderPainted(false);
        this.m_mute4BT.setContentAreaFilled(false);
        this.m_mute4BT.setFocusable(false);
        this.m_mute4BT.setHorizontalTextPosition(0);
        this.m_mute4BT.setIconTextGap(0);
        this.m_mute4BT.setInheritsPopupMenu(true);
        this.m_mute4BT.setMargin(new Insets(0, 0, 0, 0));
        this.m_mute4BT.setMaximumSize(new Dimension(36, 36));
        this.m_mute4BT.setMinimumSize(new Dimension(36, 36));
        this.m_mute4BT.setPreferredSize(new Dimension(37, 37));
        this.m_mute4BT.setSelectedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led_yellow_on.png")));
        this.m_mute4BT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_mute4BTActionPerformed(evt);
            }
        });
        this.m_out4Panel.add(this.m_mute4BT);
        this.m_mute4BT.setBounds(7, 230, 50, 50);
        this.m_phase4BT.setBackground(new Color(100, 100, 100));
        this.m_phase4BT.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/phase_off.png")));
        this.m_phase4BT.setToolTipText("Click to enable/disable  channel NOM.");
        this.m_phase4BT.setAlignmentY(0.0f);
        this.m_phase4BT.setBorder(new SoftBevelBorder(0));
        this.m_phase4BT.setBorderPainted(false);
        this.m_phase4BT.setContentAreaFilled(false);
        this.m_phase4BT.setFocusable(false);
        this.m_phase4BT.setHorizontalTextPosition(0);
        this.m_phase4BT.setIconTextGap(0);
        this.m_phase4BT.setInheritsPopupMenu(true);
        this.m_phase4BT.setMargin(new Insets(0, 0, 0, 0));
        this.m_phase4BT.setMaximumSize(new Dimension(36, 36));
        this.m_phase4BT.setMinimumSize(new Dimension(36, 36));
        this.m_phase4BT.setPreferredSize(new Dimension(37, 37));
        this.m_phase4BT.setSelectedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led_yellow_on.png")));
        this.m_phase4BT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_phase4BTActionPerformed(evt);
            }
        });
        this.m_out4Panel.add(this.m_phase4BT);
        this.m_phase4BT.setBounds(61, 230, 50, 50);
        this.m_outputSelect_4.setFont(new Font("Lucida Grande", 0, 12));
        this.m_outputSelect_4.setModel(new DefaultComboBoxModel<String>(new String[]{"analog out 16", "Item 3", "Item 4"}));
        this.m_outputSelect_4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.MixOutputSelectActionPerformed(evt);
            }
        });
        this.m_out4Panel.add(this.m_outputSelect_4);
        this.m_outputSelect_4.setBounds(5, 12, 108, 22);
        this.add(this.m_out4Panel);
        this.m_out4Panel.setBounds(394, 58, 118, 288);
        this.m_out5Panel.setImagePath("/DuganCP/Images/greyBG.jpg");
        this.m_out5Panel.setMinimumSize(new Dimension(110, 280));
        this.m_out5Panel.setPreferredSize(new Dimension(110, 280));
        this.m_out5Panel.setLayout(null);
        this.m_volume5TF.setBackground(new Color(190, 190, 190));
        this.m_volume5TF.setFont(new Font("Tahoma", 1, 10));
        this.m_volume5TF.setHorizontalAlignment(0);
        this.m_volume5TF.setText("-100.0");
        this.m_volume5TF.setBorder(new SoftBevelBorder(1));
        this.m_volume5TF.setName("4");
        this.m_volume5TF.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MixMatrix.this.MousePressedHandler(evt);
            }
        });
        this.m_volume5TF.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                MixMatrix.this.MouseDraggedHandler(evt);
            }
        });
        this.m_volume5TF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MixMatrix.this.VolumeTFFocusLost(evt);
            }
        });
        this.m_volume5TF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MixMatrix.this.VolumeTFKeyReleased(evt);
            }
        });
        this.m_out5Panel.add(this.m_volume5TF);
        this.m_volume5TF.setBounds(59, 185, 45, 25);
        this.m_volume5Slider.setBackground(new Color(38, 38, 38));
        this.m_volume5Slider.setForeground(new Color(160, 160, 160));
        this.m_volume5Slider.setMaximum(90);
        this.m_volume5Slider.setOrientation(1);
        this.m_volume5Slider.setToolTipText("Control Click to reset to 0dB.");
        this.m_volume5Slider.setValue(60);
        this.m_volume5Slider.setPreferredSize(new Dimension(22, 118));
        this.m_volume5Slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MixMatrix.this.SliderMouseReleased(evt);
            }
        });
        this.m_volume5Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MixMatrix.this.SliderStateChanged(evt);
            }
        });
        this.m_volume5Slider.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MixMatrix.this.SliderFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MixMatrix.this.SliderFocusLost(evt);
            }
        });
        this.m_out5Panel.add(this.m_volume5Slider);
        this.m_volume5Slider.setBounds(65, 52, 30, 130);
        this.m_peak5Bar.setBackground(new Color(0, 0, 0));
        this.m_peak5Bar.setForeground(new Color(0, 255, 204));
        this.m_peak5Bar.setMaximum(120);
        this.m_peak5Bar.setOrientation(1);
        this.m_peak5Bar.setBorderPainted(false);
        this.m_peak5Bar.setFocusable(false);
        this.m_out5Panel.add(this.m_peak5Bar);
        this.m_peak5Bar.setBounds(32, 72, 14, 140);
        this.m_clip5LED.setBackground(new Color(150, 150, 150));
        this.m_clip5LED.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/off_led.jpg")));
        this.m_clip5LED.setFocusable(false);
        this.m_clip5LED.setIconTextGap(0);
        this.m_out5Panel.add(this.m_clip5LED);
        this.m_clip5LED.setBounds(25, 53, 24, 12);
        this.jLabel5.setFont(new Font("Lucida Grande", 1, 12));
        this.jLabel5.setForeground(new Color(204, 204, 204));
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("clip");
        this.jLabel5.setHorizontalTextPosition(0);
        this.m_out5Panel.add(this.jLabel5);
        this.jLabel5.setBounds(19, 34, 36, 21);
        this.m_mixMaster5Label.setForeground(new Color(204, 204, 204));
        this.m_mixMaster5Label.setHorizontalAlignment(0);
        this.m_mixMaster5Label.setText("aux out 5");
        this.m_out5Panel.add(this.m_mixMaster5Label);
        this.m_mixMaster5Label.setBounds(20, 14, 80, 16);
        this.m_barALabel_12.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_12.setForeground(new Color(204, 204, 204));
        this.m_barALabel_12.setHorizontalAlignment(4);
        this.m_barALabel_12.setText("0");
        this.m_out5Panel.add(this.m_barALabel_12);
        this.m_barALabel_12.setBounds(5, 68, 20, 15);
        this.m_barALabel_13.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_13.setForeground(new Color(204, 204, 204));
        this.m_barALabel_13.setHorizontalAlignment(4);
        this.m_barALabel_13.setText("-6");
        this.m_out5Panel.add(this.m_barALabel_13);
        this.m_barALabel_13.setBounds(5, 95, 20, 15);
        this.m_barALabel_14.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_14.setForeground(new Color(204, 204, 204));
        this.m_barALabel_14.setHorizontalAlignment(4);
        this.m_barALabel_14.setText("-12");
        this.m_out5Panel.add(this.m_barALabel_14);
        this.m_barALabel_14.setBounds(5, 122, 20, 15);
        this.m_barALabel_15.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_15.setForeground(new Color(204, 204, 204));
        this.m_barALabel_15.setHorizontalAlignment(4);
        this.m_barALabel_15.setText("-24");
        this.m_out5Panel.add(this.m_barALabel_15);
        this.m_barALabel_15.setBounds(5, 149, 20, 15);
        this.m_barALabel_16.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_16.setForeground(new Color(204, 204, 204));
        this.m_barALabel_16.setHorizontalAlignment(4);
        this.m_barALabel_16.setText("-36");
        this.m_out5Panel.add(this.m_barALabel_16);
        this.m_barALabel_16.setBounds(5, 176, 20, 15);
        this.m_barALabel_17.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_17.setForeground(new Color(204, 204, 204));
        this.m_barALabel_17.setHorizontalAlignment(4);
        this.m_barALabel_17.setText("-60");
        this.m_out5Panel.add(this.m_barALabel_17);
        this.m_barALabel_17.setBounds(5, 203, 20, 15);
        this.jLabel15.setFont(new Font("Lucida Grande", 1, 12));
        this.jLabel15.setForeground(new Color(204, 204, 204));
        this.jLabel15.setHorizontalAlignment(0);
        this.jLabel15.setText("gain");
        this.jLabel15.setHorizontalTextPosition(0);
        this.m_out5Panel.add(this.jLabel15);
        this.jLabel15.setBounds(60, 34, 36, 21);
        this.m_mute5BT.setBackground(new Color(100, 100, 100));
        this.m_mute5BT.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/mute_off.png")));
        this.m_mute5BT.setToolTipText("Click to use or not use music reference.");
        this.m_mute5BT.setAlignmentY(0.0f);
        this.m_mute5BT.setBorder(new SoftBevelBorder(0));
        this.m_mute5BT.setBorderPainted(false);
        this.m_mute5BT.setContentAreaFilled(false);
        this.m_mute5BT.setFocusable(false);
        this.m_mute5BT.setHorizontalTextPosition(0);
        this.m_mute5BT.setIconTextGap(0);
        this.m_mute5BT.setInheritsPopupMenu(true);
        this.m_mute5BT.setMargin(new Insets(0, 0, 0, 0));
        this.m_mute5BT.setMaximumSize(new Dimension(36, 36));
        this.m_mute5BT.setMinimumSize(new Dimension(36, 36));
        this.m_mute5BT.setPreferredSize(new Dimension(37, 37));
        this.m_mute5BT.setSelectedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led_yellow_on.png")));
        this.m_mute5BT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_mute5BTActionPerformed(evt);
            }
        });
        this.m_out5Panel.add(this.m_mute5BT);
        this.m_mute5BT.setBounds(7, 230, 50, 50);
        this.m_phase5BT.setBackground(new Color(100, 100, 100));
        this.m_phase5BT.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/phase_off.png")));
        this.m_phase5BT.setToolTipText("Click to enable/disable  channel NOM.");
        this.m_phase5BT.setAlignmentY(0.0f);
        this.m_phase5BT.setBorder(new SoftBevelBorder(0));
        this.m_phase5BT.setBorderPainted(false);
        this.m_phase5BT.setContentAreaFilled(false);
        this.m_phase5BT.setFocusable(false);
        this.m_phase5BT.setHorizontalTextPosition(0);
        this.m_phase5BT.setIconTextGap(0);
        this.m_phase5BT.setInheritsPopupMenu(true);
        this.m_phase5BT.setMargin(new Insets(0, 0, 0, 0));
        this.m_phase5BT.setMaximumSize(new Dimension(36, 36));
        this.m_phase5BT.setMinimumSize(new Dimension(36, 36));
        this.m_phase5BT.setPreferredSize(new Dimension(37, 37));
        this.m_phase5BT.setSelectedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led_yellow_on.png")));
        this.m_phase5BT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_phase5BTActionPerformed(evt);
            }
        });
        this.m_out5Panel.add(this.m_phase5BT);
        this.m_phase5BT.setBounds(61, 230, 50, 50);
        this.m_outputSelect_5.setFont(new Font("Lucida Grande", 0, 12));
        this.m_outputSelect_5.setModel(new DefaultComboBoxModel<String>(new String[]{"analog out 16", "Item 3", "Item 4"}));
        this.m_outputSelect_5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.MixOutputSelectActionPerformed(evt);
            }
        });
        this.m_out5Panel.add(this.m_outputSelect_5);
        this.m_outputSelect_5.setBounds(5, 12, 108, 22);
        this.add(this.m_out5Panel);
        this.m_out5Panel.setBounds(512, 58, 118, 288);
        this.m_out6Panel.setImagePath("/DuganCP/Images/greyBG.jpg");
        this.m_out6Panel.setMinimumSize(new Dimension(110, 280));
        this.m_out6Panel.setPreferredSize(new Dimension(110, 280));
        this.m_out6Panel.setLayout(null);
        this.m_volume6TF.setBackground(new Color(190, 190, 190));
        this.m_volume6TF.setFont(new Font("Tahoma", 1, 10));
        this.m_volume6TF.setHorizontalAlignment(0);
        this.m_volume6TF.setText("-100.0");
        this.m_volume6TF.setBorder(new SoftBevelBorder(1));
        this.m_volume6TF.setName("5");
        this.m_volume6TF.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MixMatrix.this.MousePressedHandler(evt);
            }
        });
        this.m_volume6TF.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                MixMatrix.this.MouseDraggedHandler(evt);
            }
        });
        this.m_volume6TF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MixMatrix.this.VolumeTFFocusLost(evt);
            }
        });
        this.m_volume6TF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MixMatrix.this.VolumeTFKeyReleased(evt);
            }
        });
        this.m_out6Panel.add(this.m_volume6TF);
        this.m_volume6TF.setBounds(61, 185, 45, 25);
        this.m_volume6Slider.setBackground(new Color(38, 38, 38));
        this.m_volume6Slider.setForeground(new Color(160, 160, 160));
        this.m_volume6Slider.setMaximum(90);
        this.m_volume6Slider.setOrientation(1);
        this.m_volume6Slider.setToolTipText("Control Click to reset to 0dB.");
        this.m_volume6Slider.setValue(60);
        this.m_volume6Slider.setPreferredSize(new Dimension(22, 118));
        this.m_volume6Slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MixMatrix.this.SliderMouseReleased(evt);
            }
        });
        this.m_volume6Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MixMatrix.this.SliderStateChanged(evt);
            }
        });
        this.m_volume6Slider.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MixMatrix.this.SliderFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MixMatrix.this.SliderFocusLost(evt);
            }
        });
        this.m_out6Panel.add(this.m_volume6Slider);
        this.m_volume6Slider.setBounds(65, 52, 30, 130);
        this.m_peak6Bar.setBackground(new Color(0, 0, 0));
        this.m_peak6Bar.setForeground(new Color(0, 255, 204));
        this.m_peak6Bar.setMaximum(120);
        this.m_peak6Bar.setOrientation(1);
        this.m_peak6Bar.setBorderPainted(false);
        this.m_peak6Bar.setFocusable(false);
        this.m_out6Panel.add(this.m_peak6Bar);
        this.m_peak6Bar.setBounds(32, 72, 14, 140);
        this.m_clip6LED.setBackground(new Color(150, 150, 150));
        this.m_clip6LED.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/off_led.jpg")));
        this.m_clip6LED.setFocusable(false);
        this.m_clip6LED.setIconTextGap(0);
        this.m_out6Panel.add(this.m_clip6LED);
        this.m_clip6LED.setBounds(25, 53, 24, 12);
        this.jLabel4.setFont(new Font("Lucida Grande", 1, 12));
        this.jLabel4.setForeground(new Color(204, 204, 204));
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("gain");
        this.jLabel4.setHorizontalTextPosition(0);
        this.m_out6Panel.add(this.jLabel4);
        this.jLabel4.setBounds(60, 34, 36, 21);
        this.m_mixMaster6Label.setForeground(new Color(204, 204, 204));
        this.m_mixMaster6Label.setHorizontalAlignment(0);
        this.m_mixMaster6Label.setText("aux out 6");
        this.m_out6Panel.add(this.m_mixMaster6Label);
        this.m_mixMaster6Label.setBounds(16, 14, 80, 16);
        this.m_barALabel_6.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_6.setForeground(new Color(204, 204, 204));
        this.m_barALabel_6.setHorizontalAlignment(4);
        this.m_barALabel_6.setText("0");
        this.m_out6Panel.add(this.m_barALabel_6);
        this.m_barALabel_6.setBounds(5, 68, 20, 15);
        this.m_barALabel_7.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_7.setForeground(new Color(204, 204, 204));
        this.m_barALabel_7.setHorizontalAlignment(4);
        this.m_barALabel_7.setText("-6");
        this.m_out6Panel.add(this.m_barALabel_7);
        this.m_barALabel_7.setBounds(5, 95, 20, 15);
        this.m_barALabel_8.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_8.setForeground(new Color(204, 204, 204));
        this.m_barALabel_8.setHorizontalAlignment(4);
        this.m_barALabel_8.setText("-12");
        this.m_out6Panel.add(this.m_barALabel_8);
        this.m_barALabel_8.setBounds(5, 122, 20, 15);
        this.m_barALabel_9.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_9.setForeground(new Color(204, 204, 204));
        this.m_barALabel_9.setHorizontalAlignment(4);
        this.m_barALabel_9.setText("-24");
        this.m_out6Panel.add(this.m_barALabel_9);
        this.m_barALabel_9.setBounds(5, 149, 20, 15);
        this.m_barALabel_10.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_10.setForeground(new Color(204, 204, 204));
        this.m_barALabel_10.setHorizontalAlignment(4);
        this.m_barALabel_10.setText("-36");
        this.m_out6Panel.add(this.m_barALabel_10);
        this.m_barALabel_10.setBounds(5, 176, 20, 15);
        this.m_barALabel_11.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_11.setForeground(new Color(204, 204, 204));
        this.m_barALabel_11.setHorizontalAlignment(4);
        this.m_barALabel_11.setText("-60");
        this.m_out6Panel.add(this.m_barALabel_11);
        this.m_barALabel_11.setBounds(5, 203, 20, 15);
        this.jLabel14.setFont(new Font("Lucida Grande", 1, 12));
        this.jLabel14.setForeground(new Color(204, 204, 204));
        this.jLabel14.setHorizontalAlignment(0);
        this.jLabel14.setText("clip");
        this.jLabel14.setHorizontalTextPosition(0);
        this.m_out6Panel.add(this.jLabel14);
        this.jLabel14.setBounds(19, 34, 36, 21);
        this.m_mute6BT.setBackground(new Color(100, 100, 100));
        this.m_mute6BT.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/mute_off.png")));
        this.m_mute6BT.setToolTipText("Click to use or not use music reference.");
        this.m_mute6BT.setAlignmentY(0.0f);
        this.m_mute6BT.setBorder(new SoftBevelBorder(0));
        this.m_mute6BT.setBorderPainted(false);
        this.m_mute6BT.setContentAreaFilled(false);
        this.m_mute6BT.setFocusable(false);
        this.m_mute6BT.setHorizontalTextPosition(0);
        this.m_mute6BT.setIconTextGap(0);
        this.m_mute6BT.setInheritsPopupMenu(true);
        this.m_mute6BT.setMargin(new Insets(0, 0, 0, 0));
        this.m_mute6BT.setMaximumSize(new Dimension(36, 36));
        this.m_mute6BT.setMinimumSize(new Dimension(36, 36));
        this.m_mute6BT.setPreferredSize(new Dimension(37, 37));
        this.m_mute6BT.setSelectedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led_yellow_on.png")));
        this.m_mute6BT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_mute6BTActionPerformed(evt);
            }
        });
        this.m_out6Panel.add(this.m_mute6BT);
        this.m_mute6BT.setBounds(7, 230, 50, 50);
        this.m_phase6BT.setBackground(new Color(100, 100, 100));
        this.m_phase6BT.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/phase_off.png")));
        this.m_phase6BT.setToolTipText("Click to enable/disable  channel NOM.");
        this.m_phase6BT.setAlignmentY(0.0f);
        this.m_phase6BT.setBorder(new SoftBevelBorder(0));
        this.m_phase6BT.setBorderPainted(false);
        this.m_phase6BT.setContentAreaFilled(false);
        this.m_phase6BT.setFocusable(false);
        this.m_phase6BT.setHorizontalTextPosition(0);
        this.m_phase6BT.setIconTextGap(0);
        this.m_phase6BT.setInheritsPopupMenu(true);
        this.m_phase6BT.setMargin(new Insets(0, 0, 0, 0));
        this.m_phase6BT.setMaximumSize(new Dimension(36, 36));
        this.m_phase6BT.setMinimumSize(new Dimension(36, 36));
        this.m_phase6BT.setPreferredSize(new Dimension(37, 37));
        this.m_phase6BT.setSelectedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led_yellow_on.png")));
        this.m_phase6BT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_phase6BTActionPerformed(evt);
            }
        });
        this.m_out6Panel.add(this.m_phase6BT);
        this.m_phase6BT.setBounds(61, 230, 50, 50);
        this.m_outputSelect_6.setFont(new Font("Lucida Grande", 0, 12));
        this.m_outputSelect_6.setModel(new DefaultComboBoxModel<String>(new String[]{"analog out 16", "Item 3", "Item 4"}));
        this.m_outputSelect_6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.MixOutputSelectActionPerformed(evt);
            }
        });
        this.m_out6Panel.add(this.m_outputSelect_6);
        this.m_outputSelect_6.setBounds(5, 12, 108, 22);
        this.add(this.m_out6Panel);
        this.m_out6Panel.setBounds(630, 58, 118, 288);
        this.m_matrixPane.setVerticalScrollBarPolicy(21);
        this.m_matrixPane.setWheelScrollingEnabled(false);
        this.m_matrix.setAutoCreateRowSorter(true);
        this.m_matrix.setBackground(new Color(80, 80, 80));
        this.m_matrix.setForeground(new Color(204, 204, 204));
        this.m_matrix.setModel(new DefaultTableModel(new Object[][]{new Object[144], new Object[144], new Object[144], new Object[144], new Object[144], new Object[144], new Object[144], new Object[144]}, new String[]{"automix 1", "automix 2", "automix 3", "automix 4", "automix 5", "automix 6", "automix 7", "automix 8", "automix 9", "automix 10", "automix 11", "automix 12", "automix 13", "automix 14", "automix 15", "automix 16", "automix 17", "automix 18", "automix 19", "automix 20", "automix 21", "automix 22", "automix 23", "automix 24", "automix 25", "automix 26", "automix 27", "automix 28", "automix 29", "automix 30", "auotmix 31", "automix 32", "aes in 1", "aes in 2", "aes in 3", "aes in 4", "aes in 5", "aes in 6", "aes in 7", "aes in 8", "MST in 1", "MST in 2", "MST in 3", "aes in 12", "DARS", "aes in 14", "aes in 15", "aes in 16", "adat1 in 1", "adat1 in 2", "adat1 in 3", "adat1 in 4", "adat1 in 5", "adat1 in 6", "adat1 in 7", "adat1 in 8", "adat2 in 1", "adat2 in 2", "adat2 in 3", "adat2 in 4", "adat2 in 5", "adat2 in 6", "adat2 in 7", "adat2 in 8", "Title 65", "Title 66", "Title 67", "Title 68", "Title 69", "Title 70", "Title 71", "Title 72", "Title 73", "Title 74", "Title 75", "Title 76", "Title 77", "Title 78", "Title 79", "Title 80", "Title 81", "Title 82", "Title 83", "Title 84", "Title 85", "Title 86", "Title 87", "Title 88", "Title 89", "Title 90", "Title 91", "Title 92", "Title 93", "Title 94", "Title 95", "Title 96", "Title 97", "Title 98", "Title 99", "Title 100", "Title 101", "Title 102", "Title 103", "Title 104", "Title 105", "Title 106", "Title 107", "Title 108", "Title 109", "Title 110", "Title 111", "Title 112", "Title 113", "Title 114", "Title 115", "Title 116", "Title 117", "Title 118", "Title 119", "Title 120", "Title 121", "Title 122", "Title 123", "Title 124", "Title 125", "Title 126", "Title 127", "Title 128", "Title 129", "Title 130", "Title 131", "Title 132", "Title 133", "Title 134", "Title 135", "Title 136", "Title 137", "Title 138", "Title 139", "Title 140", "Title 141", "Title 142", "Title 143", "Title 144"}));
        this.m_matrix.setAutoResizeMode(0);
        this.m_matrix.setColumnSelectionAllowed(true);
        this.m_matrix.setGridColor(new Color(150, 150, 150));
        this.m_matrix.setRowHeight(32);
        this.m_matrixPane.setViewportView(this.m_matrix);
        this.add(this.m_matrixPane);
        this.m_matrixPane.setBounds(1, 400, 1022, 290);
        this.m_close.setBackground(new Color(80, 80, 80));
        this.m_close.setFont(new Font("Tahoma", 1, 12));
        this.m_close.setForeground(new Color(180, 180, 180));
        this.m_close.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led1_off.png")));
        this.m_close.setText("close");
        this.m_close.setBorder(null);
        this.m_close.setBorderPainted(false);
        this.m_close.setContentAreaFilled(false);
        this.m_close.setHorizontalTextPosition(0);
        this.m_close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_closeActionPerformed(evt);
            }
        });
        this.add(this.m_close);
        this.m_close.setBounds(938, 10, 75, 45);
        this.m_title.setFont(new Font("Tahoma", 0, 18));
        this.m_title.setForeground(new Color(180, 180, 180));
        this.m_title.setHorizontalAlignment(0);
        this.m_title.setText("mix bus matrix (dB) ");
        this.add(this.m_title);
        this.m_title.setBounds(367, 360, 291, 24);
        this.m_title1.setFont(new Font("Tahoma", 0, 18));
        this.m_title1.setForeground(new Color(180, 180, 180));
        this.m_title1.setHorizontalAlignment(0);
        this.m_title1.setText("mix bus masters");
        this.add(this.m_title1);
        this.m_title1.setBounds(368, 15, 291, 24);
        this.m_out7Panel.setImagePath("/DuganCP/Images/greyBG.jpg");
        this.m_out7Panel.setMinimumSize(new Dimension(110, 280));
        this.m_out7Panel.setPreferredSize(new Dimension(110, 280));
        this.m_out7Panel.setLayout(null);
        this.m_volume7TF.setBackground(new Color(190, 190, 190));
        this.m_volume7TF.setFont(new Font("Tahoma", 1, 10));
        this.m_volume7TF.setHorizontalAlignment(0);
        this.m_volume7TF.setText("-100.0");
        this.m_volume7TF.setBorder(new SoftBevelBorder(1));
        this.m_volume7TF.setName("6");
        this.m_volume7TF.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MixMatrix.this.MousePressedHandler(evt);
            }
        });
        this.m_volume7TF.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                MixMatrix.this.MouseDraggedHandler(evt);
            }
        });
        this.m_volume7TF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MixMatrix.this.VolumeTFFocusLost(evt);
            }
        });
        this.m_volume7TF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MixMatrix.this.VolumeTFKeyReleased(evt);
            }
        });
        this.m_out7Panel.add(this.m_volume7TF);
        this.m_volume7TF.setBounds(61, 185, 45, 25);
        this.m_volume7Slider.setBackground(new Color(38, 38, 38));
        this.m_volume7Slider.setForeground(new Color(160, 160, 160));
        this.m_volume7Slider.setMaximum(90);
        this.m_volume7Slider.setOrientation(1);
        this.m_volume7Slider.setToolTipText("Control Click to reset to 0dB.");
        this.m_volume7Slider.setValue(60);
        this.m_volume7Slider.setPreferredSize(new Dimension(22, 118));
        this.m_volume7Slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MixMatrix.this.SliderMouseReleased(evt);
            }
        });
        this.m_volume7Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MixMatrix.this.SliderStateChanged(evt);
            }
        });
        this.m_volume7Slider.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MixMatrix.this.SliderFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MixMatrix.this.SliderFocusLost(evt);
            }
        });
        this.m_out7Panel.add(this.m_volume7Slider);
        this.m_volume7Slider.setBounds(65, 52, 30, 130);
        this.m_peak7Bar.setBackground(new Color(0, 0, 0));
        this.m_peak7Bar.setForeground(new Color(0, 255, 204));
        this.m_peak7Bar.setMaximum(120);
        this.m_peak7Bar.setOrientation(1);
        this.m_peak7Bar.setBorderPainted(false);
        this.m_peak7Bar.setFocusable(false);
        this.m_out7Panel.add(this.m_peak7Bar);
        this.m_peak7Bar.setBounds(32, 72, 14, 140);
        this.m_clip7LED.setBackground(new Color(150, 150, 150));
        this.m_clip7LED.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/off_led.jpg")));
        this.m_clip7LED.setFocusable(false);
        this.m_clip7LED.setIconTextGap(0);
        this.m_out7Panel.add(this.m_clip7LED);
        this.m_clip7LED.setBounds(25, 53, 24, 12);
        this.jLabel31.setFont(new Font("Lucida Grande", 1, 12));
        this.jLabel31.setForeground(new Color(204, 204, 204));
        this.jLabel31.setHorizontalAlignment(0);
        this.jLabel31.setText("gain");
        this.jLabel31.setHorizontalTextPosition(0);
        this.m_out7Panel.add(this.jLabel31);
        this.jLabel31.setBounds(60, 34, 36, 21);
        this.m_mixMaster7Label.setForeground(new Color(204, 204, 204));
        this.m_mixMaster7Label.setHorizontalAlignment(0);
        this.m_mixMaster7Label.setText("aux out 7");
        this.m_out7Panel.add(this.m_mixMaster7Label);
        this.m_mixMaster7Label.setBounds(16, 14, 80, 16);
        this.m_barALabel_36.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_36.setForeground(new Color(204, 204, 204));
        this.m_barALabel_36.setHorizontalAlignment(4);
        this.m_barALabel_36.setText("0");
        this.m_out7Panel.add(this.m_barALabel_36);
        this.m_barALabel_36.setBounds(5, 68, 20, 15);
        this.m_barALabel_37.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_37.setForeground(new Color(204, 204, 204));
        this.m_barALabel_37.setHorizontalAlignment(4);
        this.m_barALabel_37.setText("-6");
        this.m_out7Panel.add(this.m_barALabel_37);
        this.m_barALabel_37.setBounds(5, 95, 20, 15);
        this.m_barALabel_38.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_38.setForeground(new Color(204, 204, 204));
        this.m_barALabel_38.setHorizontalAlignment(4);
        this.m_barALabel_38.setText("-12");
        this.m_out7Panel.add(this.m_barALabel_38);
        this.m_barALabel_38.setBounds(5, 122, 20, 15);
        this.m_barALabel_39.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_39.setForeground(new Color(204, 204, 204));
        this.m_barALabel_39.setHorizontalAlignment(4);
        this.m_barALabel_39.setText("-24");
        this.m_out7Panel.add(this.m_barALabel_39);
        this.m_barALabel_39.setBounds(5, 149, 20, 15);
        this.m_barALabel_40.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_40.setForeground(new Color(204, 204, 204));
        this.m_barALabel_40.setHorizontalAlignment(4);
        this.m_barALabel_40.setText("-36");
        this.m_out7Panel.add(this.m_barALabel_40);
        this.m_barALabel_40.setBounds(5, 176, 20, 15);
        this.m_barALabel_41.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_41.setForeground(new Color(204, 204, 204));
        this.m_barALabel_41.setHorizontalAlignment(4);
        this.m_barALabel_41.setText("-60");
        this.m_out7Panel.add(this.m_barALabel_41);
        this.m_barALabel_41.setBounds(5, 203, 20, 15);
        this.jLabel33.setFont(new Font("Lucida Grande", 1, 12));
        this.jLabel33.setForeground(new Color(204, 204, 204));
        this.jLabel33.setHorizontalAlignment(0);
        this.jLabel33.setText("clip");
        this.jLabel33.setHorizontalTextPosition(0);
        this.m_out7Panel.add(this.jLabel33);
        this.jLabel33.setBounds(19, 34, 36, 21);
        this.m_mute7BT.setBackground(new Color(100, 100, 100));
        this.m_mute7BT.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/mute_off.png")));
        this.m_mute7BT.setToolTipText("Click to use or not use music reference.");
        this.m_mute7BT.setAlignmentY(0.0f);
        this.m_mute7BT.setBorder(new SoftBevelBorder(0));
        this.m_mute7BT.setBorderPainted(false);
        this.m_mute7BT.setContentAreaFilled(false);
        this.m_mute7BT.setFocusable(false);
        this.m_mute7BT.setHorizontalTextPosition(0);
        this.m_mute7BT.setIconTextGap(0);
        this.m_mute7BT.setInheritsPopupMenu(true);
        this.m_mute7BT.setMargin(new Insets(0, 0, 0, 0));
        this.m_mute7BT.setMaximumSize(new Dimension(36, 36));
        this.m_mute7BT.setMinimumSize(new Dimension(36, 36));
        this.m_mute7BT.setPreferredSize(new Dimension(37, 37));
        this.m_mute7BT.setSelectedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led_yellow_on.png")));
        this.m_mute7BT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_mute7BTActionPerformed(evt);
            }
        });
        this.m_out7Panel.add(this.m_mute7BT);
        this.m_mute7BT.setBounds(7, 230, 50, 50);
        this.m_phase7BT.setBackground(new Color(100, 100, 100));
        this.m_phase7BT.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/phase_off.png")));
        this.m_phase7BT.setToolTipText("Click to enable/disable  channel NOM.");
        this.m_phase7BT.setAlignmentY(0.0f);
        this.m_phase7BT.setBorder(new SoftBevelBorder(0));
        this.m_phase7BT.setBorderPainted(false);
        this.m_phase7BT.setContentAreaFilled(false);
        this.m_phase7BT.setFocusable(false);
        this.m_phase7BT.setHorizontalTextPosition(0);
        this.m_phase7BT.setIconTextGap(0);
        this.m_phase7BT.setInheritsPopupMenu(true);
        this.m_phase7BT.setMargin(new Insets(0, 0, 0, 0));
        this.m_phase7BT.setMaximumSize(new Dimension(36, 36));
        this.m_phase7BT.setMinimumSize(new Dimension(36, 36));
        this.m_phase7BT.setPreferredSize(new Dimension(37, 37));
        this.m_phase7BT.setSelectedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led_yellow_on.png")));
        this.m_phase7BT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_phase7BTActionPerformed(evt);
            }
        });
        this.m_out7Panel.add(this.m_phase7BT);
        this.m_phase7BT.setBounds(61, 230, 50, 50);
        this.m_outputSelect_7.setFont(new Font("Lucida Grande", 0, 12));
        this.m_outputSelect_7.setModel(new DefaultComboBoxModel<String>(new String[]{"analog out 16", "Item 3", "Item 4"}));
        this.m_outputSelect_7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.MixOutputSelectActionPerformed(evt);
            }
        });
        this.m_out7Panel.add(this.m_outputSelect_7);
        this.m_outputSelect_7.setBounds(5, 12, 108, 22);
        this.add(this.m_out7Panel);
        this.m_out7Panel.setBounds(748, 58, 118, 288);
        this.m_out8Panel.setImagePath("/DuganCP/Images/greyBG.jpg");
        this.m_out8Panel.setMinimumSize(new Dimension(110, 280));
        this.m_out8Panel.setPreferredSize(new Dimension(110, 280));
        this.m_out8Panel.setLayout(null);
        this.m_volume8TF.setBackground(new Color(190, 190, 190));
        this.m_volume8TF.setFont(new Font("Tahoma", 1, 10));
        this.m_volume8TF.setHorizontalAlignment(0);
        this.m_volume8TF.setText("-100.0");
        this.m_volume8TF.setBorder(new SoftBevelBorder(1));
        this.m_volume8TF.setName("7");
        this.m_volume8TF.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MixMatrix.this.MousePressedHandler(evt);
            }
        });
        this.m_volume8TF.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                MixMatrix.this.MouseDraggedHandler(evt);
            }
        });
        this.m_volume8TF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MixMatrix.this.VolumeTFFocusLost(evt);
            }
        });
        this.m_volume8TF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MixMatrix.this.VolumeTFKeyReleased(evt);
            }
        });
        this.m_out8Panel.add(this.m_volume8TF);
        this.m_volume8TF.setBounds(61, 185, 45, 25);
        this.m_volume8Slider.setBackground(new Color(38, 38, 38));
        this.m_volume8Slider.setForeground(new Color(160, 160, 160));
        this.m_volume8Slider.setMaximum(90);
        this.m_volume8Slider.setOrientation(1);
        this.m_volume8Slider.setToolTipText("Control Click to reset to 0dB.");
        this.m_volume8Slider.setValue(60);
        this.m_volume8Slider.setPreferredSize(new Dimension(22, 118));
        this.m_volume8Slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MixMatrix.this.SliderMouseReleased(evt);
            }
        });
        this.m_volume8Slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MixMatrix.this.SliderStateChanged(evt);
            }
        });
        this.m_volume8Slider.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MixMatrix.this.SliderFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                MixMatrix.this.SliderFocusLost(evt);
            }
        });
        this.m_out8Panel.add(this.m_volume8Slider);
        this.m_volume8Slider.setBounds(65, 52, 30, 130);
        this.m_peak8Bar.setBackground(new Color(0, 0, 0));
        this.m_peak8Bar.setForeground(new Color(0, 255, 204));
        this.m_peak8Bar.setMaximum(120);
        this.m_peak8Bar.setOrientation(1);
        this.m_peak8Bar.setBorderPainted(false);
        this.m_peak8Bar.setFocusable(false);
        this.m_out8Panel.add(this.m_peak8Bar);
        this.m_peak8Bar.setBounds(32, 72, 14, 140);
        this.m_clip8LED.setBackground(new Color(150, 150, 150));
        this.m_clip8LED.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/off_led.jpg")));
        this.m_clip8LED.setFocusable(false);
        this.m_clip8LED.setIconTextGap(0);
        this.m_out8Panel.add(this.m_clip8LED);
        this.m_clip8LED.setBounds(25, 53, 24, 12);
        this.jLabel36.setFont(new Font("Lucida Grande", 1, 12));
        this.jLabel36.setForeground(new Color(204, 204, 204));
        this.jLabel36.setHorizontalAlignment(0);
        this.jLabel36.setText("gain");
        this.jLabel36.setHorizontalTextPosition(0);
        this.m_out8Panel.add(this.jLabel36);
        this.jLabel36.setBounds(60, 34, 36, 21);
        this.m_mixMaster8Label.setForeground(new Color(204, 204, 204));
        this.m_mixMaster8Label.setHorizontalAlignment(0);
        this.m_mixMaster8Label.setText("aux out 8");
        this.m_out8Panel.add(this.m_mixMaster8Label);
        this.m_mixMaster8Label.setBounds(16, 14, 80, 16);
        this.m_barALabel_42.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_42.setForeground(new Color(204, 204, 204));
        this.m_barALabel_42.setHorizontalAlignment(4);
        this.m_barALabel_42.setText("0");
        this.m_out8Panel.add(this.m_barALabel_42);
        this.m_barALabel_42.setBounds(5, 68, 20, 15);
        this.m_barALabel_43.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_43.setForeground(new Color(204, 204, 204));
        this.m_barALabel_43.setHorizontalAlignment(4);
        this.m_barALabel_43.setText("-6");
        this.m_out8Panel.add(this.m_barALabel_43);
        this.m_barALabel_43.setBounds(5, 95, 20, 15);
        this.m_barALabel_44.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_44.setForeground(new Color(204, 204, 204));
        this.m_barALabel_44.setHorizontalAlignment(4);
        this.m_barALabel_44.setText("-12");
        this.m_out8Panel.add(this.m_barALabel_44);
        this.m_barALabel_44.setBounds(5, 122, 20, 15);
        this.m_barALabel_45.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_45.setForeground(new Color(204, 204, 204));
        this.m_barALabel_45.setHorizontalAlignment(4);
        this.m_barALabel_45.setText("-24");
        this.m_out8Panel.add(this.m_barALabel_45);
        this.m_barALabel_45.setBounds(5, 149, 20, 15);
        this.m_barALabel_46.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_46.setForeground(new Color(204, 204, 204));
        this.m_barALabel_46.setHorizontalAlignment(4);
        this.m_barALabel_46.setText("-36");
        this.m_out8Panel.add(this.m_barALabel_46);
        this.m_barALabel_46.setBounds(5, 176, 20, 15);
        this.m_barALabel_47.setFont(new Font("Tahoma", 1, 10));
        this.m_barALabel_47.setForeground(new Color(204, 204, 204));
        this.m_barALabel_47.setHorizontalAlignment(4);
        this.m_barALabel_47.setText("-60");
        this.m_out8Panel.add(this.m_barALabel_47);
        this.m_barALabel_47.setBounds(5, 203, 20, 15);
        this.jLabel38.setFont(new Font("Lucida Grande", 1, 12));
        this.jLabel38.setForeground(new Color(204, 204, 204));
        this.jLabel38.setHorizontalAlignment(0);
        this.jLabel38.setText("clip");
        this.jLabel38.setHorizontalTextPosition(0);
        this.m_out8Panel.add(this.jLabel38);
        this.jLabel38.setBounds(19, 34, 36, 21);
        this.m_mute8BT.setBackground(new Color(100, 100, 100));
        this.m_mute8BT.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/mute_off.png")));
        this.m_mute8BT.setToolTipText("Click to use or not use music reference.");
        this.m_mute8BT.setAlignmentY(0.0f);
        this.m_mute8BT.setBorder(new SoftBevelBorder(0));
        this.m_mute8BT.setBorderPainted(false);
        this.m_mute8BT.setContentAreaFilled(false);
        this.m_mute8BT.setFocusable(false);
        this.m_mute8BT.setHorizontalTextPosition(0);
        this.m_mute8BT.setIconTextGap(0);
        this.m_mute8BT.setInheritsPopupMenu(true);
        this.m_mute8BT.setMargin(new Insets(0, 0, 0, 0));
        this.m_mute8BT.setMaximumSize(new Dimension(36, 36));
        this.m_mute8BT.setMinimumSize(new Dimension(36, 36));
        this.m_mute8BT.setPreferredSize(new Dimension(37, 37));
        this.m_mute8BT.setSelectedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led_yellow_on.png")));
        this.m_mute8BT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_mute8BTActionPerformed(evt);
            }
        });
        this.m_out8Panel.add(this.m_mute8BT);
        this.m_mute8BT.setBounds(7, 230, 50, 50);
        this.m_phase8BT.setBackground(new Color(100, 100, 100));
        this.m_phase8BT.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/phase_off.png")));
        this.m_phase8BT.setToolTipText("Click to enable/disable  channel NOM.");
        this.m_phase8BT.setAlignmentY(0.0f);
        this.m_phase8BT.setBorder(new SoftBevelBorder(0));
        this.m_phase8BT.setBorderPainted(false);
        this.m_phase8BT.setContentAreaFilled(false);
        this.m_phase8BT.setFocusable(false);
        this.m_phase8BT.setHorizontalTextPosition(0);
        this.m_phase8BT.setIconTextGap(0);
        this.m_phase8BT.setInheritsPopupMenu(true);
        this.m_phase8BT.setMargin(new Insets(0, 0, 0, 0));
        this.m_phase8BT.setMaximumSize(new Dimension(36, 36));
        this.m_phase8BT.setMinimumSize(new Dimension(36, 36));
        this.m_phase8BT.setPreferredSize(new Dimension(37, 37));
        this.m_phase8BT.setSelectedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led_yellow_on.png")));
        this.m_phase8BT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_phase8BTActionPerformed(evt);
            }
        });
        this.m_out8Panel.add(this.m_phase8BT);
        this.m_phase8BT.setBounds(61, 230, 50, 50);
        this.m_outputSelect_8.setFont(new Font("Lucida Grande", 0, 12));
        this.m_outputSelect_8.setModel(new DefaultComboBoxModel<String>(new String[]{"analog out 16", "Item 3", "Item 4"}));
        this.m_outputSelect_8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.MixOutputSelectActionPerformed(evt);
            }
        });
        this.m_out8Panel.add(this.m_outputSelect_8);
        this.m_outputSelect_8.setBounds(5, 12, 108, 22);
        this.add(this.m_out8Panel);
        this.m_out8Panel.setBounds(866, 58, 118, 288);
        this.m_setToDefaults.setBackground(new Color(80, 80, 80));
        this.m_setToDefaults.setFont(new Font("Tahoma", 1, 12));
        this.m_setToDefaults.setForeground(new Color(180, 180, 180));
        this.m_setToDefaults.setIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led1_off.png")));
        this.m_setToDefaults.setText("<html><center>set to<br>defaults</center></html>");
        this.m_setToDefaults.setBorder(null);
        this.m_setToDefaults.setBorderPainted(false);
        this.m_setToDefaults.setContentAreaFilled(false);
        this.m_setToDefaults.setHorizontalTextPosition(0);
        this.m_setToDefaults.setPressedIcon(new ImageIcon(this.getClass().getResource("/DuganCP/Images/led1_off_down.png")));
        this.m_setToDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MixMatrix.this.m_setToDefaultsActionPerformed(evt);
            }
        });
        this.add(this.m_setToDefaults);
        this.m_setToDefaults.setBounds(11, 10, 75, 45);
    }

    private void m_closeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        if (this.m_duganUI != null) {
            this.m_duganUI.ShowAllPanels(true);
        }
    }

    private void m_mute1BTActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.setMixerMute(0, !this.mute[0]);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void m_phase1BTActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.setMixerPolarity(0, !this.phase[0]);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void m_mute3BTActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.setMixerMute(2, !this.mute[2]);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void m_mute2BTActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.setMixerMute(1, !this.mute[1]);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void m_phase2BTActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.setMixerPolarity(1, !this.phase[1]);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void m_phase3BTActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.setMixerPolarity(2, !this.phase[2]);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void m_mute4BTActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.setMixerMute(3, !this.mute[3]);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void m_phase4BTActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.setMixerPolarity(3, !this.phase[3]);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void m_mute5BTActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.setMixerMute(4, !this.mute[4]);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void m_phase5BTActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.setMixerPolarity(4, !this.phase[4]);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void m_mute6BTActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.setMixerMute(5, !this.mute[5]);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void m_phase6BTActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.setMixerPolarity(5, !this.phase[5]);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void VolumeTFFocusLost(FocusEvent evt) {
        double vol;
        JTextField tf = (JTextField)evt.getSource();
        int i = 0;
        while (i < 8) {
            if (this.volumeTF[i] == tf) break;
            ++i;
        }
        if (i == 8) {
            return;
        }
        try {
            vol = this.decimalFormat.parse(tf.getText()).doubleValue();
        }
        catch (ParseException ex) {
            Logger.getLogger(Channel.class.getName()).log(Level.SEVERE, null, ex);
            vol = this.volume[i];
        }
        vol = Channel.BoundCheckWeight(vol);
        tf.setText(String.format("%.1f", vol));
        if (vol != this.volume[i]) {
            if (this.m_udpComm != null) {
                try {
                    this.m_udpComm.setMixerVolume(i, vol);
                }
                catch (IOException ex) {
                    Logger.getLogger(Channel.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                tf.setText(String.format("%.1f", this.volume[i]));
            }
        }
        tf.setForeground(Color.black);
    }

    private void VolumeTFKeyReleased(KeyEvent evt) {
        JTextField tf = (JTextField)evt.getSource();
        int i = 0;
        while (i < 8) {
            if (this.volumeTF[i] == tf) break;
            ++i;
        }
        if (i == 8) {
            return;
        }
        if (evt.getKeyCode() == 10) {
            double vol;
            try {
                vol = this.decimalFormat.parse(tf.getText()).doubleValue();
            }
            catch (ParseException ex) {
                Logger.getLogger(Channel.class.getName()).log(Level.SEVERE, null, ex);
                vol = this.volume[i];
            }
            vol = Channel.BoundCheckWeight(vol);
            tf.setText(String.format("%.1f", vol));
            if (vol != this.volume[i]) {
                if (this.m_udpComm != null) {
                    try {
                        this.m_udpComm.setMixerVolume(i, vol);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Channel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    tf.setText(String.format("%.1f", this.volume[i]));
                }
            }
            tf.setForeground(Color.black);
        } else if (evt.getKeyCode() == 27) {
            tf.setText(String.format("%.1f", this.volume[i]));
            tf.setForeground(Color.black);
        } else {
            tf.setForeground(Color.red);
        }
    }

    private void SliderFocusGained(FocusEvent evt) {
        ((JSlider)evt.getComponent()).setBorder(this.lineBorder);
    }

    private void SliderFocusLost(FocusEvent evt) {
        ((JSlider)evt.getComponent()).setBorder(this.emptyBorder);
    }

    private void SliderMouseReleased(MouseEvent evt) {
        int modifiers = evt.getModifiersEx();
        if ((modifiers & 0x80) != 0) {
            ((JSlider)evt.getComponent()).setValue(60);
        }
    }

    private void SliderStateChanged(ChangeEvent evt) {
        JSlider slider = (JSlider)evt.getSource();
        int i = 0;
        while (i < 8) {
            if (this.volumeSliders[i] == slider) break;
            ++i;
        }
        if (i == 8) {
            return;
        }
        if (this.sliderChanging) {
            this.sliderChanging = false;
            return;
        }
        int value = slider.getValue();
        double weight = value == 0 ? -100.0 : 0.5 * (double)value - 30.0;
        if (weight != this.volume[i]) {
            if (this.m_udpComm != null) {
                try {
                    this.m_udpComm.setMixerVolume(i, weight);
                }
                catch (IOException ex) {
                    Logger.getLogger(Channel.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.sliderChanging = true;
            } else {
                this.volumeTF[i].setText(String.format("%.1f", this.volume[i]));
            }
        }
    }

    private void m_mute7BTActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.setMixerMute(6, !this.mute[6]);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void m_phase7BTActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.setMixerPolarity(6, !this.phase[6]);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void m_mute8BTActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.setMixerMute(7, !this.mute[7]);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void m_phase8BTActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.setMixerPolarity(7, !this.phase[7]);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void m_setToDefaultsActionPerformed(ActionEvent evt) {
        if (this.m_udpComm != null) {
            try {
                this.m_udpComm.ResetMixer();
                this.resetMatrixRequested = true;
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void MouseDraggedHandler(MouseEvent evt) {
        if (this.m_udpComm == null) {
            return;
        }
        Point curLoc = evt.getPoint();
        JTextField tf = (JTextField)evt.getComponent();
        Date now = new Date();
        if (now.getTime() - this.lastDragUpdate.getTime() < 100L) {
            this.mousePressedLocation = curLoc;
            return;
        }
        if (!this.m_udpComm.IsFIFOEmpty()) {
            this.mousePressedLocation = curLoc;
            return;
        }
        this.lastDragUpdate = now;
        int which = Integer.parseInt(tf.getName());
        double vol = SmallMaster.DoDrag(this.mousePressedLocation, curLoc, this.volume[which], 0.5, -60.0, 15.0);
        if (vol != this.volume[which]) {
            try {
                this.m_udpComm.setMixerVolume(which, vol);
            }
            catch (IOException ex) {
                Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.mousePressedLocation = curLoc;
    }

    private void MousePressedHandler(MouseEvent evt) {
        this.mousePressedLocation = evt.getPoint();
        this.lastDragUpdate = new Date(0L);
    }

    private void MixOutputSelectActionPerformed(ActionEvent evt) {
        if (this.ignoreChangeEvent) {
            return;
        }
        int i = 0;
        while (i < 8) {
            if (evt.getSource() == this.outputSelectCB[i]) break;
            ++i;
        }
        if (i == 8) {
            return;
        }
        if (this.selectChanged == i) {
            this.selectChanged = -1;
            return;
        }
        int selected = this.outputSelectCB[i].getSelectedIndex();
        if (selected == -1) {
            return;
        }
        int j = 0;
        while (j < this.nRows) {
            if (i != j && this.outputSelect[j] == selected && selected > 0) {
                JOptionPane.showMessageDialog(this, "Output is already assigned to another mixer channe!");
                this.outputSelectCB[i].setSelectedIndex(this.outputSelect[i]);
                return;
            }
            ++j;
        }
        try {
            this.m_udpComm.setMixBusOutputSelect(i, selected);
            this.outputSelect[i] = selected;
        }
        catch (IOException ex) {
            Logger.getLogger(MixMatrix.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.m_matrixRowHeaderModel.setElementAt(i, (String)this.outputSelectCB[i].getSelectedItem());
        this.m_matrixPane.getRowHeader().repaint();
    }

    public void setDuganUI(DuganUI ui) {
        this.m_duganUI = ui;
    }

    private void ReorderOutputSelect() {
        switch (this.m_udpComm.getDeviceType()) {
            case MODEL_E2A: {
                break;
            }
            case MODEL_E3A: {
                break;
            }
        }
    }

    private void ReorderColumns() {
        switch (this.m_udpComm.getDeviceType()) {
            case MODEL_N: {
                if (!this.m_udpComm.HasMixer()) {
                    return;
                }
                int i = 8;
                while (i < 144) {
                    this.m_matrix.removeColumn(this.columns[i]);
                    ++i;
                }
                i = 8;
                while (i < this.nActiveChannels) {
                    this.m_matrix.addColumn(this.columns[i]);
                    ++i;
                }
                int j = 64;
                i = 0;
                while (i < (this.m_udpComm.Is96K() ? 32 : 64)) {
                    this.m_matrix.addColumn(this.columns[j]);
                    ++i;
                    ++j;
                }
                j = 128;
                i = 0;
                while (i < 8) {
                    this.m_matrix.addColumn(this.columns[j]);
                    ++i;
                    ++j;
                }
                if (this.hasADATLink) break;
                i = 0;
                while (i < 8) {
                    this.m_matrix.addColumn(this.columns[j]);
                    ++i;
                    ++j;
                }
                break;
            }
            case MODEL_M: {
                if (!this.m_udpComm.HasMixer()) {
                    return;
                }
                int i = 8;
                while (i < 144) {
                    this.m_matrix.removeColumn(this.columns[i]);
                    ++i;
                }
                i = 8;
                while (i < this.nActiveChannels) {
                    this.m_matrix.addColumn(this.columns[i]);
                    ++i;
                }
                int j = 64;
                i = 0;
                while (i < (this.m_udpComm.Is96K() ? 32 : 64)) {
                    this.m_matrix.addColumn(this.columns[j]);
                    ++i;
                    ++j;
                }
                j = 128;
                i = 0;
                while (i < 8) {
                    this.m_matrix.addColumn(this.columns[j]);
                    ++i;
                    ++j;
                }
                if (this.hasADATLink) break;
                i = 0;
                while (i < 8) {
                    this.m_matrix.addColumn(this.columns[j]);
                    ++i;
                    ++j;
                }
                break;
            }
            case MODEL_PY: {
                if (!this.m_udpComm.HasMixer()) {
                    return;
                }
                int i = 8;
                while (i < 144) {
                    this.m_matrix.removeColumn(this.columns[i]);
                    ++i;
                }
                i = 8;
                while (i < this.nActiveChannels) {
                    this.m_matrix.addColumn(this.columns[i]);
                    ++i;
                }
                int j = 64;
                i = 0;
                while (i < this.nActiveChannels) {
                    this.m_matrix.addColumn(this.columns[j]);
                    ++i;
                    ++j;
                }
                break;
            }
            case MODEL_E2A: {
                int i = 8;
                while (i < 144) {
                    this.m_matrix.removeColumn(this.columns[i]);
                    ++i;
                }
                i = 8;
                while (i < this.nActiveChannels) {
                    this.m_matrix.addColumn(this.columns[i]);
                    ++i;
                }
                int j = 28;
                i = 0;
                while (i < 12) {
                    this.m_matrix.addColumn(this.columns[j]);
                    ++i;
                    ++j;
                }
                j = 40;
                i = 0;
                while (i < 8) {
                    this.m_matrix.addColumn(this.columns[j]);
                    ++i;
                    ++j;
                }
                if (this.hasADATLink) break;
                i = 0;
                while (i < 8) {
                    this.m_matrix.addColumn(this.columns[j]);
                    ++i;
                    ++j;
                }
                break;
            }
            case MODEL_E3A: {
                int i = 8;
                while (i < 144) {
                    this.m_matrix.removeColumn(this.columns[i]);
                    ++i;
                }
                i = 8;
                while (i < this.nActiveChannels) {
                    this.m_matrix.addColumn(this.columns[i]);
                    ++i;
                }
                int j = 32;
                i = 0;
                while (i < 16) {
                    this.m_matrix.addColumn(this.columns[j]);
                    ++i;
                    ++j;
                }
                j = 48;
                i = 0;
                while (i < 8) {
                    this.m_matrix.addColumn(this.columns[j]);
                    ++i;
                    ++j;
                }
                if (this.hasADATLink) break;
                i = 0;
                while (i < 8) {
                    this.m_matrix.addColumn(this.columns[j]);
                    ++i;
                    ++j;
                }
                break;
            }
            case MODEL_E2: 
            case MODEL_E3: {
                int i = 8;
                while (i < 144) {
                    this.m_matrix.removeColumn(this.columns[i]);
                    ++i;
                }
                i = 8;
                while (i < this.nActiveChannels) {
                    this.m_matrix.addColumn(this.columns[i]);
                    ++i;
                }
                int j = 16;
                i = 0;
                while (i < this.nPrimaryInputs) {
                    this.m_matrix.addColumn(this.columns[j]);
                    ++i;
                    ++j;
                }
                j += 16 - this.nPrimaryInputs;
                i = 0;
                while (i < 8) {
                    this.m_matrix.addColumn(this.columns[j]);
                    ++i;
                    ++j;
                }
                if (this.hasADATLink) break;
                i = 0;
                while (i < 8) {
                    this.m_matrix.addColumn(this.columns[j]);
                    ++i;
                    ++j;
                }
                break;
            }
        }
        this.m_matrix.revalidate();
    }

    public void setNActiveChannels(int nChannels) {
        if (this.nActiveChannels != nChannels) {
            this.nActiveChannels = nChannels;
            this.ReorderColumns();
        }
    }

    public void setNPrimaryInputs(int nInputs) {
        if (this.nPrimaryInputs != nInputs) {
            this.nPrimaryInputs = nInputs;
            this.ReorderColumns();
        }
    }

    public void setHasADATLink() {
        boolean hasLink = this.m_udpComm.HasADATLink();
        if (this.hasADATLink != hasLink) {
            this.hasADATLink = hasLink;
            this.ReorderColumns();
            this.ReorderOutputSelect();
        }
    }

    public void setUDPComm(UDPComm udpComm) {
        int i;
        int rows;
        if (this.m_udpComm != null) {
            this.m_udpComm.removePropertyChangeListener("mixerMute", this.UDPMixerMuteListener);
            this.m_udpComm.removePropertyChangeListener("mixerPolarity", this.UDPMixerPolarityListener);
            this.m_udpComm.removePropertyChangeListener("mixerVolume", this.UDPMixerVolumeListener);
            this.m_udpComm.removePropertyChangeListener("mixPeaks", this.UDPMixPeaksListener);
            this.m_udpComm.removePropertyChangeListener("mixerCrossPoint", this.UDPMixerCrossPointListener);
            this.m_udpComm.removePropertyChangeListener("mixerParams", this.UDPMixerParamsListener);
            this.m_udpComm.removePropertyChangeListener("nChannels", this.UDPNChannelListener);
            this.m_udpComm.removePropertyChangeListener("adatAudio", this.UDPAdatAudioListener);
            this.m_udpComm.removePropertyChangeListener("Adat16Channels", this.UDPAdat16ChannelsListener);
            this.m_udpComm.removePropertyChangeListener("mixerOutputSelect", this.UDPMixerOutputSelectListener);
        }
        this.m_udpComm = udpComm;
        if (udpComm == null) {
            return;
        }
        this.m_udpComm.addPropertyChangeListener("mixerMute", this.UDPMixerMuteListener);
        this.m_udpComm.addPropertyChangeListener("mixerPolarity", this.UDPMixerPolarityListener);
        this.m_udpComm.addPropertyChangeListener("mixerVolume", this.UDPMixerVolumeListener);
        this.m_udpComm.addPropertyChangeListener("mixPeaks", this.UDPMixPeaksListener);
        this.m_udpComm.addPropertyChangeListener("mixerCrossPoint", this.UDPMixerCrossPointListener);
        this.m_udpComm.addPropertyChangeListener("mixerParams", this.UDPMixerParamsListener);
        this.m_udpComm.addPropertyChangeListener("nChannels", this.UDPNChannelListener);
        this.m_udpComm.addPropertyChangeListener("adatAudio", this.UDPAdatAudioListener);
        this.m_udpComm.addPropertyChangeListener("Adat16Channels", this.UDPAdat16ChannelsListener);
        this.m_udpComm.addPropertyChangeListener("mixerOutputSelect", this.UDPMixerOutputSelectListener);
        this.setNActiveChannels(udpComm.getNChannels());
        switch (udpComm.getDeviceType()) {
            case MODEL_E1A: {
                this.setNPrimaryInputs(8);
                rows = 8;
                i = 8;
                while (i < 16) {
                    this.columns[i].setHeaderValue(String.format("automix %d", i + 1));
                    ++i;
                }
                break;
            }
            case MODEL_E2: {
                rows = 4;
                i = 0;
                while (i < 8) {
                    this.mixMasterLabel[i].setVisible(true);
                    this.outputSelectCB[i].setVisible(false);
                    this.mixMasterLabel[i].setText(String.format("audio out %d", i + 9));
                    this.m_matrixRowHeaderModel.setElementAt(i, String.format("audio out %d", i + 9));
                    ++i;
                }
                i = 8;
                while (i < 16) {
                    this.columns[i].setHeaderValue(String.format("automix %d", i + 1));
                    ++i;
                }
                i = 16;
                while (i < 28) {
                    this.columns[i].setHeaderValue(String.format("audio in %d", i - 16 + 1));
                    ++i;
                }
                i += 4;
                int j = 0;
                while (j < 16) {
                    this.columns[i].setHeaderValue(String.format("adat in %d", j + 1));
                    ++i;
                    ++j;
                }
                this.setHasADATLink();
                this.m_matrix.getTableHeader().resizeAndRepaint();
                this.setNPrimaryInputs(12);
                break;
            }
            case MODEL_E3: {
                rows = 6;
                i = 0;
                while (i < 8) {
                    this.mixMasterLabel[i].setVisible(true);
                    this.outputSelectCB[i].setVisible(false);
                    this.mixMasterLabel[i].setText(String.format("aux out %d", i + 1));
                    this.m_matrixRowHeaderModel.setElementAt(i, String.format("aux out %d", i + 1));
                    ++i;
                }
                i = 8;
                while (i < 16) {
                    this.columns[i].setHeaderValue(String.format("automix %d", i + 1));
                    ++i;
                }
                i = 16;
                while (i < 30) {
                    this.columns[i].setHeaderValue(String.format("aes in %d", i - 16 + 1));
                    ++i;
                }
                i += 2;
                int j = 0;
                while (j < 16) {
                    this.columns[i].setHeaderValue(String.format("adat in %d", j + 1));
                    ++i;
                    ++j;
                }
                this.setHasADATLink();
                this.m_matrix.getTableHeader().resizeAndRepaint();
                this.setNPrimaryInputs(14);
                break;
            }
            case MODEL_E2A: {
                String label;
                rows = 6;
                i = 8;
                while (i < 28) {
                    this.columns[i].setHeaderValue(String.format("automix %d", i + 1));
                    ++i;
                }
                i = 28;
                int j = 1;
                while (i < 40) {
                    this.columns[i].setHeaderValue(String.format("analog in %d", j));
                    ++i;
                    ++j;
                }
                j = 1;
                while (i < 56) {
                    this.columns[i].setHeaderValue(String.format("adat in %d", j));
                    ++i;
                    ++j;
                }
                this.setHasADATLink();
                this.ignoreChangeEvent = true;
                i = 0;
                while (i < 6) {
                    this.outputSelectCB[i].removeAllItems();
                    this.outputSelectCB[i].addItem(String.format("mix bus %d", i + 1));
                    j = 0;
                    while (j < 12) {
                        this.outputSelectCB[i].addItem(String.format("analog out %d", j + 1));
                        ++j;
                    }
                    j = 0;
                    while (j < (this.hasADATLink ? 8 : 16)) {
                        this.outputSelectCB[i].addItem(String.format("adat out %d", j + 1));
                        ++j;
                    }
                    this.mixMasterLabel[i].setVisible(false);
                    this.outputSelectCB[i].setVisible(true);
                    label = this.outputSelect[i] == 0 ? String.format("mix bus %d", i + 1) : (this.outputSelect[i] <= 12 ? String.format("analog out %d", this.outputSelect[i]) : String.format("adat out %d", i - 12));
                    this.mixMasterLabel[i].setText(label);
                    this.m_matrixRowHeaderModel.setElementAt(i, label);
                    ++i;
                }
                this.m_matrix.getTableHeader().resizeAndRepaint();
                this.ignoreChangeEvent = false;
                break;
            }
            case MODEL_E3A: {
                String label;
                rows = 6;
                i = 8;
                while (i < 32) {
                    this.columns[i].setHeaderValue(String.format("automix %d", i + 1));
                    ++i;
                }
                i = 32;
                int j = 1;
                while (i < 48) {
                    this.columns[i].setHeaderValue(String.format("aes in %d", j));
                    ++i;
                    ++j;
                }
                j = 1;
                while (i < 64) {
                    this.columns[i].setHeaderValue(String.format("adat in %d", j));
                    ++i;
                    ++j;
                }
                this.setHasADATLink();
                this.ignoreChangeEvent = true;
                i = 0;
                while (i < 6) {
                    this.outputSelectCB[i].removeAllItems();
                    this.outputSelectCB[i].addItem(String.format("mix bus %d", i + 1));
                    j = 0;
                    while (j < 16) {
                        this.outputSelectCB[i].addItem(String.format("aes out %d", j + 1));
                        ++j;
                    }
                    j = 0;
                    while (j < (this.hasADATLink ? 8 : 16)) {
                        this.outputSelectCB[i].addItem(String.format("adat out %d", j + 1));
                        ++j;
                    }
                    this.mixMasterLabel[i].setVisible(false);
                    this.outputSelectCB[i].setVisible(true);
                    label = this.outputSelect[i] == 0 ? String.format("mix bus %d", i + 1) : (this.outputSelect[i] <= 16 ? String.format("aes out %d", this.outputSelect[i]) : String.format("adat %d", i - 16));
                    this.mixMasterLabel[i].setText(label);
                    this.m_matrixRowHeaderModel.setElementAt(i, label);
                    ++i;
                }
                this.m_matrix.getTableHeader().resizeAndRepaint();
                this.ignoreChangeEvent = false;
                break;
            }
            case MODEL_N: {
                String label;
                rows = 6;
                if (!this.m_udpComm.HasMixer()) break;
                i = 8;
                while (i < 64) {
                    this.columns[i].setHeaderValue(String.format("automix %d", i + 1));
                    ++i;
                }
                i = 64;
                int j = 1;
                while (i < 128) {
                    this.columns[i].setHeaderValue(String.format("dante in %d", j));
                    ++i;
                    ++j;
                }
                j = 1;
                while (i < 144) {
                    this.columns[i].setHeaderValue(String.format("adat in %d", j));
                    ++i;
                    ++j;
                }
                this.setHasADATLink();
                this.ignoreChangeEvent = true;
                i = 0;
                while (i < 6) {
                    this.outputSelectCB[i].removeAllItems();
                    this.outputSelectCB[i].addItem(String.format("mix bus %d", i + 1));
                    j = 0;
                    while (j < 64) {
                        this.outputSelectCB[i].addItem(String.format("dante out %d", j + 1));
                        ++j;
                    }
                    j = 0;
                    while (j < (this.hasADATLink ? 8 : 16)) {
                        this.outputSelectCB[i].addItem(String.format("adat out %d", j + 1));
                        ++j;
                    }
                    this.mixMasterLabel[i].setVisible(false);
                    this.outputSelectCB[i].setVisible(true);
                    label = this.outputSelect[i] == 0 ? String.format("mix bus %d", i + 1) : (this.outputSelect[i] <= 64 ? String.format("dante out %d", this.outputSelect[i]) : String.format("adat %d", i - 64));
                    this.mixMasterLabel[i].setText(label);
                    this.m_matrixRowHeaderModel.setElementAt(i, label);
                    ++i;
                }
                this.m_matrix.getTableHeader().resizeAndRepaint();
                this.ignoreChangeEvent = false;
                break;
            }
            case MODEL_M: {
                String label;
                rows = 6;
                if (!this.m_udpComm.HasMixer()) break;
                i = 8;
                while (i < 64) {
                    this.columns[i].setHeaderValue(String.format("automix %d", i + 1));
                    ++i;
                }
                i = 64;
                int j = 1;
                while (i < 128) {
                    this.columns[i].setHeaderValue(String.format("madi in %d", j));
                    ++i;
                    ++j;
                }
                j = 1;
                while (i < 144) {
                    this.columns[i].setHeaderValue(String.format("adat in %d", j));
                    ++i;
                    ++j;
                }
                this.setHasADATLink();
                this.ignoreChangeEvent = true;
                i = 0;
                while (i < 6) {
                    this.outputSelectCB[i].removeAllItems();
                    this.outputSelectCB[i].addItem(String.format("mix bus %d", i + 1));
                    j = 0;
                    while (j < 64) {
                        this.outputSelectCB[i].addItem(String.format("madi out %d", j + 1));
                        ++j;
                    }
                    j = 0;
                    while (j < (this.hasADATLink ? 8 : 16)) {
                        this.outputSelectCB[i].addItem(String.format("adat out %d", j + 1));
                        ++j;
                    }
                    this.mixMasterLabel[i].setVisible(false);
                    this.outputSelectCB[i].setVisible(true);
                    label = this.outputSelect[i] == 0 ? String.format("mix bus %d", i + 1) : (this.outputSelect[i] <= 64 ? String.format("madi out %d", this.outputSelect[i]) : String.format("adat %d", i - 64));
                    this.mixMasterLabel[i].setText(label);
                    this.m_matrixRowHeaderModel.setElementAt(i, label);
                    ++i;
                }
                this.m_matrix.getTableHeader().resizeAndRepaint();
                this.ignoreChangeEvent = false;
                break;
            }
            case MODEL_PY: {
                String label;
                rows = 6;
                if (!this.m_udpComm.HasMixer()) break;
                i = 8;
                while (i < 64) {
                    this.columns[i].setHeaderValue(String.format("automix %d", i + 1));
                    ++i;
                }
                i = 64;
                int j = 1;
                while (i < 128) {
                    this.columns[i].setHeaderValue(String.format("input %d", j));
                    ++i;
                    ++j;
                }
                this.setHasADATLink();
                this.ignoreChangeEvent = true;
                i = 0;
                while (i < 6) {
                    this.outputSelectCB[i].removeAllItems();
                    this.outputSelectCB[i].addItem(String.format("mix bus %d", i + 1));
                    j = 0;
                    while (j < 64) {
                        this.outputSelectCB[i].addItem(String.format("output %d", j + 1));
                        ++j;
                    }
                    this.mixMasterLabel[i].setVisible(false);
                    this.outputSelectCB[i].setVisible(true);
                    label = this.outputSelect[i] == 0 ? String.format("mix bus %d", i + 1) : String.format("output %d", this.outputSelect[i]);
                    this.mixMasterLabel[i].setText(label);
                    this.m_matrixRowHeaderModel.setElementAt(i, label);
                    ++i;
                }
                this.m_matrix.getTableHeader().resizeAndRepaint();
                this.ignoreChangeEvent = false;
                break;
            }
            default: {
                this.setNPrimaryInputs(14);
                rows = 6;
            }
        }
        int x = (1024 - rows * this.m_out1Panel.getWidth()) / 2;
        int y = this.m_out1Panel.getY();
        i = 0;
        while (i < rows) {
            this.controlPanels[i].setLocation(x, y);
            x += this.m_out1Panel.getWidth();
            ++i;
        }
        this.m_matrixRowHeaderModel.setSize(rows);
        DefaultTableModel model = (DefaultTableModel)this.m_matrix.getModel();
        model.setRowCount(rows);
        if (rows < this.nRows) {
            i = rows;
            while (i < this.nRows) {
                this.controlPanels[i].setVisible(false);
                ++i;
            }
        } else if (rows > this.nRows) {
            i = this.nRows;
            while (i < rows) {
                this.controlPanels[i].setVisible(true);
                ++i;
            }
        }
        this.m_matrixPane.setSize(this.m_matrixPane.getWidth(), (rows + 1) * this.m_matrix.getRowHeight() + 5);
        this.nRows = rows;
    }

    public int getPanelHeight() {
        return 691 - (8 - this.nRows) * this.m_matrix.getRowHeight();
    }

    private void ProcessMixerParams(byte[] buf) {
        int i;
        int rowLen;
        if (buf.length == 0) {
            return;
        }
        UDPComm.DevType type = this.m_udpComm.getDeviceType();
        switch (type) {
            case MODEL_E2A: {
                rowLen = 56;
                break;
            }
            case MODEL_E3A: {
                rowLen = 64;
                break;
            }
            case MODEL_E2: 
            case MODEL_E3: {
                rowLen = 48;
                break;
            }
            case MODEL_N: {
                rowLen = 144;
                break;
            }
            case MODEL_M: {
                rowLen = 144;
                break;
            }
            case MODEL_PY: {
                rowLen = 144;
                break;
            }
            default: {
                rowLen = 48;
            }
        }
        int k = 4;
        int j = 0;
        while (j < this.nRows) {
            i = 0;
            while (i < rowLen) {
                double val;
                TableCellEditor ed;
                if (this.resetMatrixRequested && (ed = this.m_matrix.getCellEditor()) != null) {
                    this.m_matrix.getCellEditor().cancelCellEditing();
                }
                if ((val = (double)((0xFF & buf[k]) - 192) * 0.5) != this.xpoint[j][i]) {
                    this.xpoint[j][i] = val;
                    if (val <= -96.0) {
                        this.m_matrix.getModel().setValueAt("", j, i);
                    } else {
                        this.m_matrix.getModel().setValueAt(String.format("%.1f", val), j, i);
                    }
                }
                ++i;
                ++k;
            }
            ++j;
        }
        i = 0;
        while (i < this.nRows) {
            this.mute[i] = buf[k] != 0;
            this.muteButtons[i].setSelected(this.mute[i]);
            if (this.mute[i]) {
                this.muteButtons[i].setPressedIcon(this.muteOffDownIcon);
            } else {
                this.muteButtons[i].setPressedIcon(this.muteOffIcon);
            }
            ++i;
            ++k;
        }
        i = 0;
        while (i < this.nRows) {
            this.phase[i] = buf[k] != 0;
            this.phaseButtons[i].setSelected(this.phase[i]);
            if (this.phase[i]) {
                this.phaseButtons[i].setPressedIcon(this.phaseOffDownIcon);
            } else {
                this.phaseButtons[i].setPressedIcon(this.phaseOffIcon);
            }
            ++i;
            ++k;
        }
        i = 0;
        while (i < this.nRows) {
            this.volume[i] = (double)((0xFF & buf[k]) - 192) * 0.5;
            this.sliderChanging = true;
            if (this.volume[i] <= -30.0) {
                this.volumeSliders[i].setValue(0);
            } else {
                this.volumeSliders[i].setValue((int)((this.volume[i] + 30.0) * 2.0 + 0.5));
            }
            this.volumeTF[i].setText(String.format("%.1f", this.volume[i]));
            ++i;
            ++k;
        }
        if (type == UDPComm.DevType.MODEL_N || type == UDPComm.DevType.MODEL_M || type == UDPComm.DevType.MODEL_E2A || type == UDPComm.DevType.MODEL_E3A || type == UDPComm.DevType.MODEL_PY) {
            i = 0;
            while (i < this.nRows) {
                this.outputSelect[i] = 0xFF & buf[k];
                this.selectChanged = i;
                this.outputSelectCB[i].setSelectedIndex(this.outputSelect[i]);
                this.m_matrixRowHeaderModel.setElementAt(i, (String)this.outputSelectCB[i].getSelectedItem());
                this.m_matrixPane.getRowHeader().repaint();
                ++i;
                ++k;
            }
            this.m_matrix.getTableHeader().resizeAndRepaint();
        }
        this.resetMatrixRequested = false;
    }
}

