/*
 * Decompiled with CFR 0.152.
 */
package DuganCP;

import DuganCP.Channel;
import DuganCP.DuganUI;
import com.apple.eawt.Application;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class Dugan_Control_Panel
extends JFrame {
    private static final long serialVersionUID = -6819363666147695412L;
    private DuganUI m_duganUI = null;

    public Dugan_Control_Panel() {
        URL imgURL;
        boolean isMac;
        this.initComponents();
        String os = System.getProperty("os.name").toLowerCase();
        boolean bl = isMac = os.indexOf("mac") >= 0;
        if (isMac) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Dugan CP-J");
        }
        if ((imgURL = Dugan_Control_Panel.class.getResource("/DuganCP/Images/logo.png")) != null) {
            ImageIcon icon = new ImageIcon(imgURL);
            this.setIconImage(icon.getImage());
        }
        GregorianCalendar cal = new GregorianCalendar();
        System.out.printf("%02d:%02d:%02d - Program started.\n", cal.get(11), cal.get(12), cal.get(13));
        Preferences prefs = Preferences.userRoot().node("/com/dugan/DuganCP");
        String manuallyAddedIP = prefs.get("Manual IPs", "");
        System.out.println(String.format("Retrieved list: %s", manuallyAddedIP));
        String allowSearchStr = prefs.get("Allow Search", "");
        boolean allowSearch = true;
        if (allowSearchStr.length() > 0) {
            allowSearch = Integer.parseInt(allowSearchStr) != 0;
        }
        System.out.println(String.format("Retrieved AllowSearch: %s", allowSearch ? "true" : "false"));
        this.m_duganUI = new DuganUI();
        this.m_duganUI.setManuallyAddedIP(manuallyAddedIP);
        this.m_duganUI.setAllowSearch(allowSearch);
        this.add(this.m_duganUI);
        this.m_duganUI.setBounds(0, 0, 1025, 738);
        if (isMac) {
            System.setProperty("apple.eawt.quitStrategy", "CLOSE_ALL_WINDOWS");
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (Dugan_Control_Panel.this.m_duganUI != null) {
                    Preferences prefs = Preferences.userRoot().node("/com/dugan/DuganCP");
                    prefs.put("Manual IPs", Dugan_Control_Panel.this.m_duganUI.getManuallyAddedIP());
                    prefs.put("Allow Search", String.format("%s", Dugan_Control_Panel.this.m_duganUI.isAllowSearch() ? "1" : "0"));
                    System.out.println("Settings saved!");
                    Dugan_Control_Panel.this.m_duganUI.Exit();
                }
                Dugan_Control_Panel.this.dispose();
                System.exit(0);
            }
        });
    }

    public void SetFrameHeight(int extension) {
        String os = System.getProperty("os.name").toLowerCase();
        boolean isMac = os.indexOf("mac") >= 0;
        Rectangle rect = this.getBounds();
        Dimension size = this.getMinimumSize();
        rect.height = isMac ? 746 + extension : 774 + extension;
        size.height = rect.height;
        this.setMinimumSize(size);
        this.setBounds(rect);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Dugan Automatic Mixing Controller");
        this.setBackground(new Color(0, 0, 0));
        this.setBounds(new Rectangle(0, 22, 1026, 758));
        this.setMinimumSize(new Dimension(1026, 762));
        this.setSize(new Dimension(1026, 780));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 987, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 552, Short.MAX_VALUE));
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String os = System.getProperty("os.name").toLowerCase();
                boolean isMac = os.indexOf("mac") >= 0;
                Dugan_Control_Panel frame = new Dugan_Control_Panel();
                if (isMac) {
                    frame.setBounds(10, 10, 1030, 746);
                } else {
                    frame.setBounds(10, 10, 1042, 774);
                }
                URL imgURL = Channel.class.getResource("/DuganCP/Images/logo.png");
                if (imgURL != null) {
                    ImageIcon icon = new ImageIcon(imgURL);
                    if (isMac) {
                        Application macApp = Application.getApplication();
                        macApp.setDockIconImage(icon.getImage());
                    } else {
                        frame.setIconImage(icon.getImage());
                    }
                }
                frame.setVisible(true);
            }
        });
    }
}

