/*
 * Decompiled with CFR 0.152.
 */
package Dugan_Utility;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class Dugan_Utility
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static final String MODEL_E_UCC = "V2.3";
    public static final int MODEL_E_UCC_Version = 230;
    public static final String MODEL_E_DSP = "V1.7";
    public static final int MODEL_E_DSP_Version = 170;
    public static final String MODEL_E1_UCC = "V1.6";
    public static final int MODEL_E1_UCC_Version = 160;
    public static final String MODEL_E1_DSP = "V1.7";
    public static final int MODEL_E1_DSP_Version = 170;
    public static final String MODEL_MY_UCC = "FW V1.15";
    public static final int MODEL_MY_UCC_Version = 115;
    public static final int MODEL_MY_UCC_OLD = 108;
    public static final String MODEL_MY_LCA = "FP V1.5";
    public static final int MODEL_MY_LCA_Version = 150;
    public static final int MODEL_MY_LCA_OLD = 130;
    public static final String MODEL_E1A_UCC = "FW V3.22";
    public static final int MODEL_E1A_UCC_Version = 322;
    public static final String MODEL_E1A_LCA = "FP V3.3";
    public static final int MODEL_E1A_LCA_Version = 330;
    public static final String MODEL_E2_UCC = "FW V1.09";
    public static final int MODEL_E2_UCC_Version = 109;
    public static final String MODEL_E2_LCA = "FP V0.1";
    public static final int MODEL_E2_LCA_Version = 10;
    public static final boolean MODEL_E2_RESET = true;
    public static final String MODEL_E2A_UCC = "FW V1.04";
    public static final int MODEL_E2A_UCC_Version = 104;
    public static final String MODEL_E2A_LCA = "FP V0.4";
    public static final int MODEL_E2A_LCA_Version = 40;
    public static final boolean MODEL_E2A_RESET = false;
    public static final String MODEL_E3_UCC = "FW V1.17";
    public static final int MODEL_E3_UCC_Version = 117;
    public static final String MODEL_E3_LCA = "FP V0.7";
    public static final int MODEL_E3_LCA_Version = 60;
    public static final boolean MODEL_E3_RESET = false;
    public static final String MODEL_E3A_UCC = "FW V1.14";
    public static final int MODEL_E3A_UCC_Version = 114;
    public static final String MODEL_E3A_LCA = "FP V0.8";
    public static final int MODEL_E3A_LCA_Version = 80;
    public static final boolean MODEL_E3A_RESET = false;
    public static final String MODEL_VN_UCC = "FW V1.03";
    public static final int MODEL_VN_UCC_Version = 103;
    public static final String MODEL_VN_LCA = "FP V1.4";
    public static final int MODEL_VN_LCA_Version = 140;
    public static final String MODEL_K_UCC = "FW V0.60";
    public static final int MODEL_K_UCC_Version = 60;
    public static final boolean MODEL_K_RESET = false;
    public static final String MODEL_M_UCC = "FW V1.16";
    public static final int MODEL_M_UCC_Version = 116;
    public static final String MODEL_M_LCA = "FP V0.80";
    public static final int MODEL_M_LCA_Version = 80;
    public static final boolean MODEL_M_RESET = false;
    public static final String MODEL_N_UCC = "FW V1.18";
    public static final int MODEL_N_UCC_Version = 118;
    public static final String MODEL_N_LCA = "FP V0.70";
    public static final int MODEL_N_LCA_Version = 70;
    public static final boolean MODEL_N_RESET = false;
    public static final String MODEL_E_UCC_FIRMWARE = "dugane_v230.hex";
    public static final String MODEL_E_DSP_FIRMWARE = "dugane_v170.ldr";
    public static final String MODEL_E1_UCC_FIRMWARE = "dugane1_v160.hex";
    public static final String MODEL_E1_DSP_FIRMWARE = "dugane_v170.ldr";
    public static final String MODEL_MY_UCC_FIRMWARE = "duganmy_v115.dli";
    public static final String MODEL_MY_LCA_FIRMWARE_V13 = "duganmy_v13.bin";
    public static final String MODEL_MY_LCA_FIRMWARE = "duganmy_v15.bin";
    public static final String MODEL_E1A_UCC_FIRMWARE = "pn10137_v322.dli";
    public static final String MODEL_E1A_LCA_FIRMWARE = "pn10137_v33.bin";
    public static final String MODEL_E2_UCC_FIRMWARE = "pn10262_v109.dli";
    public static final String MODEL_E2_LCA_FIRMWARE = "pn10262_v01.bin";
    public static final String MODEL_E2A_UCC_FIRMWARE = "ModelE2A_v104.dli";
    public static final String MODEL_E2A_LCA_FIRMWARE = "ModelE2A_fpga_v040.bin";
    public static final String MODEL_E3_UCC_FIRMWARE = "pn10255_v117.dli";
    public static final String MODEL_E3_LCA_FIRMWARE = "pn10255_v07_crc.bin";
    public static final String MODEL_E3A_UCC_FIRMWARE = "ModelE3A_v114.dli";
    public static final String MODEL_E3A_LCA_FIRMWARE = "ModelE3A_fpga_v080.bin";
    public static final String MODEL_VN_UCC_FIRMWARE = "pn10256_v103.dli";
    public static final String MODEL_VN_LCA_FIRMWARE = "pn10256_v14_crc.bin";
    public static final String MODEL_K_UCC_FIRMWARE = "pn10272_v060.dli";
    public static final String MODEL_M_UCC_FIRMWARE = "pn10275_v115.dli";
    public static final String MODEL_M_LCA_FIRMWARE = "pn10275_crc_v08.bin";
    public static final String MODEL_N_UCC_FIRMWARE = "pn10282_v118.dli";
    public static final String MODEL_N_LCA_FIRMWARE = "pn10282_crc_v07.bin";
    public static final String MODEL_E_WEB = "dugane_v150.wdl";
    public static final String MODEL_E1_WEB = "dugane_v150.wdl";
    public static final String MODEL_E1_WEB_NEW = "dugane_v150.wdl";
    public static final String MODEL_MY_WEB_INDEX = "duganmy_v200/index.htm";
    public static final String MODEL_MY_WEB_JAR = "duganmy_v200/DuganCP.jar";
    public static final String MODEL_MY_WEB_ICO = "duganmy_v200/favicon.ico";
    public static final String title = "Dugan Automatic Mixing Controller Utility - September 6, 2019";
    public static final int DUGAN_PORT = 9776;
    public static final int MODEL_E = 1;
    public static final int MODEL_D2 = 2;
    public static final int MODEL_D3 = 3;
    public static final int MODEL_E1 = 4;
    public static final int MODEL_MY = 5;
    public static final int MODEL_E1A = 6;
    public static final int MODEL_E2 = 7;
    public static final int MODEL_E3 = 8;
    public static final int MODEL_VN = 9;
    public static final int MODEL_K = 10;
    public static final int MODEL_M = 11;
    public static final int MODEL_N = 12;
    public static final int MODEL_E2A = 13;
    public static final int MODEL_E3A = 14;
    public static final int BLOCK_SIZE = 512;
    private static final int WEB_START_PAGE = 256;
    private static final int SDF_PAGE_SIZE = 264;
    private static final int STATIC_IP_REBOOT_WAIT = 30;
    private static final int DHCP_REBOOT_WAIT = 180;
    private DatagramSocket querySocket;
    private DatagramPacket rcvrPacket;
    private ActionListener queryTask;
    private Timer queryTimer;
    private ArrayList<DatagramPacket> devices;
    private DefaultListModel<String> listModel;
    private String m_pcAddresses;
    private InetAddress[] m_localAddresses;
    private InetAddress[] m_broadcastAddresses;
    private int m_nIFAddress = 0;
    private boolean oldCmdSet = false;
    private boolean forcedUpdate = false;
    private boolean updating = false;
    private boolean allowReadSocket = true;
    private String ftpErrorMsg = "";
    private String currentMac = "";
    private String currentFWVersion = "";
    private String currentFPVersion = "";
    private int currentDevType = 0;
    private String currentHardwareRevision = "";
    private String currentSerialNumber = "";
    private String returnedWD;
    private String returnedFS;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JButton m_addUnit;
    private JButton m_exit;
    private JLabel m_localIP;
    private JButton m_moreInfo;
    private JPanel m_networkPanel;
    private JLabel m_progress;
    private JButton m_refreshList;
    private JTextField m_unitGateway;
    private JTextField m_unitIP;
    private JList<String> m_unitList;
    private JTextField m_unitNetmask;
    private JLabel m_unitReachable;
    private JCheckBox m_unitUseDHCP;
    private JButton m_updateFirmware;
    private JButton m_updateParams;
    private JButton m_updateWebUI;

    public int GetVersion(String sversion) {
        int i = 0;
        while (!Character.isDigit(sversion.charAt(i))) {
            ++i;
        }
        int version = i >= sversion.length() ? 0 : Math.round(Float.parseFloat(sversion.substring(i)) * 100.0f);
        if (version == 2550) {
            version = 0;
        }
        return version;
    }

    public Dugan_Utility() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.initComponents();
        String os = System.getProperty("os.name").toLowerCase();
        boolean isMac = os.contains("mac");
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/Dugan_Utility/DD_app_512x512.png"));
        if (isMac) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Dugan CP-J");
        } else {
            this.setIconImage(icon.getImage());
        }
        this.setTitle(title);
        this.m_updateWebUI.setVisible(false);
        this.m_updateWebUI.setEnabled(false);
        this.m_updateParams.setEnabled(false);
        this.m_updateFirmware.setEnabled(false);
        this.listModel = new DefaultListModel();
        this.m_unitList.setModel(this.listModel);
        this.devices = new ArrayList();
        this.GetLocalAddresses();
        try {
            this.querySocket = new DatagramSocket(0);
            this.querySocket.setSoTimeout(1);
        }
        catch (SocketException ex) {
            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.rcvrPacket = new DatagramPacket(new byte[1536], 1536);
        this.queryTask = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (Dugan_Utility.this.allowReadSocket) {
                    Dugan_Utility.this.ReadSocket(1);
                }
            }
        };
        this.queryTimer = new Timer(50, this.queryTask);
        this.queryTimer.start();
        this.ScanIt(null);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.m_unitList = new JList();
        this.m_refreshList = new JButton();
        this.m_updateFirmware = new JButton();
        this.m_networkPanel = new JPanel();
        this.m_updateParams = new JButton();
        this.m_unitIP = new JTextField();
        this.jLabel1 = new JLabel();
        this.m_unitNetmask = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.m_unitGateway = new JTextField();
        this.m_unitUseDHCP = new JCheckBox();
        this.m_unitReachable = new JLabel();
        this.m_exit = new JButton();
        this.m_moreInfo = new JButton();
        this.m_updateWebUI = new JButton();
        this.m_addUnit = new JButton();
        this.m_progress = new JLabel();
        this.jLabel4 = new JLabel();
        this.m_localIP = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Dugan Mixer Firmware Update");
        this.setMinimumSize(new Dimension(636, 450));
        this.setPreferredSize(new Dimension(636, 460));
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.m_unitList.setFont(new Font("Tahoma", 0, 12));
        this.m_unitList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                Dugan_Utility.this.m_unitListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.m_unitList);
        this.getContentPane().add(this.jScrollPane1);
        this.jScrollPane1.setBounds(10, 21, 480, 202);
        this.m_refreshList.setFont(new Font("Tahoma", 0, 12));
        this.m_refreshList.setText("<html>\n<center>\nRefresh<br />List\n</center>\n</html>");
        this.m_refreshList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Dugan_Utility.this.m_refreshListActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.m_refreshList);
        this.m_refreshList.setBounds(500, 20, 118, 48);
        this.m_updateFirmware.setFont(new Font("Tahoma", 0, 12));
        this.m_updateFirmware.setText("<html>\n<center>\nUpdate<br />\nFirmware\n</center>\n</html>");
        this.m_updateFirmware.setToolTipText("Use Ctrl-Click to force an update.");
        this.m_updateFirmware.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Dugan_Utility.this.m_updateFirmwareMouseClicked(evt);
            }
        });
        this.m_updateFirmware.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Dugan_Utility.this.m_updateFirmwareActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.m_updateFirmware);
        this.m_updateFirmware.setBounds(502, 123, 118, 48);
        this.m_networkPanel.setBorder(BorderFactory.createTitledBorder(null, "Network Parameters", 2, 0, new Font("Tahoma", 0, 12)));
        this.m_networkPanel.setLayout(null);
        this.m_updateParams.setFont(new Font("Tahoma", 0, 12));
        this.m_updateParams.setText("<html>\n<center>\nSend New<br />\nParams To Unit\n</center>\n</html>");
        this.m_updateParams.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Dugan_Utility.this.m_updateParamsActionPerformed(evt);
            }
        });
        this.m_networkPanel.add(this.m_updateParams);
        this.m_updateParams.setBounds(469, 71, 127, 40);
        this.m_unitIP.setHorizontalAlignment(0);
        this.m_unitIP.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Dugan_Utility.this.m_unitIPKeyReleased(evt);
            }
        });
        this.m_networkPanel.add(this.m_unitIP);
        this.m_unitIP.setBounds(85, 31, 119, 30);
        this.jLabel1.setFont(new Font("Tahoma", 0, 12));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("IP Address:");
        this.m_networkPanel.add(this.jLabel1);
        this.jLabel1.setBounds(5, 41, 70, 15);
        this.m_unitNetmask.setHorizontalAlignment(0);
        this.m_unitNetmask.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                Dugan_Utility.this.m_unitNetmaskKeyTyped(evt);
            }
        });
        this.m_networkPanel.add(this.m_unitNetmask);
        this.m_unitNetmask.setBounds(289, 32, 116, 30);
        this.jLabel2.setFont(new Font("Tahoma", 0, 12));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Netmask:");
        this.m_networkPanel.add(this.jLabel2);
        this.jLabel2.setBounds(219, 42, 60, 15);
        this.jLabel3.setFont(new Font("Tahoma", 0, 12));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Gateway:");
        this.m_networkPanel.add(this.jLabel3);
        this.jLabel3.setBounds(404, 41, 70, 15);
        this.m_unitGateway.setHorizontalAlignment(0);
        this.m_unitGateway.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Dugan_Utility.this.m_unitGatewayKeyReleased(evt);
            }
        });
        this.m_networkPanel.add(this.m_unitGateway);
        this.m_unitGateway.setBounds(484, 31, 112, 30);
        this.m_unitUseDHCP.setFont(new Font("Tahoma", 0, 12));
        this.m_unitUseDHCP.setSelected(true);
        this.m_unitUseDHCP.setText("Use DHCP:");
        this.m_unitUseDHCP.setHorizontalTextPosition(2);
        this.m_unitUseDHCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Dugan_Utility.this.m_unitUseDHCPActionPerformed(evt);
            }
        });
        this.m_networkPanel.add(this.m_unitUseDHCP);
        this.m_unitUseDHCP.setBounds(30, 70, 90, 23);
        this.m_unitReachable.setFont(new Font("Tahoma", 0, 12));
        this.m_unitReachable.setText("Unit Reachable: Yes");
        this.m_networkPanel.add(this.m_unitReachable);
        this.m_unitReachable.setBounds(150, 70, 130, 20);
        this.getContentPane().add(this.m_networkPanel);
        this.m_networkPanel.setBounds(8, 235, 610, 122);
        this.m_exit.setFont(new Font("Tahoma", 0, 12));
        this.m_exit.setText("EXIT");
        this.m_exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Dugan_Utility.this.m_exitActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.m_exit);
        this.m_exit.setBounds(507, 397, 90, 30);
        this.m_moreInfo.setFont(new Font("Tahoma", 0, 12));
        this.m_moreInfo.setText("<html> <center> More <br /> Info </center> </html>");
        this.m_moreInfo.setToolTipText("Use Ctrl-Click to force an update.");
        this.m_moreInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Dugan_Utility.this.m_moreInfoActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.m_moreInfo);
        this.m_moreInfo.setBounds(502, 175, 118, 48);
        this.m_updateWebUI.setFont(new Font("Tahoma", 0, 12));
        this.m_updateWebUI.setText("<html>\n<center>\nStore CP-J<br />\nTo Unit\n</center>\n</html>");
        this.m_updateWebUI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Dugan_Utility.this.m_updateWebUIActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.m_updateWebUI);
        this.m_updateWebUI.setBounds(501, 150, 118, 55);
        this.m_addUnit.setFont(new Font("Tahoma", 0, 12));
        this.m_addUnit.setText("<html>\n<center>\nManually<br />\nAdd Unit\n</center>\n</html>");
        this.m_addUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Dugan_Utility.this.m_addUnitActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.m_addUnit);
        this.m_addUnit.setBounds(501, 71, 118, 48);
        this.m_progress.setFont(new Font("Tahoma", 0, 14));
        this.m_progress.setText("Ready");
        this.getContentPane().add(this.m_progress);
        this.m_progress.setBounds(14, 397, 463, 22);
        this.jLabel4.setFont(new Font("Tahoma", 0, 12));
        this.jLabel4.setText("This Computer's IP Address:");
        this.getContentPane().add(this.jLabel4);
        this.jLabel4.setBounds(14, 364, 162, 30);
        this.m_localIP.setFont(new Font("Tahoma", 0, 12));
        this.getContentPane().add(this.m_localIP);
        this.m_localIP.setBounds(172, 364, 422, 30);
        this.pack();
    }

    private void m_refreshListActionPerformed(ActionEvent evt) {
        this.ScanIt(null);
    }

    private void m_updateFirmwareActionPerformed(ActionEvent evt) {
        if (this.updating) {
            return;
        }
        this.updating = true;
        this.forcedUpdate = (evt.getModifiers() & 0x80) == 128;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Dugan_Utility.this.allowReadSocket = false;
                Dugan_Utility.this.DoFirmwareUpdate();
                Dugan_Utility.this.allowReadSocket = true;
            }
        });
        thread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void DoFirmwareUpdate() {
        block314: {
            boolean needReboot;
            int devType;
            String[] strs;
            int rebootWait;
            DatagramPacket pkt;
            boolean forced;
            block313: {
                forced = this.forcedUpdate;
                int which = this.m_unitList.getSelectedIndex();
                if (which == -1) {
                    JOptionPane.showMessageDialog(this, "Please select an online unit first!");
                    this.updating = false;
                    return;
                }
                pkt = this.devices.get(which);
                if (pkt == null) {
                    this.updating = false;
                    return;
                }
                if (!this.IsReachable(pkt)) {
                    JOptionPane.showMessageDialog(this, "Unit is not reachable. Firmware update aborted.");
                    this.updating = false;
                    return;
                }
                if (this.m_unitUseDHCP.isSelected()) {
                    rebootWait = 180;
                    if (JOptionPane.showConfirmDialog(this, "<html>It is not recommended to perform firmware update in DHCP mode. If a DHCP server is not available, <br>you may experience lengthy IP address acquisition delay between the update processes.<br>If you get a failed to reboot message, please switch to static IP mode and try again.<br>Proceed anyway?</html>", "Firmware Update DHCP Warning", 0, 3) == 1) {
                        this.updating = false;
                        return;
                    }
                } else {
                    rebootWait = 30;
                    if (JOptionPane.showConfirmDialog(this, "Proceed to update firmware?", "Firmware Update Confirmation", 0, 3) == 1) {
                        this.updating = false;
                        return;
                    }
                }
                byte[] inbuf = pkt.getData();
                String inStr = new String(inbuf).trim();
                strs = inStr.split(",");
                devType = Integer.parseInt(strs[0]);
                needReboot = false;
                if (strs.length != 8) break block313;
                if (devType == 1) {
                    if (forced || this.GetVersion(strs[3]) < 170) {
                        try {
                            try {
                                this.m_progress.setText("Updating DSP firmware ...");
                                this.setCursor(Cursor.getPredefinedCursor(3));
                                this.DownloadToSDF(pkt.getAddress(), "dugane_v170.ldr", Cmd.DLP_DSP, false);
                                needReboot = true;
                            }
                            catch (IOException ex) {
                                JOptionPane.showMessageDialog(this, String.format("Download DSP firmware failed. Err: %s", ex.getMessage()));
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                                this.updating = false;
                                this.setCursor(Cursor.getDefaultCursor());
                                this.m_progress.setText("Ready");
                                return;
                            }
                        }
                        finally {
                            this.setCursor(Cursor.getDefaultCursor());
                            this.m_progress.setText("Ready");
                        }
                    }
                    if (forced || this.GetVersion(strs[2]) < 230) {
                        try {
                            try {
                                this.m_progress.setText("Updating microcontroller firmware ...");
                                this.setCursor(Cursor.getPredefinedCursor(3));
                                this.DownloadToUCC(pkt.getAddress(), MODEL_E_UCC_FIRMWARE, 1);
                                this.m_progress.setText("Rebooting ...");
                                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                                }
                                needReboot = false;
                            }
                            catch (IOException ex) {
                                JOptionPane.showMessageDialog(this, String.format("Download firmware failed. Err: %s", ex.getMessage()));
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                                this.updating = false;
                                this.setCursor(Cursor.getDefaultCursor());
                                this.m_progress.setText("Ready");
                                return;
                            }
                        }
                        finally {
                            this.setCursor(Cursor.getDefaultCursor());
                            this.m_progress.setText("Ready");
                        }
                    }
                    try {
                        try {
                            this.m_progress.setText("Updating control panel web pages ...");
                            this.setCursor(Cursor.getPredefinedCursor(3));
                            this.ProgramSDF(pkt.getAddress(), "dugane_v150.wdl", 256, false);
                            needReboot = true;
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(this, String.format("Download Control Panel Interface file failed. Err: %s", ex.getMessage()));
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            this.updating = false;
                            this.setCursor(Cursor.getDefaultCursor());
                            this.m_progress.setText("Ready");
                            return;
                        }
                    }
                    finally {
                        this.setCursor(Cursor.getDefaultCursor());
                        this.m_progress.setText("Ready");
                    }
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (needReboot) {
                        this.m_progress.setText("Rebooting ...");
                        this.Reboot(pkt.getAddress());
                    }
                    if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                        JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                    }
                    this.ScanIt(null);
                    this.setCursor(Cursor.getDefaultCursor());
                    this.m_progress.setText("Ready");
                    break block314;
                } else {
                    if (devType != 4) {
                        JOptionPane.showMessageDialog(this, "Unknown device type!");
                        this.updating = false;
                        return;
                    }
                    try {
                        try {
                            this.m_progress.setText("Updating contorl panel web pages ...");
                            this.setCursor(Cursor.getPredefinedCursor(3));
                            this.ProgramSDF(pkt.getAddress(), "dugane_v150.wdl", 256, false);
                            needReboot = true;
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(this, String.format("Download Control Panel Interface file failed. Err: %s", ex.getMessage()));
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            this.updating = false;
                            this.setCursor(Cursor.getDefaultCursor());
                            this.m_progress.setText("Ready");
                            return;
                        }
                    }
                    finally {
                        this.setCursor(Cursor.getDefaultCursor());
                        this.m_progress.setText("Ready");
                    }
                    if (forced || this.GetVersion(strs[3]) < 170) {
                        try {
                            try {
                                this.m_progress.setText("Updating DSP firmware ...");
                                this.setCursor(Cursor.getPredefinedCursor(3));
                                this.DownloadToSDF(pkt.getAddress(), "dugane_v170.ldr", Cmd.DLP_DSP, false);
                                needReboot = true;
                            }
                            catch (IOException ex) {
                                JOptionPane.showMessageDialog(this, String.format("Download DSP firmware failed. Err: %s", ex.getMessage()));
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                                this.updating = false;
                                this.setCursor(Cursor.getDefaultCursor());
                                this.m_progress.setText("Ready");
                                return;
                            }
                        }
                        finally {
                            this.setCursor(Cursor.getDefaultCursor());
                            this.m_progress.setText("Ready");
                        }
                    }
                    if (forced || this.GetVersion(strs[2]) < 160) {
                        try {
                            try {
                                this.m_progress.setText("Updating microcontroller firmware ...");
                                this.setCursor(Cursor.getPredefinedCursor(3));
                                this.DownloadToUCC(pkt.getAddress(), MODEL_E1_UCC_FIRMWARE, 4);
                                needReboot = false;
                            }
                            catch (IOException ex) {
                                JOptionPane.showMessageDialog(this, String.format("Download firmware failed. Err: %s", ex.getMessage()));
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                                this.updating = false;
                                this.setCursor(Cursor.getDefaultCursor());
                                this.m_progress.setText("Rebooting");
                                return;
                            }
                        }
                        finally {
                            this.setCursor(Cursor.getDefaultCursor());
                            this.m_progress.setText("Rebooting");
                        }
                    }
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (needReboot) {
                        this.m_progress.setText("Rebooting ...");
                        this.Reboot(pkt.getAddress());
                    }
                    if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                        JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                    }
                    this.ScanIt(null);
                    this.setCursor(Cursor.getDefaultCursor());
                    this.m_progress.setText("Ready");
                }
                break block314;
            }
            if (strs.length < 11) {
                JOptionPane.showMessageDialog(this, "Selected unit has wrong network info!");
                this.updating = false;
                return;
            }
            if (devType == 6) {
                int ret;
                this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                if (forced || this.GetVersion(strs[3]) < 322) {
                    this.m_progress.setText("Updating microntroller firmware ...");
                    this.m_progress.updateUI();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_E1A_UCC_FIRMWARE, 1, forced ? "RFMT" : "DELE firmware.old", "FLSH", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_E1A_UCC_FIRMWARE, 1, "RFMT", "FLSH", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_E1A_UCC_FIRMWARE, 1, "RFMT", "FLSH", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update processor firmware!");
                            }
                        }
                    }
                    this.m_progress.setText("Rebooting ...");
                    needReboot = false;
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.m_progress.setText("Ready");
                if (forced || this.GetVersion(strs[4]) < 330) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating FPGA firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_E1A_LCA_FIRMWARE, 1, "DELE fpga.old", "TLCA", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_E1A_LCA_FIRMWARE, 1, null, "TLCA", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_E1A_LCA_FIRMWARE, 1, null, "TLCA", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update FPGA firmware!");
                            }
                        }
                    }
                    needReboot = true;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (needReboot) {
                    this.m_progress.setText("Rebooting ...");
                    this.Reboot(pkt.getAddress());
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.ScanIt(null);
                this.setCursor(Cursor.getDefaultCursor());
                this.m_progress.setText("Ready");
            } else if (devType == 5) {
                int ret;
                boolean oldMYFirmware = this.GetVersion(strs[3]) <= 108;
                boolean bl = forced = forced || oldMYFirmware;
                if (forced || this.GetVersion(strs[3]) < 115) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating microcontroller firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_MY_UCC_FIRMWARE, 1, forced ? "RFMT" : "DELE firmware.old", "FLSH", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_MY_UCC_FIRMWARE, 1, "RFMT", "FLSH", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_MY_UCC_FIRMWARE, 1, "RFMT", "FLSH", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update processor firmware!");
                            }
                        }
                    }
                    needReboot = false;
                    this.m_progress.setText("Rebooting ...");
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.m_progress.setText("Ready");
                if (forced || this.GetVersion(strs[4]) < 150) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating FPGA firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_MY_LCA_FIRMWARE, 1, "DELE fpga.old", "TLCA", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_MY_LCA_FIRMWARE, 1, null, "TLCA", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_MY_LCA_FIRMWARE, 1, null, "TLCA", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update FPGA firmware!");
                            }
                        }
                    }
                    needReboot = true;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (needReboot) {
                    this.m_progress.setText("Rebooting ...");
                    this.Reboot(pkt.getAddress());
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.ScanIt(null);
                this.setCursor(Cursor.getDefaultCursor());
                this.m_progress.setText("Ready");
            } else if (devType == 9) {
                int ret;
                if (forced || this.GetVersion(strs[3]) < 103) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating microcontroller firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_VN_UCC_FIRMWARE, 1, forced ? "RFMT" : "DELE firmware.old", "FLSH", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_VN_UCC_FIRMWARE, 1, "RFMT", "FLSH", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_VN_UCC_FIRMWARE, 1, "RFMT", "FLSH", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update processor firmware!");
                            }
                        }
                    }
                    needReboot = false;
                    this.m_progress.setText("Rebooting ...");
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.m_progress.setText("Ready");
                if (forced || this.GetVersion(strs[4]) < 140) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating FPGA firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_VN_LCA_FIRMWARE, 1, "DELE fpga.old", "TLCA", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_VN_LCA_FIRMWARE, 1, null, "TLCA", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_VN_LCA_FIRMWARE, 1, null, "TLCA", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update FPGA firmware!");
                            }
                        }
                    }
                    needReboot = true;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (needReboot) {
                    this.m_progress.setText("Rebooting ...");
                    this.Reboot(pkt.getAddress());
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.ScanIt(null);
                this.setCursor(Cursor.getDefaultCursor());
                this.m_progress.setText("Ready");
            } else if (devType == 8) {
                int ret;
                if (forced || this.GetVersion(strs[3]) < 117) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating microcontroller firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_E3_UCC_FIRMWARE, 1, forced ? "RFMT" : "DELE firmware.old", "FLSH", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_E3_UCC_FIRMWARE, 1, "RFMT", "FLSH", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_E3_UCC_FIRMWARE, 1, "RFMT", "FLSH", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update processor firmware!");
                            }
                        }
                    }
                    needReboot = false;
                    this.m_progress.setText("Rebooting ...");
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.m_progress.setText("Ready");
                if (forced || this.GetVersion(strs[4]) < 60) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating FPGA firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_E3_LCA_FIRMWARE, 1, "DELE fpga.old", "TLCA", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_E3_LCA_FIRMWARE, 1, null, "TLCA", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_E3_LCA_FIRMWARE, 1, null, "TLCA", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update FPGA firmware!");
                            }
                        }
                    }
                    needReboot = true;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (needReboot) {
                    this.m_progress.setText("Rebooting ...");
                    this.Reboot(pkt.getAddress());
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.ScanIt(null);
                this.setCursor(Cursor.getDefaultCursor());
                this.m_progress.setText("Ready");
            } else if (devType == 14) {
                int ret;
                if (forced || this.GetVersion(strs[3]) < 114) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating microcontroller firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_E3A_UCC_FIRMWARE, 1, forced ? "RFMT" : "DELE firmware.old", "FLSH", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_E3A_UCC_FIRMWARE, 1, "RFMT", "FLSH", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_E3A_UCC_FIRMWARE, 1, "RFMT", "FLSH", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update processor firmware!");
                            }
                        }
                    }
                    needReboot = false;
                    this.m_progress.setText("Rebooting ...");
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.m_progress.setText("Ready");
                if (forced || this.GetVersion(strs[4]) < 80) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating FPGA firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_E3A_LCA_FIRMWARE, 1, "DELE fpga.old", "TLCA", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_E3A_LCA_FIRMWARE, 1, null, "TLCA", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_E3A_LCA_FIRMWARE, 1, null, "TLCA", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update FPGA firmware!");
                            }
                        }
                    }
                    needReboot = true;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (needReboot) {
                    this.m_progress.setText("Rebooting ...");
                    this.Reboot(pkt.getAddress());
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.ScanIt(null);
                this.setCursor(Cursor.getDefaultCursor());
                this.m_progress.setText("Ready");
            } else if (devType == 7) {
                int ret;
                if (forced || this.GetVersion(strs[3]) < 109) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating microcontroller firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_E2_UCC_FIRMWARE, 1, forced ? "RFMT" : "DELE firmware.old", "FLSH", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_E2_UCC_FIRMWARE, 1, "RFMT", "FLSH", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_E2_UCC_FIRMWARE, 1, "RFMT", "FLSH", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update processor firmware!");
                            }
                        }
                    }
                    needReboot = false;
                    this.m_progress.setText("Rebooting ...");
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                } else {
                    this.SendCmd(pkt.getAddress(), "FP\r\n", Cmd.FP, 100, 3);
                }
                this.m_progress.setText("Ready");
                if (forced || this.GetVersion(strs[4]) < 10) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating FPGA firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_E2_LCA_FIRMWARE, 1, "DELE fpga.old", "TLCA", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_E2_LCA_FIRMWARE, 1, null, "TLCA", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_E2_LCA_FIRMWARE, 1, null, "TLCA", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update FPGA firmware!");
                            }
                        }
                    }
                    needReboot = true;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (needReboot) {
                    this.m_progress.setText("Rebooting ...");
                    this.Reboot(pkt.getAddress());
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.ScanIt(null);
                this.setCursor(Cursor.getDefaultCursor());
                this.m_progress.setText("Ready");
            } else if (devType == 13) {
                int ret;
                if (forced || this.GetVersion(strs[3]) < 104) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating microcontroller firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_E2A_UCC_FIRMWARE, 1, forced ? "RFMT" : "DELE firmware.old", "FLSH", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_E2A_UCC_FIRMWARE, 1, "RFMT", "FLSH", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_E2A_UCC_FIRMWARE, 1, "RFMT", "FLSH", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update processor firmware!");
                            }
                        }
                    }
                    needReboot = false;
                    this.m_progress.setText("Rebooting ...");
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.m_progress.setText("Ready");
                if (forced || this.GetVersion(strs[4]) < 40) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating FPGA firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_E2A_LCA_FIRMWARE, 1, "DELE fpga.old", "TLCA", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_E2A_LCA_FIRMWARE, 1, null, "TLCA", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_E2A_LCA_FIRMWARE, 1, null, "TLCA", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update FPGA firmware!");
                            }
                        }
                    }
                    needReboot = true;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (needReboot) {
                    this.m_progress.setText("Rebooting ...");
                    this.Reboot(pkt.getAddress());
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.ScanIt(null);
                this.setCursor(Cursor.getDefaultCursor());
                this.m_progress.setText("Ready");
            } else if (devType == 11) {
                int ret;
                if (forced || this.GetVersion(strs[3]) < 116) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating microcontroller firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_M_UCC_FIRMWARE, 1, forced ? "RFMT" : "DELE firmware.old", "FLSH", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_M_UCC_FIRMWARE, 1, "RFMT", "FLSH", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_M_UCC_FIRMWARE, 1, "RFMT", "FLSH", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update processor firmware!");
                            }
                        }
                    }
                    needReboot = false;
                    this.m_progress.setText("Rebooting ...");
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.m_progress.setText("Ready");
                if (forced || this.GetVersion(strs[4]) < 80) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating FPGA firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_M_LCA_FIRMWARE, 1, "DELE fpga.old", "TLCA", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_M_LCA_FIRMWARE, 1, null, "TLCA", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_M_LCA_FIRMWARE, 1, null, "TLCA", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update FPGA firmware!");
                            }
                        }
                    }
                    needReboot = true;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (needReboot) {
                    this.m_progress.setText("Rebooting ...");
                    this.Reboot(pkt.getAddress());
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.ScanIt(null);
                this.setCursor(Cursor.getDefaultCursor());
                this.m_progress.setText("Ready");
            } else if (devType == 12) {
                int ret;
                if (forced || this.GetVersion(strs[3]) < 118) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating microcontroller firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_N_UCC_FIRMWARE, 1, forced ? "RFMT" : "DELE firmware.old", "FLSH", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_N_UCC_FIRMWARE, 1, "RFMT", "FLSH", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_N_UCC_FIRMWARE, 1, "RFMT", "FLSH", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update processor firmware!");
                            }
                        }
                    }
                    needReboot = false;
                    this.m_progress.setText("Rebooting ...");
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.m_progress.setText("Ready");
                if (forced || this.GetVersion(strs[4]) < 70) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating FPGA firmware ...");
                    ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_N_LCA_FIRMWARE, 1, "DELE fpga.old", "TLCA", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_N_LCA_FIRMWARE, 1, null, "TLCA", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/fpga.bin", MODEL_N_LCA_FIRMWARE, 1, null, "TLCA", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update FPGA firmware!");
                            }
                        }
                    }
                    needReboot = true;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (needReboot) {
                    this.m_progress.setText("Rebooting ...");
                    this.Reboot(pkt.getAddress());
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.ScanIt(null);
                this.setCursor(Cursor.getDefaultCursor());
                this.m_progress.setText("Ready");
            } else {
                if (devType != 10) {
                    JOptionPane.showMessageDialog(this, "Unknown device type!");
                    this.updating = false;
                    return;
                }
                if (forced || this.GetVersion(strs[3]) < 60) {
                    this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_progress.setText("Updating microcontroller firmware ...");
                    int ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_K_UCC_FIRMWARE, 1, forced ? "RFMT" : "DELE firmware.old", "FLSH", false);
                    if (ret != 0) {
                        if (ret == -1) {
                            this.setCursor(Cursor.getDefaultCursor());
                            JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                            this.m_progress.setText("Ready");
                            this.updating = false;
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_K_UCC_FIRMWARE, 1, "RFMT", "FLSH", false);
                        if (ret != 0) {
                            if (ret == -1) {
                                this.setCursor(Cursor.getDefaultCursor());
                                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                                this.m_progress.setText("Ready");
                                this.updating = false;
                                return;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            ret = this.FTPTransfer(pkt.getAddress(), "0:/firmware.dli", MODEL_K_UCC_FIRMWARE, 1, "RFMT", "FLSH", true);
                            if (ret != 0) {
                                JOptionPane.showMessageDialog(null, "Failed to update processor firmware!");
                            }
                        }
                    }
                    needReboot = false;
                    this.m_progress.setText("Rebooting ...");
                }
                if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, rebootWait)) {
                    JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
                }
                this.ScanIt(null);
                this.setCursor(Cursor.getDefaultCursor());
                this.m_progress.setText("Ready");
            }
            if (devType != 10) {
                this.m_progress.setText("Storing DuganCP-J to unit ...");
                this.UpdateNewWebPages(pkt);
            }
            this.m_progress.setText("Ready");
        }
        this.ScanIt(null);
        JOptionPane.showMessageDialog(this, "Firmware updated!");
        this.m_progress.setText("Ready");
        this.updating = false;
    }

    private void m_updateParamsActionPerformed(ActionEvent evt) {
        int which = this.m_unitList.getSelectedIndex();
        if (which == -1) {
            JOptionPane.showMessageDialog(this, "Please select an online unit first!");
            return;
        }
        DatagramPacket pkt = this.devices.get(which);
        if (pkt == null) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Proceed to change network parameters?", "Network Parameters Confirmation", 0, 3) == 1) {
            return;
        }
        byte[] inbuf = pkt.getData();
        String inStr = new String(inbuf).trim();
        String[] strs = inStr.split(",");
        int devType = Integer.parseInt(strs[0]);
        if (devType == 1 || devType == 4) {
            byte[] buf = new byte[64];
            byte[] ipb = null;
            byte[] nmb = null;
            byte[] gwb = null;
            String[] mac = strs.length == 8 ? strs[4].split(":") : strs[6].split("-");
            try {
                ipb = InetAddress.getByName(this.m_unitIP.getText()).getAddress();
                nmb = InetAddress.getByName(this.m_unitNetmask.getText()).getAddress();
                gwb = InetAddress.getByName(this.m_unitGateway.getText()).getAddress();
            }
            catch (UnknownHostException ex) {
                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
            }
            buf[0] = 110;
            buf[1] = 115;
            buf[2] = -69;
            buf[3] = 30;
            buf[4] = (byte)Integer.parseInt(mac[0], 16);
            buf[5] = (byte)Integer.parseInt(mac[1], 16);
            buf[6] = (byte)Integer.parseInt(mac[2], 16);
            buf[7] = (byte)Integer.parseInt(mac[3], 16);
            buf[8] = (byte)Integer.parseInt(mac[4], 16);
            buf[9] = (byte)Integer.parseInt(mac[5], 16);
            System.arraycopy(ipb, 0, buf, 10, 4);
            System.arraycopy(nmb, 0, buf, 14, 4);
            System.arraycopy(gwb, 0, buf, 18, 4);
            buf[22] = this.m_unitUseDHCP.isSelected() ? (byte)1 : 0;
            try {
                pkt = new DatagramPacket(buf, 23, InetAddress.getByName("255.255.255.255"), 9776);
                try {
                    this.querySocket.send(pkt);
                    JOptionPane.showMessageDialog(this, "Please wait for unit finshed rebooting and then click the Refresh button.");
                }
                catch (IOException ex) {
                    Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog(this, "Failed to send network parameters to unit!");
                }
            }
            catch (UnknownHostException ex) {
                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this, "Failed to send network parameters to unit!");
            }
        } else if (devType == 6 || devType == 5 || devType == 8 || devType == 14 || devType == 7 || devType == 13 || devType == 9 || devType == 10 || devType == 11 || devType == 12) {
            strs[0] = this.m_unitIP.getText().replace('.', ',');
            strs[6] = strs[6].replace('-', ',');
            strs[8] = this.m_unitNetmask.getText().replace('.', ',');
            strs[9] = this.m_unitGateway.getText().replace('.', ',');
            String cmd = "NC," + strs[6] + "," + (this.m_unitUseDHCP.isSelected() ? "1" : "0") + "," + strs[0] + "," + strs[8] + "," + strs[9] + "\r\n";
            this.BroadcastNC(cmd);
            this.ReadSocket(1);
            this.ScanIt(null);
            try {
                Thread.sleep(2000L);
                this.ScanIt(null);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Selected unit has an unknown model number!");
            return;
        }
    }

    private void m_exitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void m_unitListValueChanged(ListSelectionEvent evt) {
        int devType;
        int which = this.m_unitList.getSelectedIndex();
        if (which == -1) {
            return;
        }
        DatagramPacket pkt = this.devices.get(which);
        if (pkt == null) {
            return;
        }
        this.m_networkPanel.setVisible(true);
        this.m_updateWebUI.setEnabled(true);
        boolean reachable = this.IsReachable(pkt);
        if (reachable) {
            this.m_unitReachable.setText("Unit Reachable: YES");
        } else {
            this.m_unitReachable.setText("Unit Reachable: NO");
        }
        this.m_unitIP.setText(pkt.getAddress().getHostAddress());
        byte[] inbuf = pkt.getData();
        String inStr = new String(inbuf).trim();
        String[] strs = inStr.split(",");
        this.currentDevType = devType = Integer.parseInt(strs[0]);
        if (strs.length == 8) {
            this.oldCmdSet = true;
            this.m_unitNetmask.setText(strs[6]);
            this.m_unitGateway.setText(strs[7]);
            this.m_unitUseDHCP.setSelected(Integer.parseInt(strs[5]) != 0);
            this.currentFWVersion = "UCC Firmware " + strs[2];
            this.currentFPVersion = "DSP Firmware " + strs[3];
            this.currentMac = strs[4];
            if (devType == 1) {
                if (this.GetVersion(strs[2]) >= 230 && this.GetVersion(strs[3]) >= 170) {
                    this.m_updateFirmware.setEnabled(false);
                } else {
                    this.m_updateFirmware.setEnabled(reachable);
                }
            } else if (devType == 4) {
                if (this.GetVersion(strs[2]) >= 160 && this.GetVersion(strs[3]) >= 170) {
                    this.m_updateFirmware.setEnabled(false);
                } else {
                    this.m_updateFirmware.setEnabled(reachable);
                }
            }
        } else {
            this.m_unitNetmask.setText(strs[8]);
            this.m_unitGateway.setText(strs[9]);
            this.m_unitUseDHCP.setSelected(Integer.parseInt(strs[10]) != 0);
            this.currentFWVersion = "UCC Firmware  " + strs[3].substring(2);
            this.currentFPVersion = "FPGA Firmware " + strs[4].substring(2);
            this.currentMac = strs[6];
            this.currentHardwareRevision = "Hardware Rev. " + strs[5].substring(7);
            this.currentSerialNumber = strs[2];
            if (devType == 6) {
                this.oldCmdSet = false;
                if (this.GetVersion(strs[3]) >= 322 && this.GetVersion(strs[4]) >= 330) {
                    this.m_updateFirmware.setEnabled(false);
                } else {
                    this.m_updateFirmware.setEnabled(reachable);
                }
            } else if (devType == 5) {
                this.oldCmdSet = false;
                if (this.GetVersion(strs[3]) >= 115 && this.GetVersion(strs[4]) >= 150) {
                    this.m_updateFirmware.setEnabled(false);
                } else {
                    this.m_updateFirmware.setEnabled(reachable);
                }
            } else if (devType == 9) {
                this.oldCmdSet = false;
                if (this.GetVersion(strs[3]) >= 103 && this.GetVersion(strs[4]) >= 140) {
                    this.m_updateFirmware.setEnabled(false);
                } else {
                    this.m_updateFirmware.setEnabled(reachable);
                }
            } else if (devType == 7) {
                this.oldCmdSet = false;
                if (this.GetVersion(strs[3]) >= 109 && this.GetVersion(strs[4]) >= 10) {
                    this.m_updateFirmware.setEnabled(false);
                } else {
                    this.m_updateFirmware.setEnabled(reachable);
                }
            } else if (devType == 13) {
                this.oldCmdSet = false;
                if (this.GetVersion(strs[3]) >= 104 && this.GetVersion(strs[4]) >= 40) {
                    this.m_updateFirmware.setEnabled(false);
                } else {
                    this.m_updateFirmware.setEnabled(reachable);
                }
            } else if (devType == 8) {
                this.oldCmdSet = false;
                if (this.GetVersion(strs[3]) >= 117 && this.GetVersion(strs[4]) >= 60) {
                    this.m_updateFirmware.setEnabled(false);
                } else {
                    this.m_updateFirmware.setEnabled(reachable);
                }
            } else if (devType == 14) {
                this.oldCmdSet = false;
                if (this.GetVersion(strs[3]) >= 114 && this.GetVersion(strs[4]) >= 80) {
                    this.m_updateFirmware.setEnabled(false);
                } else {
                    this.m_updateFirmware.setEnabled(reachable);
                }
            } else if (devType == 11) {
                this.oldCmdSet = false;
                if (this.GetVersion(strs[3]) >= 116 && this.GetVersion(strs[4]) >= 80) {
                    this.m_updateFirmware.setEnabled(false);
                } else {
                    this.m_updateFirmware.setEnabled(reachable);
                }
            } else if (devType == 12) {
                this.oldCmdSet = false;
                if (this.GetVersion(strs[3]) >= 118 && this.GetVersion(strs[4]) >= 70) {
                    this.m_updateFirmware.setEnabled(false);
                } else {
                    this.m_updateFirmware.setEnabled(reachable);
                }
            } else if (devType == 10) {
                this.oldCmdSet = false;
                if (this.GetVersion(strs[3]) >= 60) {
                    this.m_updateFirmware.setEnabled(false);
                } else {
                    this.m_updateFirmware.setEnabled(reachable);
                }
            }
        }
        if (this.m_unitUseDHCP.isSelected()) {
            this.m_unitIP.setEnabled(false);
            this.m_unitNetmask.setEnabled(false);
            this.m_unitGateway.setEnabled(false);
        } else {
            this.m_unitIP.setEnabled(true);
            this.m_unitNetmask.setEnabled(true);
            this.m_unitGateway.setEnabled(true);
        }
        this.m_updateParams.setEnabled(false);
    }

    private void m_unitIPKeyReleased(KeyEvent evt) {
        this.m_updateParams.setEnabled(true);
    }

    private void m_unitNetmaskKeyTyped(KeyEvent evt) {
        this.m_updateParams.setEnabled(true);
    }

    private void m_unitGatewayKeyReleased(KeyEvent evt) {
        this.m_updateParams.setEnabled(true);
    }

    private void m_unitUseDHCPActionPerformed(ActionEvent evt) {
        this.m_updateParams.setEnabled(true);
        if (this.m_unitUseDHCP.isSelected()) {
            this.m_unitIP.setEnabled(false);
            this.m_unitNetmask.setEnabled(false);
            this.m_unitGateway.setEnabled(false);
        } else {
            this.m_unitIP.setEnabled(true);
            this.m_unitNetmask.setEnabled(true);
            this.m_unitGateway.setEnabled(true);
        }
    }

    private void UpdateNewWebPages(DatagramPacket pkt) {
        this.SendCmd(pkt.getAddress(), "SU,0\r\n", Cmd.SU, 100, 3);
        this.setCursor(Cursor.getPredefinedCursor(3));
        int ret = this.FTPTransfer(pkt.getAddress(), "0:/WebUI/index.htm", MODEL_MY_WEB_INDEX, 1, null, null, false);
        if (ret != 0) {
            if (ret == -1) {
                this.setCursor(Cursor.getDefaultCursor());
                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
            }
            ret = this.FTPTransfer(pkt.getAddress(), "0:/WebUI/index.htm", MODEL_MY_WEB_INDEX, 1, null, null, false);
            if (ret != 0) {
                if (ret == -1) {
                    this.setCursor(Cursor.getDefaultCursor());
                    JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                }
                ret = this.FTPTransfer(pkt.getAddress(), "0:/WebUI/index.htm", MODEL_MY_WEB_INDEX, 1, null, null, true);
                if (ret != 0) {
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
        ret = this.FTPTransfer(pkt.getAddress(), "0:/WebUI/favicon.ico", MODEL_MY_WEB_ICO, 1, null, null, false);
        if (ret != 0) {
            if (ret == -1) {
                this.setCursor(Cursor.getDefaultCursor());
                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
            }
            ret = this.FTPTransfer(pkt.getAddress(), "0:/WebUI/favicon.ico", MODEL_MY_WEB_ICO, 1, null, null, false);
            if (ret != 0) {
                if (ret == -1) {
                    this.setCursor(Cursor.getDefaultCursor());
                    JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                }
                ret = this.FTPTransfer(pkt.getAddress(), "0:/WebUI/favicon.ico", MODEL_MY_WEB_ICO, 1, null, null, true);
                if (ret != 0) {
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
        ret = this.FTPTransfer(pkt.getAddress(), "0:/WebUI/DuganCP.jar", MODEL_MY_WEB_JAR, 1, null, null, false);
        if (ret != 0) {
            if (ret == -1) {
                this.setCursor(Cursor.getDefaultCursor());
                JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
            }
            ret = this.FTPTransfer(pkt.getAddress(), "0:/WebUI/DuganCP.jar", MODEL_MY_WEB_JAR, 1, null, null, false);
            if (ret != 0) {
                if (ret == -1) {
                    this.setCursor(Cursor.getDefaultCursor());
                    JOptionPane.showMessageDialog(null, "Failed to connect to the controller!", "Connection Failure", 0);
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                }
                ret = this.FTPTransfer(pkt.getAddress(), "0:/WebUI/DuganCP.jar", MODEL_MY_WEB_JAR, 1, null, null, true);
                if (ret != 0) {
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void m_addUnitActionPerformed(ActionEvent evt) {
        String ipStr = JOptionPane.showInputDialog(this, "Unit IP Address :", "Add Unit Manually", -1);
        if (ipStr == null) {
            return;
        }
        if (ipStr.isEmpty()) {
            return;
        }
        try {
            InetAddress targetIP = InetAddress.getByName(ipStr);
            this.ScanIt(targetIP);
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void m_updateFirmwareMouseClicked(MouseEvent evt) {
        int modifiers = evt.getModifiersEx();
        if ((modifiers & 0x80) != 0) {
            this.m_updateFirmwareActionPerformed(new ActionEvent(evt.getSource(), evt.getID(), evt.paramString(), evt.getModifiersEx()));
        }
    }

    private void m_updateWebUIActionPerformed(ActionEvent evt) {
        boolean needReboot;
        DatagramPacket pkt;
        block22: {
            int which = this.m_unitList.getSelectedIndex();
            if (which == -1) {
                JOptionPane.showMessageDialog(this, "Please select an online unit first!");
                return;
            }
            pkt = this.devices.get(which);
            if (pkt == null) {
                return;
            }
            if (JOptionPane.showConfirmDialog(this, "Proceed to store Control Panel to unit?", "Control Panel Update Confirmation", 0, 3) == 1) {
                return;
            }
            byte[] inbuf = pkt.getData();
            String inStr = new String(inbuf).trim();
            String[] strs = inStr.split(",");
            int devType = Integer.parseInt(strs[0]);
            needReboot = false;
            if (strs.length == 8) {
                if (devType == 1) {
                    try {
                        try {
                            this.setCursor(Cursor.getPredefinedCursor(3));
                            this.m_progress.setText("Updating control panel web pages ...");
                            this.ProgramSDF(pkt.getAddress(), "dugane_v150.wdl", 256, false);
                            needReboot = true;
                            break block22;
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(this, String.format("Download Control Panel Interface file failed. Err: %s", ex.getMessage()));
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            this.setCursor(Cursor.getDefaultCursor());
                            this.m_progress.setText("Ready");
                            return;
                        }
                    }
                    finally {
                        this.setCursor(Cursor.getDefaultCursor());
                        this.m_progress.setText("Ready");
                    }
                }
                if (devType == 4) {
                    try {
                        try {
                            this.setCursor(Cursor.getPredefinedCursor(3));
                            this.m_progress.setText("Updating control panel web pages ...");
                            this.ProgramSDF(pkt.getAddress(), "dugane_v150.wdl", 256, false);
                            needReboot = true;
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(this, String.format("Download Control Panel Interface file failed. Err: %s", ex.getMessage()));
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            this.setCursor(Cursor.getDefaultCursor());
                            this.m_progress.setText("Ready");
                            return;
                        }
                    }
                    finally {
                        this.setCursor(Cursor.getDefaultCursor());
                        this.m_progress.setText("Ready");
                    }
                }
            } else if (strs.length >= 11) {
                if (devType == 5 || devType == 6 || devType == 8 || devType == 14 || devType == 7 || devType == 13 || devType == 9 || devType == 11 || devType == 12) {
                    this.m_progress.setText("Sending DuganCP-J to unit ...");
                    this.UpdateNewWebPages(pkt);
                    needReboot = false;
                    this.m_progress.setText("Ready");
                }
            } else {
                JOptionPane.showMessageDialog(this, "Selected unit has wrong network info!");
                return;
            }
        }
        if (needReboot) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.m_progress.setText("Rebooting ...");
            this.Reboot(pkt.getAddress());
            if (!this.SendCmd(pkt.getAddress(), "VE\r\n", Cmd.VE, 1000, 30)) {
                JOptionPane.showMessageDialog(this, "Unit failed to reboot!");
            }
            this.ScanIt(null);
            this.setCursor(Cursor.getDefaultCursor());
        }
        JOptionPane.showMessageDialog(this, "Control Panel files downloaded successfully.");
        this.m_progress.setText("Ready");
    }

    private void m_moreInfoActionPerformed(ActionEvent evt) {
        String msg;
        int which = this.m_unitList.getSelectedIndex();
        if (which == -1) {
            JOptionPane.showMessageDialog(this, "Please select an online unit first!");
            return;
        }
        DatagramPacket pkt = this.devices.get(which);
        if (pkt == null) {
            return;
        }
        byte[] inbuf = pkt.getData();
        String inStr = new String(inbuf).trim();
        String[] strs = inStr.split(",");
        if (strs.length == 8) {
            msg = "Mac Address " + this.currentMac + "\r\n" + this.currentFWVersion + "\r\n" + this.currentFPVersion + "\r\n";
        } else {
            msg = "Serial Number " + this.currentSerialNumber + "\r\n" + "Mac Address " + this.currentMac + "\r\n" + this.currentHardwareRevision + "\r\n" + this.currentFWVersion + "\r\n" + this.currentFPVersion + "\r\n";
            if (this.SendCmd(pkt.getAddress(), "WD\r\n", Cmd.WD, 100, 3)) {
                strs = this.returnedWD.split("\t");
                msg = String.valueOf(msg) + strs[0] + " seconds\r\n" + strs[1] + " seconds\r\n";
            }
            if (this.currentDevType == 9 && this.SendCmd(pkt.getAddress(), "FS\r\n", Cmd.FS, 100, 3)) {
                int status = Integer.parseInt(this.returnedFS.substring(2), 16);
                msg = String.valueOf(msg) + ((status & 2) != 0 ? "ADAT 1 signal present\r\n" : "ADAT 1 no signal\r\n");
                msg = String.valueOf(msg) + ((status & 4) != 0 ? "ADAT 2 signal present\r\n" : "ADAT 2 no signal\r\n");
                msg = String.valueOf(msg) + ((status & 8) != 0 ? "Console Clock Detected\r\n" : "Console Clock not present\r\n");
                msg = String.valueOf(msg) + ((status & 0x10) != 0 ? "Console AES 1 Detected\r\n" : "Console AES 1 not present\r\n");
                msg = String.valueOf(msg) + ((status & 0x20) != 0 ? "Console AES 2 Detected\r\n" : "Console AES 2 not present\r\n");
                msg = String.valueOf(msg) + ((status & 0x40) != 0 ? "Console AES 3 Detected\r\n" : "Console AES 3 not present\r\n");
                msg = String.valueOf(msg) + ((status & 0x80) != 0 ? "Console AES 4 Detected\r\n" : "Console AES 4 not present\r\n");
            }
        }
        JOptionPane.showMessageDialog(null, msg, "Unit Info", -1);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Dugan_Utility().setVisible(true);
            }
        });
    }

    private Cmd ReadSocket(int timeOut) {
        try {
            this.querySocket.setSoTimeout(timeOut);
            try {
                this.querySocket.receive(this.rcvrPacket);
                if (this.rcvrPacket.getLength() > 0) {
                    return this.ProcessPacket(this.rcvrPacket);
                }
            }
            catch (SocketTimeoutException ex) {
                return Cmd.TIMEOUT;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
            return Cmd.ERROR;
        }
        return Cmd.ERROR;
    }

    private Cmd ProcessPacket(DatagramPacket pkt) {
        String inStr;
        byte[] inbuf = pkt.getData();
        int inLen = pkt.getLength();
        String srcIP = pkt.getAddress().getHostAddress();
        System.out.printf("Packet from %s: %s", srcIP, new String(inbuf, 0, inLen));
        if (inbuf[0] == 42) {
            inbuf[0] = inbuf[1];
            inbuf[1] = inbuf[2];
            if (inbuf[3] == 44) {
                inbuf[3] = 32;
            }
            inStr = new String(inbuf, 3, inLen - 3).trim();
        } else {
            inStr = new String(inbuf, 2, inLen - 2).trim();
        }
        if (inStr.indexOf("Error") != -1) {
            return Cmd.ERROR;
        }
        String[] strs = inStr.split(",");
        if (inbuf[0] >= 97 && inbuf[0] <= 122) {
            inbuf[0] = (byte)(inbuf[0] - 97 + 65);
        }
        if (inbuf[1] >= 97 && inbuf[1] <= 122) {
            inbuf[1] = (byte)(inbuf[1] - 97 + 65);
        }
        switch (inbuf[0]) {
            case 68: {
                switch (inbuf[1]) {
                    case 76: {
                        switch (Integer.parseInt(strs[0])) {
                            case 0: {
                                return Cmd.DLS;
                            }
                            case 1: {
                                return Cmd.DLA;
                            }
                            case 2: {
                                return Cmd.DLD;
                            }
                            case 3: {
                                return Cmd.DLP_DSP;
                            }
                            case 4: {
                                return Cmd.DLP_LCA;
                            }
                            case 5: {
                                return Cmd.DLUS;
                            }
                            case 6: {
                                return Cmd.DLUD;
                            }
                            case 7: {
                                return Cmd.DLP_UCC;
                            }
                            case 8: {
                                return Cmd.DLP;
                            }
                        }
                        return Cmd.ERROR;
                    }
                }
                break;
            }
            case 70: {
                switch (inbuf[1]) {
                    case 83: {
                        this.returnedFS = strs[0];
                        return Cmd.FS;
                    }
                }
                break;
            }
            case 78: {
                switch (inbuf[1]) {
                    case 67: {
                        return Cmd.NC;
                    }
                    case 83: {
                        return Cmd.NS;
                    }
                }
                break;
            }
            case 82: {
                switch (inbuf[1]) {
                    case 66: {
                        return Cmd.RB;
                    }
                }
                break;
            }
            case 83: {
                switch (inbuf[1]) {
                    case 67: {
                        String str;
                        if (this.HasDevice(pkt)) {
                            return Cmd.SC;
                        }
                        if (strs.length != 8 && strs.length != 11 && strs.length != 12) {
                            return Cmd.ERROR;
                        }
                        InetAddress ipAddr = pkt.getAddress();
                        DatagramPacket pkt1 = new DatagramPacket(inStr.getBytes(), 1, ipAddr, pkt.getPort());
                        this.devices.add(pkt1);
                        int devType = Integer.parseInt(strs[0]);
                        if (strs.length == 8) {
                            switch (Integer.parseInt(strs[0])) {
                                case 1: {
                                    strs[0] = "Model E";
                                    break;
                                }
                                case 2: {
                                    strs[0] = "Model D-2";
                                    break;
                                }
                                case 3: {
                                    strs[0] = "Model D-3";
                                    break;
                                }
                                case 4: {
                                    strs[0] = "Model E-1";
                                    break;
                                }
                                default: {
                                    strs[0] = "Unknown Model";
                                }
                            }
                            str = String.valueOf(strs[1]) + " --- " + strs[0] + ", FW " + strs[2] + ", DP " + strs[3];
                        } else {
                            switch (devType) {
                                case 1: {
                                    strs[0] = "Model E";
                                    break;
                                }
                                case 2: {
                                    strs[0] = "Model D-2";
                                    break;
                                }
                                case 3: {
                                    strs[0] = "Model D-3";
                                    break;
                                }
                                case 4: 
                                case 6: {
                                    strs[0] = "Model E-1A";
                                    break;
                                }
                                case 7: {
                                    strs[0] = "Model E-2";
                                    break;
                                }
                                case 13: {
                                    strs[0] = "Model E-2A";
                                    break;
                                }
                                case 8: {
                                    strs[0] = "Model E-3";
                                    break;
                                }
                                case 14: {
                                    strs[0] = "Model E-3A";
                                    break;
                                }
                                case 5: {
                                    strs[0] = "Dugan-MY16";
                                    break;
                                }
                                case 9: {
                                    strs[0] = "Dugan-VN16";
                                    break;
                                }
                                case 10: {
                                    strs[0] = "Model K";
                                    break;
                                }
                                case 11: {
                                    strs[0] = "Model M";
                                    break;
                                }
                                case 12: {
                                    strs[0] = "Model N";
                                    break;
                                }
                                default: {
                                    strs[0] = "Unknown Model";
                                }
                            }
                            str = String.valueOf(strs[1]) + " --- " + strs[0] + ", " + strs[3] + ", " + strs[4] + ", SN:" + strs[2] + ", " + strs[5];
                        }
                        this.listModel.addElement(str);
                        if (this.listModel.size() == 1) {
                            this.m_unitList.setSelectedIndex(0);
                        }
                        return Cmd.SC;
                    }
                    case 85: {
                        return Cmd.SU;
                    }
                }
                break;
            }
            case 87: {
                switch (inbuf[1]) {
                    case 68: {
                        if (strs.length == 2) {
                            this.returnedWD = strs[1];
                        }
                        return Cmd.WD;
                    }
                }
                break;
            }
            case 86: {
                switch (inbuf[1]) {
                    case 69: {
                        System.out.printf("   Processed VE from %s\n", srcIP);
                        return Cmd.VE;
                    }
                }
            }
        }
        return Cmd.ERROR;
    }

    private void ScanIt(InetAddress target) {
        block28: {
            byte[] buf = new byte[10];
            if (target == null) {
                this.devices.clear();
                this.listModel.clear();
                this.m_networkPanel.setVisible(false);
                this.m_unitList.updateUI();
            }
            buf[0] = 83;
            buf[1] = 67;
            buf[2] = 13;
            buf[3] = 10;
            try {
                if (target == null) {
                    DatagramPacket pkt;
                    int i = 0;
                    while (i < this.m_nIFAddress) {
                        try {
                            pkt = new DatagramPacket(buf, 4, this.m_broadcastAddresses[i], 9776);
                            this.querySocket = new DatagramSocket(0, this.m_localAddresses[i]);
                            this.querySocket.setSoTimeout(1);
                            this.querySocket.send(pkt);
                            int j = 0;
                            while (j < 10) {
                                try {
                                    Thread.sleep(20L);
                                }
                                catch (InterruptedException ex) {
                                    Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                this.ReadSocket(1);
                                ++j;
                            }
                        }
                        catch (SocketException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        ++i;
                    }
                    try {
                        this.querySocket = new DatagramSocket();
                        this.querySocket.setSoTimeout(1);
                        InetAddress broadcast = InetAddress.getByName("255.255.255.255");
                        pkt = new DatagramPacket(buf, 4, broadcast, 9776);
                        try {
                            this.querySocket.send(pkt);
                            break block28;
                        }
                        catch (IOException ex) {
                            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    catch (SocketException ex) {
                        Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break block28;
                }
                DatagramPacket pkt = new DatagramPacket(buf, 4, target, 9776);
                if (this.m_nIFAddress == 1) {
                    try {
                        this.querySocket.send(pkt);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    return;
                }
                int i = 0;
                while (i < this.m_nIFAddress) {
                    try {
                        this.querySocket = new DatagramSocket(0, this.m_localAddresses[i]);
                        this.querySocket.setSoTimeout(1);
                        this.querySocket.send(pkt);
                        int j = 0;
                        while (j < 10) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            if (this.ReadSocket(1) != Cmd.SC) {
                                ++j;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (SocketException ex) {
                        Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    ++i;
                }
                try {
                    this.querySocket = new DatagramSocket();
                    this.querySocket.setSoTimeout(1);
                }
                catch (SocketException ex) {
                    Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void BroadcastNC(String cmd) {
        byte[] buf = cmd.getBytes();
        try {
            DatagramPacket pkt;
            int i = 0;
            while (i < this.m_nIFAddress) {
                try {
                    pkt = new DatagramPacket(buf, buf.length, this.m_broadcastAddresses[i], 9776);
                    DatagramSocket sock = new DatagramSocket(0, this.m_localAddresses[i]);
                    sock.setSoTimeout(1);
                    sock.send(pkt);
                    System.out.printf("NC sent to broadcast address %s on interface %s\n", this.m_broadcastAddresses[i].getHostAddress(), this.m_localAddresses[i].getHostAddress());
                }
                catch (Exception ex) {
                    Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                }
                ++i;
            }
            try {
                InetAddress broadcast = InetAddress.getByName("255.255.255.255");
                pkt = new DatagramPacket(buf, buf.length, broadcast, 9776);
                try {
                    this.querySocket.send(pkt);
                    System.out.printf("Broadcast packet sent\n", new Object[0]);
                }
                catch (IOException ex) {
                    Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private boolean HasDevice(DatagramPacket pkt) {
        int i = 0;
        while (i < this.devices.size()) {
            DatagramPacket p = this.devices.get(i);
            if (pkt.getPort() == p.getPort() && pkt.getAddress().equals(p.getAddress())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void GetLocalAddresses() {
        int j = 0;
        try {
            List<InterfaceAddress> addresses;
            NetworkInterface iface;
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                iface = en.nextElement();
                if (!iface.isUp()) continue;
                addresses = iface.getInterfaceAddresses();
                j += addresses.size();
            }
            this.m_nIFAddress = 0;
            if (j == 0) {
                this.m_localAddresses = null;
                return;
            }
            en = NetworkInterface.getNetworkInterfaces();
            this.m_localAddresses = new InetAddress[j];
            this.m_broadcastAddresses = new InetAddress[j];
            this.m_pcAddresses = "";
            while (en.hasMoreElements()) {
                iface = en.nextElement();
                if (!iface.isUp()) continue;
                addresses = iface.getInterfaceAddresses();
                int i = 0;
                while (i < addresses.size()) {
                    InetAddress addr = addresses.get(i).getAddress();
                    if (!(addr instanceof Inet6Address) && addr.getHostAddress().compareToIgnoreCase("127.0.0.1") != 0) {
                        if (!addr.isLoopbackAddress()) {
                            this.m_pcAddresses = String.valueOf(this.m_pcAddresses) + addr.getHostAddress() + "  ";
                        }
                        this.m_localAddresses[this.m_nIFAddress] = addr;
                        this.m_broadcastAddresses[this.m_nIFAddress] = addresses.get(i).getBroadcast();
                        ++this.m_nIFAddress;
                    }
                    ++i;
                }
            }
            this.m_localIP.setText(this.m_pcAddresses);
        }
        catch (SocketException ex) {
            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private boolean SendCmd(InetAddress targetIP, String cmdStr, Cmd cmd, int timeOut, int nTries) {
        System.out.printf("Packet sent: %s", cmdStr);
        DatagramPacket pkt = new DatagramPacket(cmdStr.getBytes(), cmdStr.length(), targetIP, 9776);
        int i = 0;
        while (i < nTries) {
            int nReads = (timeOut + 4) / 5;
            try {
                this.querySocket.send(pkt);
            }
            catch (IOException ex) {
                Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
            }
            int j = 0;
            while (j < nReads) {
                Cmd ret = this.ReadSocket(5);
                if (ret == cmd) {
                    return true;
                }
                if (ret != Cmd.TIMEOUT) {
                    System.out.printf("Expected %s. ReadSocket returned %s\n", cmd.name(), ret.name());
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private boolean IsReachable(DatagramPacket pkt) {
        String[] netmask;
        if (this.m_localAddresses.length == 0) {
            return false;
        }
        byte[] inbuf = pkt.getData();
        String inStr = new String(inbuf).trim();
        String[] strs = inStr.split(",");
        InetAddress ip = pkt.getAddress();
        try {
            if (ip.isReachable(250)) {
                return true;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (strs.length == 8) {
            netmask = strs[6].split("\\.");
        } else if (strs.length >= 11) {
            netmask = strs[8].split("\\.");
        } else {
            return false;
        }
        byte[] nmask = new byte[]{(byte)Integer.parseInt(netmask[0]), (byte)Integer.parseInt(netmask[1]), (byte)Integer.parseInt(netmask[2]), (byte)Integer.parseInt(netmask[3])};
        byte[] newIP = pkt.getAddress().getAddress();
        int i = 0;
        while (i < this.m_localAddresses.length) {
            byte[] localAddress;
            if (this.m_localAddresses[i] != null && !this.m_localAddresses[i].isLoopbackAddress() && (nmask[0] & newIP[0]) == (nmask[0] & (localAddress = this.m_localAddresses[i].getAddress())[0]) && (nmask[1] & newIP[1]) == (nmask[1] & localAddress[1]) && (nmask[2] & newIP[2]) == (nmask[2] & localAddress[2]) && (nmask[3] & newIP[3]) == (nmask[3] & localAddress[3])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int FTPTransfer(InetAddress server, String remoteFile, String localFile, int isSend, String siteCmdBefore, String siteCmdAfter, boolean prompt) {
        int ret;
        block53: {
            int reply;
            ret = 0;
            String username = "fire";
            String password = "escape";
            FTPClient ftp = new FTPClient();
            try {
                ftp.connect(server);
                reply = ftp.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)reply)) {
                    ftp.disconnect();
                    if (prompt) {
                        JOptionPane.showMessageDialog(null, "Controller refused FTP connection!", "FTP No Connection", 0);
                    }
                    return -1;
                }
            }
            catch (IOException e) {
                if (ftp.isConnected()) {
                    try {
                        ftp.disconnect();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (prompt) {
                    JOptionPane.showMessageDialog(null, "Could not connect to controller with FTP!", "FTP No Connection", 0);
                }
                return -1;
            }
            try {
                if (!ftp.login(username, password)) {
                    if (prompt) {
                        JOptionPane.showMessageDialog(null, "Could not login to controller with FTP!", "FTP Login", 0);
                    }
                    try {
                        ftp.disconnect();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return -1;
                }
                try {
                    block52: {
                        if (siteCmdBefore != null) {
                            try {
                                ftp.sendSiteCommand(siteCmdBefore);
                            }
                            catch (IOException ex) {
                                if (!prompt) break block52;
                                JOptionPane.showMessageDialog(null, "Site command before file transfer failed! Error: " + ex.getMessage(), "FTP Transfer", 0);
                            }
                        }
                    }
                    ftp.setFileType(2);
                    if (isSend != 0) {
                        InputStream input = this.getClass().getResourceAsStream(localFile);
                        if (input == null && prompt) {
                            String msg = String.format("Cannot open resource file %s", localFile);
                            JOptionPane.showMessageDialog(null, msg, "FTP Transfer", 0);
                            try {
                                ftp.quit();
                                ftp.disconnect();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            ret = -2;
                        }
                        try {
                            ftp.storeFile(remoteFile, input);
                            reply = ftp.getReplyCode();
                            if (!FTPReply.isPositiveCompletion((int)reply)) {
                                this.ftpErrorMsg = ftp.getReplyString();
                                if (prompt) {
                                    JOptionPane.showMessageDialog(null, "File transfer failed - " + this.ftpErrorMsg);
                                }
                                System.out.println(ftp.getReplyString());
                                ret = -3;
                            }
                        }
                        catch (IOException ex) {
                            if (prompt) {
                                JOptionPane.showMessageDialog(null, "File transfer failed - " + ex.getLocalizedMessage(), "FTP_Transfer", 0);
                            }
                            input.close();
                            ret = -2;
                        }
                        input.close();
                    } else {
                        FileOutputStream output = new FileOutputStream(localFile);
                        ftp.retrieveFile(remoteFile, (OutputStream)output);
                        ((OutputStream)output).close();
                    }
                    if (siteCmdAfter == null) break block53;
                    try {
                        ftp.sendSiteCommand(siteCmdAfter);
                        reply = ftp.getReplyCode();
                        if (!FTPReply.isPositiveCompletion((int)reply)) {
                            this.ftpErrorMsg = ftp.getReplyString();
                            if (prompt) {
                                JOptionPane.showMessageDialog(null, "File transfer failed - " + this.ftpErrorMsg);
                            }
                            System.out.println(ftp.getReplyString());
                            ret = -3;
                        }
                    }
                    catch (IOException ex) {
                        if (siteCmdAfter.equalsIgnoreCase("FLSH")) {
                            System.out.println(ex.getMessage());
                            if (ex.getMessage().compareToIgnoreCase("Connection reset") != 0) {
                                ftp.quit();
                                ftp.disconnect();
                                ret = -3;
                            }
                        } else if (prompt) {
                            JOptionPane.showMessageDialog(null, "File transfer succeeded. But site command failed!", "FTP Transfer", 0);
                        }
                    }
                }
                catch (IOException ex) {
                    if (!ex.getMessage().contains("Connection reset")) {
                        if (prompt) {
                            JOptionPane.showMessageDialog(null, "File transfer failed!", "FTP Transfer", 0);
                        }
                    } else if (prompt) {
                        JOptionPane.showMessageDialog(null, "File transfer failed - " + ex.getLocalizedMessage(), "FTP_Transfer", 0);
                    }
                    Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                    ret = -2;
                }
            }
            finally {
                if (ftp.isConnected()) {
                    try {
                        ftp.quit();
                        ftp.disconnect();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return ret;
    }

    private void DownloadToUCC(InetAddress targetIP, String f, int model) throws IOException {
        int i;
        byte chksum;
        String outStr;
        byte[] buf = new byte[542];
        byte[] inbuf = new byte[65536];
        Arrays.fill(inbuf, (byte)0);
        int addressMax = 0;
        try (BufferedReader br = null;){
            br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(f)));
            outStr = br.readLine();
            while (outStr != null) {
                byte inChksum;
                if (outStr.length() < 11) {
                    throw new IOException("Incorrect file format detected!");
                }
                if (!outStr.startsWith(":")) {
                    throw new IOException("Incorrect file format detected!");
                }
                int nBytes = Integer.parseInt(outStr.substring(1, 3), 16);
                int address = Integer.parseInt(outStr.substring(3, 7), 16);
                int cmd = Integer.parseInt(outStr.substring(7, 9), 16);
                chksum = (byte)(nBytes + cmd + (address & 0xFF) + address / 256);
                if (cmd == 1) {
                    inChksum = (byte)Integer.parseInt(outStr.substring(9, 11), 16);
                    if ((chksum = (byte)(~chksum + 1 & 0xFF)) == inChksum) {
                        break;
                    }
                    throw new IOException("EOF record has wrong check sum!");
                }
                if (cmd != 0) continue;
                int j = 9;
                i = 0;
                while (i < nBytes) {
                    byte val = (byte)Integer.parseInt(outStr.substring(j, j + 2), 16);
                    inbuf[address++] = val;
                    chksum = (byte)(chksum + val);
                    j += 2;
                    ++i;
                }
                inChksum = (byte)Integer.parseInt(outStr.substring(j, j + 2), 16);
                if ((chksum = (byte)(~chksum + 1 & 0xFF)) != inChksum) {
                    throw new IOException("Record has wrong check sum!");
                }
                if (address < 65535 && address > addressMax) {
                    addressMax = address;
                }
                outStr = br.readLine();
            }
        }
        int fileModel = -1;
        i = 0;
        while (i < addressMax) {
            String str = new String(inbuf, i, 9);
            if (str.compareTo("Model E-1") == 0) {
                fileModel = 4;
                break;
            }
            if (str.compareTo("Model E-0") == 0) {
                fileModel = 1;
                break;
            }
            ++i;
        }
        if (fileModel == -1) {
            throw new IOException("File does not have a valid signature!");
        }
        if (fileModel != model) {
            throw new IOException("File signature does not match the unit model!");
        }
        chksum = 0;
        i = 0;
        while (i < addressMax) {
            chksum = (byte)(chksum + inbuf[i]);
            ++i;
        }
        int nBlocks = addressMax / 512;
        int remains = addressMax % 512;
        this.SendCmd(targetIP, "VE\r\n", Cmd.VE, 100, 3);
        outStr = String.format("DL5,%d", addressMax);
        if (!this.SendCmd(targetIP, outStr, Cmd.DLUS, 100, 5)) {
            throw new IOException("Failed to send Download UCC Setup command to device!");
        }
        i = 0;
        while (i < nBlocks + 1) {
            int len = i < nBlocks ? 512 : remains;
            outStr = String.format("DL6,%d,%d,", i * 512, len);
            System.arraycopy(outStr.getBytes(), 0, buf, 0, outStr.length());
            System.arraycopy(inbuf, i * 512, buf, outStr.length(), len);
            if (!this.SendBufferCmd(targetIP, buf, len += outStr.length(), Cmd.DLUD, 100, 3)) {
                throw new IOException(String.format("Failed to send block %d of %d", i + 1, nBlocks + 1));
            }
            ++i;
        }
        outStr = String.format("DL7,%d", chksum & 0xFF);
        this.SendCmd(targetIP, outStr, Cmd.DLP_UCC, 100, 5);
    }

    private boolean Reboot(InetAddress targetIP) {
        byte[] buf = new byte[8];
        if (this.oldCmdSet) {
            buf[0] = 82;
            buf[1] = 66;
            buf[2] = -69;
            buf[3] = 30;
            return this.SendBufferCmd(targetIP, buf, 4, Cmd.RB, 100, 5);
        }
        buf[0] = 82;
        buf[1] = 101;
        buf[2] = 98;
        buf[3] = 111;
        buf[4] = 111;
        buf[5] = 116;
        buf[6] = 13;
        buf[7] = 10;
        this.SendBufferCmd(targetIP, buf, 8, Cmd.REBOOT, 100, 3);
        return true;
    }

    private boolean SendBufferCmd(InetAddress targetIP, byte[] buf, int length, Cmd cmd, int timeOut, int nTries) {
        int nReads = (timeOut + 4) / 5;
        DatagramPacket p = new DatagramPacket(buf, length, targetIP, 9776);
        int i = 0;
        while (i < nTries) {
            block5: {
                try {
                    this.querySocket.send(p);
                }
                catch (IOException ex) {
                    Logger.getLogger(Dugan_Utility.class.getName()).log(Level.SEVERE, null, ex);
                    break block5;
                }
                int j = 0;
                while (j < nReads) {
                    if (this.ReadSocket(5) == cmd) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private void ProgramSDF(InetAddress targetIP, String f, int startPage, boolean needReboot) throws IOException {
        byte[] buf = new byte[294];
        this.SendCmd(targetIP, "VE\r\n", Cmd.VE, 100, 3);
        InputStream fis = this.getClass().getResourceAsStream(f);
        int nBlocks = fis.available() / 264;
        try {
            int i = 0;
            while (i < nBlocks) {
                String outStr = String.format("DL8,%d,", startPage);
                System.arraycopy(outStr.getBytes(), 0, buf, 0, outStr.length());
                int byteRead = 0;
                while (byteRead < 264) {
                    byteRead += fis.read(buf, outStr.length() + byteRead, 264 - byteRead);
                }
                if (!this.SendBufferCmd(targetIP, buf, outStr.length() + 264, Cmd.DLP, 100, 3)) {
                    throw new IOException(String.format("Failed to send block %d of %d", i + 1, nBlocks + 1));
                }
                ++startPage;
                ++i;
            }
        }
        finally {
            fis.close();
        }
        if (needReboot) {
            this.Reboot(targetIP);
            if (!this.SendCmd(targetIP, "VE\r\n", Cmd.VE, 1000, 30)) {
                throw new IOException("Unit reboot failed!");
            }
            this.ScanIt(null);
        }
    }

    private void DownloadToSDF(InetAddress targetIP, String f, Cmd cmd, boolean reboot) throws IOException {
        int j;
        byte[] buf = new byte[542];
        InputStream fis = this.getClass().getResourceAsStream(f);
        this.SendCmd(targetIP, "VE\r\n", Cmd.VE, 100, 3);
        int nBlocks = fis.available() / 512;
        int remains = fis.available() % 512;
        String outStr = String.format("DL0,%d", fis.available());
        if (!this.SendCmd(targetIP, outStr, Cmd.DLS, 100, 5)) {
            throw new IOException("Failed to send Download Setup command to device!");
        }
        int chksum = 0;
        try {
            int i = 0;
            while (i < nBlocks + 1) {
                int len = i < nBlocks ? 512 : remains;
                outStr = String.format("DL2,%d,%d,", i * 512, len);
                System.arraycopy(outStr.getBytes(), 0, buf, 0, outStr.length());
                int byteRead = 0;
                while (byteRead < len) {
                    byteRead += fis.read(buf, outStr.length() + byteRead, len - byteRead);
                }
                len += outStr.length();
                j = outStr.length();
                while (j < len) {
                    chksum += buf[j];
                    ++j;
                }
                if (!this.SendBufferCmd(targetIP, buf, len, Cmd.DLD, 100, 3)) {
                    throw new IOException(String.format("Failed to send block %d of %d", i + 1, nBlocks + 1));
                }
                ++i;
            }
        }
        finally {
            fis.close();
        }
        if (cmd == Cmd.DLP_DSP) {
            j = 3;
        } else if (cmd == Cmd.DLP_LCA) {
            j = 4;
        } else {
            throw new IOException("Unknown download type!");
        }
        outStr = String.format("DL%d,%d", j, chksum & 0xFF);
        if (!this.SendCmd(targetIP, outStr, cmd, 3000, 5)) {
            throw new IOException("Failed to send the program command!");
        }
        if (reboot) {
            this.Reboot(targetIP);
            if (!this.SendCmd(targetIP, "VE\r\n", Cmd.VE, 1000, 30)) {
                throw new IOException("Unit reboot failed!");
            }
            this.ScanIt(null);
        }
    }

    private static enum Cmd {
        DLA,
        DLD,
        DLP,
        DLP_DSP,
        DLP_LCA,
        DLP_UCC,
        DLS,
        DLUD,
        DLUS,
        ERROR,
        FS,
        NC,
        NS,
        FP,
        RB,
        REBOOT,
        SC,
        SU,
        TIMEOUT,
        VE,
        WD;

    }
}

